/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.FontRegistry;
import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.GenericFont;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.PACKAGE;
import de.intarsys.cwt.freetype.Face;
import de.intarsys.cwt.freetype.Freetype;
import de.intarsys.cwt.freetype.Library;
import de.intarsys.tools.installresource.InstallFileList;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.font.FontManager;

public class FontEnvironment {
    private static final Logger Log = PACKAGE.Log;
    private static FontEnvironment Unique = new FontEnvironment();
    private List<ClassLoader> fontClassLoaders = new ArrayList<ClassLoader>();
    private List<File> fontDirectories = new ArrayList<File>();
    private List<File> fontFiles = new ArrayList<File>();
    private boolean registeredSystem = false;
    private boolean registeredUser = false;

    public static FontEnvironment get() {
        return Unique;
    }

    public static void set(FontEnvironment fontEnvironment) {
        Unique = fontEnvironment;
    }

    public FontEnvironment() {
        this.registerFontClassLoader(this.getClass().getClassLoader());
    }

    public synchronized ClassLoader[] getFontClassLoaders() {
        return this.fontClassLoaders.toArray(new ClassLoader[this.fontClassLoaders.size()]);
    }

    public synchronized File[] getFontDirectories() {
        return this.fontDirectories.toArray(new File[this.fontDirectories.size()]);
    }

    public synchronized File[] getFontFiles() {
        return this.fontFiles.toArray(new File[this.fontFiles.size()]);
    }

    public synchronized File[] getSystemFontDirectories() {
        String string = null;
        Font.decode("dummy").getFamily();
        string = FontManager.getFontPath((boolean)true);
        if (string == null) {
            return new File[0];
        }
        String[] stringArray = string.split(System.getProperty("path.separator"));
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    protected void loadFontClassLoader(Library library, ClassLoader classLoader) {
        try {
            InstallFileList installFileList = new InstallFileList("fonts", "fonts.list", false);
            installFileList.loadAll();
            File[] fileArray = installFileList.getFiles();
            int n = 0;
            while (n < fileArray.length) {
                File file = fileArray[n];
                File[] fileArray2 = file.listFiles();
                int n2 = 0;
                while (n2 < fileArray2.length) {
                    File file2 = fileArray2[n2];
                    try {
                        this.processFontFile(library, file2);
                    }
                    catch (IOException iOException) {
                        Log.log(Level.WARNING, "error loading font '" + file2.getName() + "'", iOException);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            Log.log(Level.WARNING, "error looking up 'font/fonts.list' resources", iOException);
        }
    }

    protected void loadFontDirectory(Library library, File file) {
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            this.loadFontFile(library, file2);
            ++n;
        }
    }

    protected void loadFontFile(Library library, File file) {
        if (!file.isFile()) {
            return;
        }
        String string = file.getAbsolutePath();
        try {
            if (!string.equals(file.getCanonicalPath())) {
                return;
            }
        }
        catch (IOException iOException) {
            return;
        }
        this.loadFontUnchecked(library, string);
    }

    protected void loadFontMapClassLoader(Library library, ClassLoader classLoader) {
        try {
            Enumeration<URL> enumeration = classLoader.getResources("fonts/fonts.maps");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = uRL.openStream();
                        this.parseMaps(library, classLoader, inputStream);
                    }
                    catch (IOException iOException) {
                        Log.log(Level.WARNING, "error loading 'fonts/fonts.maps' from '" + uRL + "'", iOException);
                        StreamTools.close((InputStream)inputStream);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    StreamTools.close((InputStream)inputStream);
                    throw throwable;
                }
                StreamTools.close((InputStream)inputStream);
            }
        }
        catch (IOException iOException) {
            Log.log(Level.WARNING, "error looking up 'font/fonts.maps' resources", iOException);
        }
    }

    protected IFont loadFontUnchecked(Library library, String string) {
        FileLocator fileLocator = new FileLocator(string);
        Face face = library.newFace(string, 0);
        if (face != null) {
            GenericFont genericFont = GenericFont.createNew((ILocator)fileLocator, face);
            try {
                FontRegistry.get().registerFont(genericFont);
            }
            finally {
                face.doneFace();
            }
            return genericFont;
        }
        return null;
    }

    protected void loadSystemFonts(Library library) {
        File[] fileArray = this.getSystemFontDirectories();
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            this.loadFontDirectory(library, file);
            ++n;
        }
    }

    protected void loadUserFonts(Library library) {
        File file;
        File[] fileArray = this.getFontDirectories();
        int n = 0;
        while (n < fileArray.length) {
            file = fileArray[n];
            this.loadFontDirectory(library, file);
            ++n;
        }
        fileArray = this.getFontFiles();
        n = 0;
        while (n < fileArray.length) {
            file = fileArray[n];
            this.loadFontFile(library, file);
            ++n;
        }
        ClassLoader[] classLoaderArray = this.getFontClassLoaders();
        int n2 = 0;
        while (n2 < classLoaderArray.length) {
            ClassLoader classLoader = classLoaderArray[n2];
            this.loadFontClassLoader(library, classLoader);
            this.loadFontMapClassLoader(library, classLoader);
            ++n2;
        }
    }

    protected void parseMaps(Library library, ClassLoader classLoader, InputStream inputStream) throws IOException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        int n = inputStream.read();
        while (n != -1) {
            if (n == 10) {
                string = stringBuilder.toString().trim();
                this.processFontMap(library, classLoader, string);
                stringBuilder.setLength(0);
                n = inputStream.read();
                continue;
            }
            stringBuilder.append((char)n);
            n = inputStream.read();
        }
        string = stringBuilder.toString().trim();
        this.processFontMap(library, classLoader, string);
    }

    protected void processFontFile(Library library, File file) throws IOException {
        IFont iFont = this.loadFontUnchecked(library, file.getAbsolutePath());
        if (iFont == null) {
            return;
        }
        FontTools.mapFont(iFont.getFontName(), iFont);
    }

    protected void processFontMap(Library library, ClassLoader classLoader, String string) throws IOException {
        if (string.length() == 0 || string.startsWith("#")) {
            return;
        }
        String[] stringArray = string.split("\\=");
        if (stringArray.length < 2) {
            return;
        }
        FontTools.mapAlias(stringArray[0], stringArray[1]);
    }

    public synchronized void registerFontClassLoader(ClassLoader classLoader) {
        this.fontClassLoaders.add(classLoader);
    }

    public synchronized void registerFontDirectory(File file) {
        this.fontDirectories.add(file);
    }

    public synchronized void registerFontFile(File file) {
        this.fontFiles.add(file);
    }

    public synchronized void registerSystemFonts() {
        if (this.registeredSystem) {
            return;
        }
        this.registeredSystem = true;
        Library library = Freetype.initFreeType();
        try {
            this.loadSystemFonts(library);
        }
        finally {
            library.doneFreeType();
        }
    }

    public synchronized void registerUserFonts() {
        if (this.registeredUser) {
            return;
        }
        this.registeredUser = true;
        Library library = Freetype.initFreeType();
        try {
            this.loadUserFonts(library);
        }
        finally {
            library.doneFreeType();
        }
    }
}

