/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.IFontQuery;

public class FontQuery
implements IFontQuery {
    private String fontType = null;
    private String fontFamilyName;
    private String fontName;
    private FontStyle fontStyle;

    public FontQuery() {
    }

    public FontQuery(String string) {
        this.setFontName(string);
    }

    public FontQuery(String string, FontStyle fontStyle) {
        this.setFontFamilyName(string);
        this.setFontStyle(fontStyle);
    }

    public FontQuery(String string, String string2) {
        this.setFontFamilyName(string);
        this.setFontStyle(FontStyle.getFontStyle(string2));
    }

    public String getFontFamilyName() {
        if (this.fontFamilyName == null) {
            return FontTools.getFontFamilyName(this.fontName);
        }
        return this.fontFamilyName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public Object getFontNameCanonical() {
        String string = this.getFontFamilyName();
        FontStyle fontStyle = null;
        fontStyle = this.getFontStyle() == null ? FontTools.getFontStyle(this.fontName) : this.getFontStyle();
        return FontTools.createCanonicalName(string, fontStyle.getId());
    }

    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    public String getFontType() {
        return this.fontType;
    }

    public void setFontFamilyName(String string) {
        this.fontFamilyName = string;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    public void setFontType(String string) {
        this.fontType = string;
    }
}

