/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.FontEnvironment;
import de.intarsys.cwt.font.FontFamily;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.IFontFamily;
import de.intarsys.cwt.font.IFontQuery;
import de.intarsys.cwt.font.IFontRegistry;
import de.intarsys.tools.collection.ListTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StandardFontRegistry
implements IFontRegistry {
    private Map<String, IFontFamily> fontFamilyMap = new HashMap<String, IFontFamily>();
    private List<IFontFamily> fontFamilies = new ArrayList<IFontFamily>();
    private Map<String, Object> fontMap = new HashMap<String, Object>();
    private List<IFont> fonts = new ArrayList<IFont>();

    protected IFont basicLookup(String string, IFontQuery iFontQuery) {
        if (string == null) {
            return null;
        }
        Object object = this.fontMap.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof IFont) {
            return (IFont)object;
        }
        for (IFont iFont : (List)object) {
            if (!this.basicMatchFamilyStyle(iFontQuery, iFont)) continue;
            return iFont;
        }
        for (IFont iFont : (List)object) {
            if (!this.basicMatchFamily(iFontQuery, iFont)) continue;
            return iFont;
        }
        return null;
    }

    protected boolean basicMatchFamily(IFontQuery iFontQuery, IFont iFont) {
        return iFontQuery.getFontFamilyName().indexOf(iFont.getFontFamilyName()) >= 0;
    }

    protected boolean basicMatchFamilyStyle(IFontQuery iFontQuery, IFont iFont) {
        return iFontQuery.getFontNameCanonical().equals(iFont.getFontNameCanonical());
    }

    protected void basicRegister(String string, IFont iFont) {
        Object object = this.fontMap.put(string, iFont);
        if (object == null) {
            return;
        }
        if (object instanceof List) {
            ((List)object).add(iFont);
            this.fontMap.put(string, object);
        } else {
            this.fontMap.put(string, ListTools.with((Object)object, (Object)iFont));
        }
    }

    public synchronized IFontFamily[] getFontFamilies() {
        FontEnvironment.get().registerUserFonts();
        FontEnvironment.get().registerSystemFonts();
        return this.fontFamilies.toArray(new IFontFamily[this.fontFamilies.size()]);
    }

    public synchronized IFont[] getFonts() {
        FontEnvironment.get().registerUserFonts();
        FontEnvironment.get().registerSystemFonts();
        return this.fonts.toArray(new IFont[this.fonts.size()]);
    }

    protected Object getLookupKeyFontFamily(IFontQuery iFontQuery) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        if (iFontQuery.getFontType() == null) {
            stringBuilder.append("Any");
        } else {
            stringBuilder.append(iFontQuery.getFontType());
        }
        stringBuilder.append("]");
        stringBuilder.append(iFontQuery.getFontFamilyName());
        return stringBuilder.toString();
    }

    protected String getLookupKeyFontName(IFontQuery iFontQuery) {
        if (iFontQuery.getFontName() == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        if (iFontQuery.getFontType() == null) {
            stringBuilder.append("Any");
        } else {
            stringBuilder.append(iFontQuery.getFontType());
        }
        stringBuilder.append("]");
        stringBuilder.append(iFontQuery.getFontName());
        return stringBuilder.toString();
    }

    protected String getLookupKeyFontNameCanonical(IFontQuery iFontQuery) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        if (iFontQuery.getFontType() == null) {
            stringBuilder.append("Any");
        } else {
            stringBuilder.append(iFontQuery.getFontType());
        }
        stringBuilder.append("-canonical]");
        stringBuilder.append(iFontQuery.getFontNameCanonical());
        return stringBuilder.toString();
    }

    protected String getLookupKeyFontNamePostScript(IFontQuery iFontQuery) {
        if (iFontQuery.getFontName() == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        if (iFontQuery.getFontType() == null) {
            stringBuilder.append("Any");
        } else {
            stringBuilder.append(iFontQuery.getFontType());
        }
        stringBuilder.append("-postscript]");
        stringBuilder.append(iFontQuery.getFontName());
        return stringBuilder.toString();
    }

    public IFont lookupFont(IFontQuery iFontQuery) {
        IFont iFont = this.basicLookup(this.getLookupKeyFontName(iFontQuery), iFontQuery);
        if (iFont == null && (iFont = this.basicLookup(this.getLookupKeyFontNamePostScript(iFontQuery), iFontQuery)) == null) {
            iFont = this.basicLookup(this.getLookupKeyFontNameCanonical(iFontQuery), iFontQuery);
        }
        return iFont;
    }

    public IFontFamily lookupFontFamily(IFontQuery iFontQuery) {
        return this.fontFamilyMap.get(this.getLookupKeyFontFamily(iFontQuery));
    }

    public void registerFont(IFont iFont) {
        Object object;
        String string;
        String string2 = iFont.getFontType();
        String string3 = iFont.getFontFamilyName();
        if (string3 != null) {
            string = "[" + string2 + "]" + string3;
            object = this.fontFamilyMap.get(string);
            if (object == null) {
                object = new FontFamily(string3);
                this.fontFamilyMap.put(string, (IFontFamily)object);
                this.fontFamilies.add((IFontFamily)object);
            }
            object.registerFont(iFont);
            string = "[Any]" + string3;
            object = this.fontFamilyMap.get(string);
            if (object == null) {
                object = new FontFamily(string3);
                this.fontFamilyMap.put(string, (IFontFamily)object);
            }
            object.registerFont(iFont);
        }
        string = iFont.getFontName();
        object = iFont.getFontNamePostScript();
        String string4 = iFont.getFontNameCanonical();
        String string5 = "[" + string2 + "]" + string;
        this.basicRegister(string5, iFont);
        string5 = "[" + string2 + "-postscript]" + (String)object;
        this.basicRegister(string5, iFont);
        string5 = "[" + string2 + "-canonical]" + string4;
        this.basicRegister(string5, iFont);
        string5 = "[Any]" + string;
        this.basicRegister(string5, iFont);
        string5 = "[Any-postscript]" + (String)object;
        this.basicRegister(string5, iFont);
        string5 = "[Any-canonical]" + string4;
        this.basicRegister(string5, iFont);
        this.fonts.add(iFont);
    }

    protected String removeSpaces(String string) {
        int n = 0;
        while ((n = string.indexOf(32)) != -1) {
            string = String.valueOf(string.substring(0, n)) + string.substring(n + 1);
        }
        return string;
    }
}

