/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.hybrid.image;

import de.intarsys.cwt.awt.image.IAwtImage;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.hybrid.image.CwtHybridImage;
import de.intarsys.cwt.hybrid.image.ImageIOImageContainer;
import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.image.IImageContainer;
import de.intarsys.cwt.image.ImageEntry;
import de.intarsys.cwt.swt.image.ISwtImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class ImageIOImageEntry
extends ImageEntry
implements IAwtImage,
ISwtImage {
    private static final int width = 400;
    private static final int height = 400;
    private int index;

    public ImageIOImageEntry(IImageContainer iImageContainer, int n) {
        super(iImageContainer);
        this.index = n;
    }

    public void drawFromGraphicsContext(IGraphicsContext iGraphicsContext, float f, float f2) {
        this.getDelegate().drawFromGraphicsContext(iGraphicsContext, f, f2);
    }

    public BufferedImage getBufferedImage() {
        return ((IAwtImage)this.getDelegate()).getBufferedImage();
    }

    protected synchronized IImage getErrorImage(Exception exception) {
        BufferedImage bufferedImage = new BufferedImage(400, 400, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.WHITE);
        graphics2D.fillRect(0, 0, 400, 400);
        graphics2D.setColor(Color.RED);
        graphics2D.drawLine(0, 0, 400, 400);
        graphics2D.drawLine(0, 400, 400, 0);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString("error loading image (" + exception.getMessage() + ")", 10, 20);
        return new CwtHybridImage(bufferedImage);
    }

    public Image getImage(Device device) {
        return ((ISwtImage)this.getDelegate()).getImage(device);
    }

    public ImageData getImageData() {
        return ((ISwtImage)this.getDelegate()).getImageData();
    }

    public int getIndex() {
        return this.index;
    }

    protected IImage loadContent() throws IOException {
        return this.myContainer().loadImage(this.getIndex());
    }

    private ImageIOImageContainer myContainer() {
        return (ImageIOImageContainer)this.getContainer();
    }
}

