/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.image;

import de.intarsys.cwt.image.ImageException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Node;

public class ImageTools {
    public static String extractJPEGColorSpaceType(ImageReader imageReader) throws IOException {
        IIOMetadata iIOMetadata;
        try {
            iIOMetadata = imageReader.getImageMetadata(0);
        }
        catch (RuntimeException runtimeException) {
            throw new ImageException(runtimeException);
        }
        catch (IIOException iIOException) {
            throw new ImageException(iIOException);
        }
        Node node = iIOMetadata.getAsTree("javax_imageio_1.0");
        Node node2 = node.getFirstChild();
        while (!node2.getLocalName().equals("Chroma")) {
            node2 = node2.getNextSibling();
        }
        Node node3 = node2.getFirstChild();
        while (!node3.getLocalName().equals("ColorSpaceType")) {
            node3 = node3.getNextSibling();
        }
        Node node4 = node3.getAttributes().getNamedItem("name");
        if (node4 == null) {
            throw new ImageException("color space not declared");
        }
        return node4.getNodeValue();
    }

    public static String extractJPEGColorSpaceType(InputStream inputStream) throws IOException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        try {
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            if (!iterator.hasNext()) {
                throw new ImageException("no reader for this image type");
            }
            ImageReader imageReader = iterator.next();
            try {
                imageInputStream.reset();
                imageReader.setInput(imageInputStream);
                String string = ImageTools.extractJPEGColorSpaceType(imageReader);
                imageReader.dispose();
                return string;
            }
            catch (Throwable throwable) {
                imageReader.dispose();
                throw throwable;
            }
        }
        finally {
            imageInputStream.close();
        }
    }
}

