/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.main.Base64Coding;
import freemind.main.FreeMindMain;
import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Tools {
    public static final Set executableExtensions = new HashSet<String>(Arrays.asList("exe", "com", "vbs", "bat", "lnk"));
    private static Set availableFontFamilyNames = null;
    private static String[] sEnvFonts = null;
    public static final String JAVA_VERSION = System.getProperty("java.version");

    public static boolean executableByExtension(String file) {
        return executableExtensions.contains(Tools.getExtension(file));
    }

    public static String colorToXml(Color col) {
        if (col == null) {
            return null;
        }
        String red = Integer.toHexString(col.getRed());
        if (col.getRed() < 16) {
            red = "0" + red;
        }
        String green = Integer.toHexString(col.getGreen());
        if (col.getGreen() < 16) {
            green = "0" + green;
        }
        String blue = Integer.toHexString(col.getBlue());
        if (col.getBlue() < 16) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }

    public static Color xmlToColor(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 7) {
            int red = Integer.parseInt(string.substring(1, 3), 16);
            int green = Integer.parseInt(string.substring(3, 5), 16);
            int blue = Integer.parseInt(string.substring(5, 7), 16);
            return new Color(red, green, blue);
        }
        throw new IllegalArgumentException("No xml color given by '" + string + "'.");
    }

    public static String PointToXml(Point col) {
        if (col == null) {
            return null;
        }
        Vector<String> l = new Vector<String>();
        l.add(Integer.toString(col.x));
        l.add(Integer.toString(col.y));
        return Tools.listToString(l);
    }

    public static Point xmlToPoint(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("java.awt.Point")) {
            string = string.replaceAll("java\\.awt\\.Point\\[x=(-*[0-9]*),y=(-*[0-9]*)\\]", "$1;$2");
        }
        List l = Tools.stringToList(string);
        ListIterator it = l.listIterator(0);
        if (l.size() != 2) {
            throw new IllegalArgumentException("A point must consist of two numbers (and not: '" + string + "').");
        }
        int x = Integer.parseInt((String)it.next());
        int y = Integer.parseInt((String)it.next());
        return new Point(x, y);
    }

    public static String BooleanToXml(boolean col) {
        return col ? "true" : "false";
    }

    public static boolean xmlToBoolean(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("true");
    }

    public static List stringToList(String string) {
        StringTokenizer tok = new StringTokenizer(string, ";");
        LinkedList<String> list = new LinkedList<String>();
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        return list;
    }

    public static String listToString(List list) {
        ListIterator it = list.listIterator(0);
        String str = new String();
        while (it.hasNext()) {
            str = str + it.next().toString() + ";";
        }
        return str;
    }

    public static String expandFileName(String file) {
        if (file.startsWith("~")) {
            file = System.getProperty("user.home") + file.substring(1);
        }
        return file;
    }

    public static Set getAvailableFontFamilyNames() {
        if (availableFontFamilyNames == null) {
            String[] envFonts = Tools.getAvailableFonts();
            availableFontFamilyNames = new HashSet();
            for (int i = 0; i < envFonts.length; ++i) {
                availableFontFamilyNames.add(envFonts[i]);
            }
            availableFontFamilyNames.add("dialog");
        }
        return availableFontFamilyNames;
    }

    private static String[] getAvailableFonts() {
        if (sEnvFonts == null) {
            GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            sEnvFonts = gEnv.getAvailableFontFamilyNames();
        }
        return sEnvFonts;
    }

    public static Vector getAvailableFontFamilyNamesAsVector() {
        String[] envFonts = Tools.getAvailableFonts();
        Vector<String> availableFontFamilyNames = new Vector<String>();
        for (int i = 0; i < envFonts.length; ++i) {
            availableFontFamilyNames.add(envFonts[i]);
        }
        return availableFontFamilyNames;
    }

    public static boolean isAvailableFontFamily(String fontFamilyName) {
        return Tools.getAvailableFontFamilyNames().contains(fontFamilyName);
    }

    public static String getExtension(File f) {
        return Tools.getExtension(f.toString());
    }

    public static String getExtension(String s) {
        int i = s.lastIndexOf(46);
        return i > 0 && i < s.length() - 1 ? s.substring(i + 1).toLowerCase().trim() : "";
    }

    public static String removeExtension(String s) {
        int i = s.lastIndexOf(46);
        return i > 0 && i < s.length() - 1 ? s.substring(0, i) : "";
    }

    public static boolean isAbsolutePath(String path) {
        String osNameStart = System.getProperty("os.name").substring(0, 3);
        String fileSeparator = System.getProperty("file.separator");
        if (osNameStart.equals("Win")) {
            return path.length() > 1 && path.substring(1, 2).equals(":") || path.startsWith(fileSeparator);
        }
        if (osNameStart.equals("Mac")) {
            return path.startsWith(fileSeparator);
        }
        return path.startsWith(fileSeparator);
    }

    public static String urlGetFile(URL url) {
        String osNameStart = System.getProperty("os.name").substring(0, 3);
        if (osNameStart.equals("Win") && url.getProtocol().equals("file")) {
            String fileName = url.toString().replaceFirst("^file:", "").replace('/', '\\');
            return fileName.indexOf(58) >= 0 ? fileName.replaceFirst("^\\\\*", "") : fileName;
        }
        return url.getFile();
    }

    public static String toRelativeURL(URL base, URL target) {
        if (base.getProtocol().equals(target.getProtocol()) && base.getHost().equals(target.getHost())) {
            String baseString = base.getFile();
            String targetString = target.getFile();
            String result = "";
            baseString = baseString.substring(0, baseString.lastIndexOf("/") + 1);
            targetString = targetString.substring(0, targetString.lastIndexOf("/") + 1);
            StringTokenizer baseTokens = new StringTokenizer(baseString, "/");
            StringTokenizer targetTokens = new StringTokenizer(targetString, "/");
            String nextBaseToken = "";
            String nextTargetToken = "";
            while (baseTokens.hasMoreTokens() && targetTokens.hasMoreTokens()) {
                nextBaseToken = baseTokens.nextToken();
                if (nextBaseToken.equals(nextTargetToken = targetTokens.nextToken())) continue;
                while (true) {
                    result = result.concat("../");
                    if (!baseTokens.hasMoreTokens()) break;
                    nextBaseToken = baseTokens.nextToken();
                }
                while (true) {
                    result = result.concat(nextTargetToken + "/");
                    if (!targetTokens.hasMoreTokens()) break;
                    nextTargetToken = targetTokens.nextToken();
                }
                String temp = target.getFile();
                result = result.concat(temp.substring(temp.lastIndexOf("/") + 1, temp.length()));
                return result;
            }
            while (baseTokens.hasMoreTokens()) {
                result = result.concat("../");
                baseTokens.nextToken();
            }
            while (targetTokens.hasMoreTokens()) {
                nextTargetToken = targetTokens.nextToken();
                result = result.concat(nextTargetToken + "/");
            }
            String temp = target.getFile();
            result = result.concat(temp.substring(temp.lastIndexOf("/") + 1, temp.length()));
            return result;
        }
        return target.toString();
    }

    public static boolean isPreferenceTrue(String option) {
        return Tools.safeEquals(option, "true");
    }

    public static boolean safeEquals(String string1, String string2) {
        return string1 != null && string2 != null && string1.equals(string2) || string1 == null && string2 == null;
    }

    public static boolean safeEquals(Object obj1, Object obj2) {
        return obj1 != null && obj2 != null && obj1.equals(obj2) || obj1 == null && obj2 == null;
    }

    public static boolean safeEqualsIgnoreCase(String string1, String string2) {
        return string1 != null && string2 != null && string1.toLowerCase().equals(string2.toLowerCase()) || string1 == null && string2 == null;
    }

    public static boolean safeEquals(Color color1, Color color2) {
        return color1 != null && color2 != null && color1.equals(color2) || color1 == null && color2 == null;
    }

    public static String firstLetterCapitalized(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1, text.length());
    }

    public static void setHidden(File file, boolean hidden, boolean synchronously) {
        String osNameStart = System.getProperty("os.name").substring(0, 3);
        if (osNameStart.equals("Win")) {
            try {
                Runtime.getRuntime().exec("attrib " + (hidden ? "+" : "-") + "H \"" + file.getAbsolutePath() + "\"");
                if (!synchronously) {
                    return;
                }
                for (int timeOut = 10; file.isHidden() != hidden && timeOut > 0; --timeOut) {
                    Thread.sleep(10L);
                }
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
            }
        }
    }

    public static String expandPlaceholders(String message, String s1) {
        String result = message;
        if (s1 != null) {
            s1 = s1.replaceAll("\\\\", "\\\\\\\\");
            result = result.replaceAll("\\$1", s1);
        }
        return result;
    }

    public static String expandPlaceholders(String message, String s1, String s2) {
        String result = message;
        if (s1 != null) {
            result = result.replaceAll("\\$1", s1);
        }
        if (s2 != null) {
            result = result.replaceAll("\\$2", s2);
        }
        return result;
    }

    public static String expandPlaceholders(String message, String s1, String s2, String s3) {
        String result = message;
        if (s1 != null) {
            result = result.replaceAll("\\$1", s1);
        }
        if (s2 != null) {
            result = result.replaceAll("\\$2", s2);
        }
        if (s3 != null) {
            result = result.replaceAll("\\$3", s3);
        }
        return result;
    }

    public static String toBase64(byte[] byteBuffer) {
        return new String(Base64Coding.encode64(byteBuffer));
    }

    public static String toBase64(String text) {
        return Tools.toBase64(text.getBytes());
    }

    public static byte[] fromBase64(String base64String) {
        return Base64Coding.decode64(base64String);
    }

    public static String compress(String message) {
        byte[] input = Tools.uTF8StringToByteArray(message);
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] compressedData = bos.toByteArray();
        return Tools.toBase64(compressedData);
    }

    public static String decompress(String compressedMessage) {
        byte[] compressedData = Tools.fromBase64(compressedMessage);
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressedData.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {}
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] decompressedData = bos.toByteArray();
        return Tools.byteArrayToUTF8String(decompressedData);
    }

    public static String byteArrayToUTF8String(byte[] compressedData) {
        try {
            return new String(compressedData, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 packing not allowed");
        }
    }

    public static byte[] uTF8StringToByteArray(String uncompressedData) {
        try {
            return uncompressedData.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 packing not allowed");
        }
    }

    public static Date xmlToDate(String xmlString) {
        try {
            return new Date(Long.valueOf(xmlString));
        }
        catch (Exception e) {
            return new Date(System.currentTimeMillis());
        }
    }

    public static String dateToString(Date date) {
        return Long.toString(date.getTime());
    }

    public static boolean safeEquals(BooleanHolder holder, BooleanHolder holder2) {
        return holder == null && holder2 == null || holder != null && holder2 != null && holder.getValue() == holder2.getValue();
    }

    public static void setDialogLocationRelativeTo(JDialog dialog, Component c) {
        int bottomSpace;
        int topSpace;
        int rightSpace;
        int leftSpace;
        if (c == null) {
            return;
        }
        if (c instanceof NodeView) {
            NodeView nodeView = (NodeView)c;
            nodeView.getMap().scrollNodeToVisible(nodeView);
            c = nodeView.getMainView();
        }
        Point compLocation = c.getLocationOnScreen();
        int cw = c.getWidth();
        int ch = c.getHeight();
        Container parent = dialog.getParent();
        Point parentLocation = parent.getLocationOnScreen();
        int pw = parent.getWidth();
        int ph = parent.getHeight();
        int dw = dialog.getWidth();
        int dh = dialog.getHeight();
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = defaultToolkit.getScreenSize();
        Insets screenInsets = defaultToolkit.getScreenInsets(dialog.getGraphicsConfiguration());
        int minX = Math.max(parentLocation.x, screenInsets.left);
        int minY = Math.max(parentLocation.y, screenInsets.top);
        int maxX = Math.min(parentLocation.x + pw, screenSize.width - screenInsets.right);
        int maxY = Math.min(parentLocation.y + ph, screenSize.height - screenInsets.bottom);
        int dx = compLocation.x + cw < minX ? minX : (compLocation.x > maxX ? maxX - dw : ((leftSpace = compLocation.x - minX) > (rightSpace = maxX - (compLocation.x + cw)) ? (leftSpace > dw ? compLocation.x - dw : minX) : (rightSpace > dw ? compLocation.x + cw : maxX - dw)));
        int dy = compLocation.y + ch < minY ? minY : (compLocation.y > maxY ? maxY - dh : ((topSpace = compLocation.y - minY) > (bottomSpace = maxY - (compLocation.y + ch)) ? (topSpace > dh ? compLocation.y - dh : minY) : (bottomSpace > dh ? compLocation.y + ch : maxY - dh)));
        dialog.setLocation(dx, dy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reader getUpdateReader(File file, String xsltScript, FreeMindMain frame) throws IOException {
        StringWriter writer = null;
        InputStream inputStream = null;
        Logger logger = frame.getLogger(Tools.class.getName());
        logger.info("Updating the file " + file.getName() + " to the current version.");
        boolean successful = false;
        try {
            URL updaterUrl = null;
            updaterUrl = frame.getResource(xsltScript);
            if (updaterUrl == null) {
                throw new IllegalArgumentException(xsltScript + " not found.");
            }
            inputStream = updaterUrl.openStream();
            final StreamSource xsltSource = new StreamSource(inputStream);
            writer = new StringWriter();
            final StreamResult result = new StreamResult(writer);
            String fileContents = Tools.getFile(file);
            if ((fileContents = Tools.replaceUtf8AndIllegalXmlChars(fileContents)).length() > 10) {
                logger.info("File start: " + fileContents.substring(0, 9));
            }
            final StreamSource sr = new StreamSource(new StringReader(fileContents));
            class TransformerRunnable
            implements Runnable {
                private boolean successful = false;

                TransformerRunnable() {
                }

                @Override
                public void run() {
                    TransformerFactory transFact = TransformerFactory.newInstance();
                    try {
                        Transformer trans = transFact.newTransformer(xsltSource);
                        trans.transform(sr, result);
                        this.successful = true;
                    }
                    catch (Exception ex) {
                        Resources.getInstance().logException(ex);
                    }
                }

                public boolean isSuccessful() {
                    return this.successful;
                }
            }
            TransformerRunnable transformer = new TransformerRunnable();
            Thread transformerThread = new Thread((Runnable)transformer, "XSLT");
            transformerThread.start();
            transformerThread.join();
            logger.info("Updating the file " + file.getName() + " to the current version. Done.");
            successful = transformer.isSuccessful();
        }
        catch (Exception ex) {
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        if (successful) {
            return new StringReader(writer.getBuffer().toString());
        }
        return Tools.getActualReader(file);
    }

    public static String replaceUtf8AndIllegalXmlChars(String fileContents) {
        byte[] bytes = fileContents.getBytes();
        if (bytes.length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            try {
                fileContents = new String(bytes, 3, bytes.length - 3, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Resources.getInstance().logException(e);
            }
        }
        return HtmlTools.replaceIllegalXmlCharacters(fileContents);
    }

    public static Reader getActualReader(File file) throws FileNotFoundException {
        return new BufferedReader(new FileReader(file));
    }

    public static String getFile(File pInputFile) {
        StringBuffer lines = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(pInputFile)));
            String endLine = System.getProperty("line.separator");
            while ((line = bufferedReader.readLine()) != null) {
                lines.append(line).append(endLine);
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception ex) {
                    Resources.getInstance().logException(ex);
                }
            }
            return null;
        }
        return lines.toString();
    }

    public static void logTransferable(Transferable t) {
        System.err.println();
        System.err.println("BEGIN OF Transferable:\t" + t);
        DataFlavor[] dataFlavors = t.getTransferDataFlavors();
        for (int i = 0; i < dataFlavors.length; ++i) {
            System.out.println("  Flavor:\t" + dataFlavors[i]);
            System.out.println("    Supported:\t" + t.isDataFlavorSupported(dataFlavors[i]));
            try {
                System.out.println("    Content:\t" + t.getTransferData(dataFlavors[i]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.err.println("END OF Transferable");
        System.err.println();
    }

    public static void addEscapeActionToDialog(JDialog dialog) {
        class EscapeAction
        extends AbstractAction {
            final /* synthetic */ JDialog val$dialog;

            EscapeAction(JDialog jDialog) {
                this.val$dialog = jDialog;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$dialog.dispose();
            }
        }
        Tools.addEscapeActionToDialog(dialog, new EscapeAction(dialog));
    }

    public static void addEscapeActionToDialog(JDialog dialog, Action action) {
        Tools.addKeyActionToDialog(dialog, action, "ESCAPE", "end_dialog");
    }

    public static void addKeyActionToDialog(JDialog dialog, Action action, String keyStroke, String actionId) {
        action.putValue("Name", actionId);
        dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(keyStroke), action.getValue("Name"));
        dialog.getRootPane().getActionMap().put(action.getValue("Name"), action);
    }

    public static String removeTranslateComment(String inputString) {
        if (inputString != null && inputString.endsWith("[Translate Me]")) {
            inputString = inputString.substring(0, inputString.length() - "[Translate Me]".length());
        }
        return inputString;
    }

    public static URL getURLWithoutReference(URL input) throws MalformedURLException {
        return new URL(input.toString().replaceFirst("#.*", ""));
    }

    public static void copyStream(InputStream in, OutputStream out, boolean pCloseOutput) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        if (pCloseOutput) {
            out.close();
        }
    }

    public static void convertPointToAncestor(Component c, Point p, Component destination) {
        while (c != destination) {
            int x = c.getX();
            int y = c.getY();
            p.x += x;
            p.y += y;
            c = c.getParent();
        }
    }

    public static void convertPointFromAncestor(Component source, Point p, Component c) {
        while (c != source) {
            int x = c.getX();
            int y = c.getY();
            p.x -= x;
            p.y -= y;
            c = c.getParent();
        }
    }

    public static void convertPointToAncestor(Component source, Point point, Class ancestorClass) {
        Container destination = SwingUtilities.getAncestorOfClass(ancestorClass, source);
        Tools.convertPointToAncestor(source, point, destination);
    }

    public static void setLabelAndMnemonic(AbstractButton btn, String inLabel) {
        Tools.setLabelAndMnemonic(new ButtonHolder(btn), inLabel);
    }

    public static void setLabelAndMnemonic(Action action, String inLabel) {
        Tools.setLabelAndMnemonic(new ActionHolder(action), inLabel);
    }

    private static void setLabelAndMnemonic(NameMnemonicHolder item, String inLabel) {
        char charAfterMnemoSign;
        String rawLabel = inLabel;
        if (rawLabel == null) {
            rawLabel = item.getText();
        }
        if (rawLabel == null) {
            return;
        }
        item.setText(Tools.removeMnemonic(rawLabel));
        int mnemoSignIndex = rawLabel.indexOf("&");
        if (mnemoSignIndex >= 0 && mnemoSignIndex + 1 < rawLabel.length() && (charAfterMnemoSign = rawLabel.charAt(mnemoSignIndex + 1)) != ' ' && !Tools.isMacOsX()) {
            item.setMnemonic(charAfterMnemoSign);
            item.setDisplayedMnemonicIndex(mnemoSignIndex);
        }
    }

    public static boolean isMacOsX() {
        boolean underMac = false;
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Mac OS")) {
            underMac = true;
        }
        return underMac;
    }

    public static String removeMnemonic(String rawLabel) {
        return rawLabel.replaceFirst("&([^ ])", "$1");
    }

    public static KeyStroke getKeyStroke(String keyStrokeDescription) {
        if (keyStrokeDescription == null) {
            return null;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyStrokeDescription);
        if (keyStroke != null) {
            return keyStroke;
        }
        return KeyStroke.getKeyStroke("typed " + keyStrokeDescription);
    }

    public static URL fileToUrl(File pFile) throws MalformedURLException {
        if (JAVA_VERSION.compareTo("1.6.0") < 0) {
            return pFile.toURL();
        }
        return pFile.toURI().toURL();
    }

    public static File urlToFile(URL pUrl) throws URISyntaxException {
        if (JAVA_VERSION.compareTo("1.6.0") < 0) {
            return new File(Tools.urlGetFile(pUrl));
        }
        return new File(new URI(pUrl.toString()));
    }

    public static void restoreAntialiasing(Graphics2D g, Object renderingHint) {
        if (RenderingHints.KEY_ANTIALIASING.isCompatibleValue(renderingHint)) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
        }
    }

    public static String getFileNameProposal(MindMapNode node) {
        String rootText = node.getPlainTextContent();
        rootText = rootText.replaceAll("[&:/\\\\\u0000%$#~\\?\\*]+", "");
        return rootText;
    }

    public static void waitForEventQueue() {
        try {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
        }
    }

    public static void printStackTrace() {
        Resources.getInstance().logException(new IllegalArgumentException("HERE"));
    }

    public static Font updateFontSize(Font font, float zoom, int normalFontSize) {
        float newFontSize;
        float oldFontSize;
        if (font != null && (oldFontSize = font.getSize2D()) != (newFontSize = (float)normalFontSize * zoom)) {
            font = font.deriveFont(newFontSize);
        }
        return font;
    }

    public static String compareText(String pText1, String pText2) {
        if (pText1 == null || pText2 == null) {
            return "One of the Strings is null " + pText1 + ", " + pText2;
        }
        StringBuffer b = new StringBuffer();
        if (pText1.length() > pText2.length()) {
            b.append("First string is longer :" + pText1.substring(pText2.length()) + "\n");
        }
        if (pText1.length() < pText2.length()) {
            b.append("Second string is longer :" + pText2.substring(pText1.length()) + "\n");
        }
        for (int i = 0; i < Math.min(pText1.length(), pText2.length()); ++i) {
            if (pText1.charAt(i) == pText2.charAt(i)) continue;
            b.append("Difference at " + i + ": " + pText1.charAt(i) + "!=" + pText2.charAt(i) + "\n");
        }
        return b.toString();
    }

    private static class ActionHolder
    implements NameMnemonicHolder {
        private Action action;

        public ActionHolder(Action action) {
            this.action = action;
        }

        @Override
        public String getText() {
            return this.action.getValue("Name").toString();
        }

        @Override
        public void setDisplayedMnemonicIndex(int mnemoSignIndex) {
        }

        @Override
        public void setMnemonic(char charAfterMnemoSign) {
            int vk = charAfterMnemoSign;
            if (vk >= 97 && vk <= 122) {
                vk -= 32;
            }
            this.action.putValue("MnemonicKey", new Integer(vk));
        }

        @Override
        public void setText(String text) {
            this.action.putValue("Name", text);
        }
    }

    private static class ButtonHolder
    implements NameMnemonicHolder {
        private AbstractButton btn;

        public ButtonHolder(AbstractButton btn) {
            this.btn = btn;
        }

        @Override
        public String getText() {
            return this.btn.getText();
        }

        @Override
        public void setDisplayedMnemonicIndex(int mnemoSignIndex) {
            this.btn.setDisplayedMnemonicIndex(mnemoSignIndex);
        }

        @Override
        public void setMnemonic(char charAfterMnemoSign) {
            this.btn.setMnemonic(charAfterMnemoSign);
        }

        @Override
        public void setText(String text) {
            this.btn.setText(text);
        }
    }

    static interface NameMnemonicHolder {
        public String getText();

        public void setText(String var1);

        public void setMnemonic(char var1);

        public void setDisplayedMnemonicIndex(int var1);
    }

    public static class TripleDesEncrypter
    extends DesEncrypter {
        public TripleDesEncrypter(StringBuffer pPassPhrase) {
            super(pPassPhrase, "PBEWithMD5AndTripleDES");
        }
    }

    public static class SingleDesEncrypter
    extends DesEncrypter {
        public SingleDesEncrypter(StringBuffer pPassPhrase) {
            super(pPassPhrase, "PBEWithMD5AndDES");
        }
    }

    public static class DesEncrypter {
        private static final String SALT_PRESENT_INDICATOR = " ";
        private static final int SALT_LENGTH = 8;
        Cipher ecipher;
        Cipher dcipher;
        byte[] salt = new byte[]{-87, -101, -56, 50, 86, 53, -29, 3};
        int iterationCount = 19;
        private final char[] passPhrase;
        private String mAlgorithm;

        public DesEncrypter(StringBuffer pPassPhrase, String pAlgorithm) {
            this.passPhrase = new char[pPassPhrase.length()];
            pPassPhrase.getChars(0, this.passPhrase.length, this.passPhrase, 0);
            this.mAlgorithm = pAlgorithm;
        }

        private void init(byte[] mSalt) {
            if (mSalt != null) {
                this.salt = mSalt;
            }
            if (this.ecipher == null) {
                try {
                    PBEKeySpec keySpec = new PBEKeySpec(this.passPhrase, this.salt, this.iterationCount);
                    SecretKey key = SecretKeyFactory.getInstance(this.mAlgorithm).generateSecret(keySpec);
                    this.ecipher = Cipher.getInstance(this.mAlgorithm);
                    this.dcipher = Cipher.getInstance(this.mAlgorithm);
                    PBEParameterSpec paramSpec = new PBEParameterSpec(this.salt, this.iterationCount);
                    this.ecipher.init(1, (Key)key, paramSpec);
                    this.dcipher.init(2, (Key)key, paramSpec);
                }
                catch (InvalidAlgorithmParameterException e) {
                }
                catch (InvalidKeySpecException e) {
                }
                catch (NoSuchPaddingException e) {
                }
                catch (NoSuchAlgorithmException e) {
                }
                catch (InvalidKeyException invalidKeyException) {
                    // empty catch block
                }
            }
        }

        public String encrypt(String str) {
            try {
                byte[] utf8 = str.getBytes("UTF8");
                byte[] newSalt = new byte[8];
                for (int i = 0; i < newSalt.length; ++i) {
                    newSalt[i] = (byte)(Math.random() * 256.0 - 128.0);
                }
                this.init(newSalt);
                byte[] enc = this.ecipher.doFinal(utf8);
                return Tools.toBase64(newSalt) + SALT_PRESENT_INDICATOR + Tools.toBase64(enc);
            }
            catch (BadPaddingException e) {
            }
            catch (IllegalBlockSizeException e) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return null;
        }

        public String decrypt(String str) {
            if (str == null) {
                return null;
            }
            try {
                byte[] salt = null;
                int indexOfSaltIndicator = str.indexOf(SALT_PRESENT_INDICATOR);
                if (indexOfSaltIndicator >= 0) {
                    String saltString = str.substring(0, indexOfSaltIndicator);
                    str = str.substring(indexOfSaltIndicator + 1);
                    salt = Tools.fromBase64(saltString);
                }
                byte[] dec = Tools.fromBase64(str);
                this.init(salt);
                byte[] utf8 = this.dcipher.doFinal(dec);
                return new String(utf8, "UTF8");
            }
            catch (BadPaddingException e) {
            }
            catch (IllegalBlockSizeException e) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return null;
        }
    }

    public static class Pair {
        Object first;
        Object second;

        public Pair(Object first, Object second) {
            this.first = first;
            this.second = second;
        }

        public Object getFirst() {
            return this.first;
        }

        public Object getSecond() {
            return this.second;
        }
    }

    public static class ObjectHolder {
        Object object;

        public void setObject(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }

    public static class BooleanHolder {
        private boolean value;

        public BooleanHolder() {
        }

        public BooleanHolder(boolean initialValue) {
            this.value = initialValue;
        }

        public void setValue(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }
    }

    public static class IntHolder {
        private int value;

        public IntHolder() {
        }

        public IntHolder(int value) {
            this.value = value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return new String("IntHolder(") + this.value + ")";
        }
    }
}

