/*
 * Decompiled with CFR 0.152.
 */
package bibtex.expansions;

import bibtex.dom.BibtexAbstractEntry;
import bibtex.dom.BibtexAbstractValue;
import bibtex.dom.BibtexEntry;
import bibtex.dom.BibtexFile;
import bibtex.dom.BibtexString;
import bibtex.expansions.AbstractExpander;
import bibtex.expansions.Expander;
import bibtex.expansions.ExpansionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class CrossReferenceExpander
extends AbstractExpander
implements Expander {
    public CrossReferenceExpander() {
        this(true);
    }

    public CrossReferenceExpander(boolean throwAllExpansionExceptions) {
        super(throwAllExpansionExceptions);
    }

    public void expand(BibtexFile bibtexFile) throws ExpansionException {
        HashMap<String, BibtexAbstractEntry> entryKey2Entry = new HashMap<String, BibtexAbstractEntry>();
        ArrayList<BibtexEntry> entriesWithCrossReference = new ArrayList<BibtexEntry>();
        Iterator entryIt = bibtexFile.getEntries().iterator();
        while (entryIt.hasNext()) {
            BibtexAbstractEntry abstractEntry = (BibtexAbstractEntry)entryIt.next();
            if (!(abstractEntry instanceof BibtexEntry)) continue;
            BibtexEntry entry = (BibtexEntry)abstractEntry;
            entryKey2Entry.put(entry.getEntryKey().toLowerCase(), abstractEntry);
            if (!entry.getFields().containsKey("crossref")) continue;
            entriesWithCrossReference.add(entry);
        }
        entryIt = entriesWithCrossReference.iterator();
        while (entryIt.hasNext()) {
            BibtexEntry entry = (BibtexEntry)entryIt.next();
            String crossrefKey = ((BibtexString)entry.getFields().get("crossref")).getContent().toLowerCase();
            entry.undefineField("crossref");
            BibtexEntry crossrefEntry = (BibtexEntry)entryKey2Entry.get(crossrefKey);
            if (crossrefEntry == null) {
                this.throwExpansionException("Crossref key not found: \"" + crossrefKey + "\"");
            }
            if (crossrefEntry.getFields().containsKey("crossref")) {
                this.throwExpansionException("Nested crossref: \"" + crossrefKey + "\" is crossreferenced but crossreferences itself \"" + ((BibtexString)crossrefEntry.getFields().get("crossref")).getContent() + "\"");
            }
            Map entryFields = entry.getFields();
            Map crossrefFields = crossrefEntry.getFields();
            Iterator fieldIt = crossrefFields.keySet().iterator();
            while (fieldIt.hasNext()) {
                String key = (String)fieldIt.next();
                if (entryFields.containsKey(key)) continue;
                entry.setField(key, (BibtexAbstractValue)crossrefFields.get(key));
            }
        }
        this.finishExpansion();
    }
}

