/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.util.Stack;
import org.jibx.runtime.IXMLWriter;

public abstract class XMLWriterNamespaceBase
implements IXMLWriter {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    protected String[] m_uris;
    protected String[] m_prefixes;
    private int m_nestingDepth;
    private Stack m_namespaceStack;
    private int m_namespaceDepth;
    private String[][] m_extensionUris;
    private String[][] m_extensionPrefixes;

    public XMLWriterNamespaceBase(String[] stringArray) {
        this.m_uris = stringArray;
        this.m_prefixes = new String[stringArray.length];
        this.m_prefixes[0] = "";
        this.m_prefixes[1] = "xml";
        this.m_namespaceStack = new Stack();
        this.m_namespaceDepth = -1;
    }

    protected abstract void defineNamespace(int var1, String var2) throws IOException;

    protected abstract void undefineNamespace(int var1);

    private void setNamespacePrefix(int n, String string) {
        if (n < this.m_prefixes.length) {
            this.m_prefixes[n] = string;
        } else if (this.m_extensionUris != null) {
            n -= this.m_prefixes.length;
            for (int i = 0; i < this.m_extensionUris.length; ++i) {
                int n2 = this.m_extensionUris[i].length;
                if (n < n2) {
                    this.m_extensionPrefixes[i][n] = string;
                    break;
                }
                n -= n2;
            }
        }
    }

    public int[] openNamespaces(int[] nArray, String[] stringArray) throws IOException {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (stringArray[i].equals(this.getNamespacePrefix(nArray[i]))) continue;
            ++n;
        }
        int[] nArray2 = EMPTY_INT_ARRAY;
        if (n > 0) {
            String[] stringArray2 = new String[n];
            if (n == nArray.length) {
                nArray2 = nArray;
                for (int i = 0; i < n; ++i) {
                    int n2 = nArray2[i];
                    stringArray2[i] = this.getNamespacePrefix(n2);
                    this.setNamespacePrefix(n2, stringArray[i]);
                    this.defineNamespace(n2, stringArray[i]);
                }
            } else {
                int n3 = 0;
                nArray2 = new int[n];
                for (int i = 0; i < nArray.length; ++i) {
                    int n4 = nArray[i];
                    String string = this.getNamespacePrefix(n4);
                    if (stringArray[i].equals(string)) continue;
                    nArray2[n3] = n4;
                    stringArray2[n3++] = string;
                    this.setNamespacePrefix(n4, stringArray[i]);
                    this.defineNamespace(n4, stringArray[i]);
                }
            }
            this.m_namespaceStack.push(new DeclarationInfo(this.m_nestingDepth, nArray2, stringArray2));
            this.m_namespaceDepth = this.m_nestingDepth;
        }
        return nArray2;
    }

    private void closeNamespaces() {
        DeclarationInfo declarationInfo = (DeclarationInfo)this.m_namespaceStack.pop();
        int[] nArray = declarationInfo.m_deltas;
        String[] stringArray = declarationInfo.m_priors;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            this.undefineNamespace(n);
            if (n < this.m_prefixes.length) {
                this.m_prefixes[n] = stringArray[i];
                continue;
            }
            if (this.m_extensionUris == null) continue;
            n -= this.m_prefixes.length;
            for (int j = 0; j < this.m_extensionUris.length; ++j) {
                int n2 = this.m_extensionUris[j].length;
                if (n < n2) {
                    this.m_extensionPrefixes[j][n] = stringArray[i];
                    continue;
                }
                n -= n2;
            }
        }
        this.m_namespaceDepth = this.m_namespaceStack.empty() ? -1 : ((DeclarationInfo)this.m_namespaceStack.peek()).m_depth;
    }

    public final int getNestingDepth() {
        return this.m_nestingDepth;
    }

    public final int getNamespaceCount() {
        int n = this.m_uris.length;
        if (this.m_extensionUris != null) {
            for (int i = 0; i < this.m_extensionUris.length; ++i) {
                n += this.m_extensionUris[i].length;
            }
        }
        return n;
    }

    protected void incrementNesting() {
        ++this.m_nestingDepth;
    }

    protected void decrementNesting() {
        --this.m_nestingDepth;
        while (this.m_nestingDepth == this.m_namespaceDepth) {
            this.closeNamespaces();
        }
    }

    public void reset() {
        this.m_nestingDepth = 0;
        this.m_namespaceDepth = -1;
        this.m_namespaceStack.clear();
        this.m_extensionUris = null;
        this.m_extensionPrefixes = null;
    }

    public final String[] getNamespaces() {
        return this.m_uris;
    }

    public final String getNamespaceUri(int n) {
        if (n < this.m_uris.length) {
            return this.m_uris[n];
        }
        if (this.m_extensionUris != null) {
            n -= this.m_uris.length;
            for (int i = 0; i < this.m_extensionUris.length; ++i) {
                int n2 = this.m_extensionUris[i].length;
                if (n < n2) {
                    return this.m_extensionUris[i][n];
                }
                n -= n2;
            }
        }
        return null;
    }

    public final String getNamespacePrefix(int n) {
        if (n < this.m_prefixes.length) {
            return this.m_prefixes[n];
        }
        if (this.m_extensionUris != null) {
            n -= this.m_prefixes.length;
            for (int i = 0; i < this.m_extensionUris.length; ++i) {
                int n2 = this.m_extensionUris[i].length;
                if (n < n2) {
                    return this.m_extensionPrefixes[i][n];
                }
                n -= n2;
            }
        }
        return null;
    }

    public final int getPrefixIndex(String string) {
        int n;
        if (this.m_extensionPrefixes != null) {
            for (n = this.m_extensionPrefixes.length - 1; n >= 0; --n) {
                String[] stringArray = this.m_extensionPrefixes[n];
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    if (!string.equals(stringArray[i])) continue;
                    int n2 = i + this.m_prefixes.length;
                    for (int j = n - 1; j >= 0; --j) {
                        n2 += this.m_extensionPrefixes[j].length;
                    }
                    return n2;
                }
            }
        }
        for (n = this.m_prefixes.length - 1; n >= 0; --n) {
            if (!string.equals(this.m_prefixes[n])) continue;
            return n;
        }
        return -1;
    }

    protected static String[][] growArray(String[][] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return new String[][]{stringArray2};
        }
        int n = stringArray.length;
        String[][] stringArray3 = new String[n + 1][];
        System.arraycopy(stringArray, 0, stringArray3, 0, n);
        stringArray3[n] = stringArray2;
        return stringArray3;
    }

    protected static String[][] shrinkArray(String[][] stringArray) {
        int n = stringArray.length;
        if (n == 1) {
            return null;
        }
        String[][] stringArray2 = new String[n - 1][];
        System.arraycopy(stringArray, 0, stringArray2, 0, n - 1);
        return stringArray2;
    }

    public void pushExtensionNamespaces(String[] stringArray) {
        this.m_extensionUris = XMLWriterNamespaceBase.growArray(this.m_extensionUris, stringArray);
        this.m_extensionPrefixes = XMLWriterNamespaceBase.growArray(this.m_extensionPrefixes, new String[stringArray.length]);
    }

    public void popExtensionNamespaces() {
        this.m_extensionUris = XMLWriterNamespaceBase.shrinkArray(this.m_extensionUris);
        this.m_extensionPrefixes = XMLWriterNamespaceBase.shrinkArray(this.m_extensionPrefixes);
    }

    public final String[][] getExtensionNamespaces() {
        return this.m_extensionUris;
    }

    private static class DeclarationInfo {
        public final int m_depth;
        public final int[] m_deltas;
        public final String[] m_priors;

        public DeclarationInfo(int n, int[] nArray, String[] stringArray) {
            this.m_depth = n;
            this.m_deltas = nArray;
            this.m_priors = stringArray;
        }
    }
}

