/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.controller.Controller;
import freemind.controller.MapModuleManager;
import freemind.controller.MenuBar;
import freemind.main.FeedBack;
import freemind.main.FreeMindCommon;
import freemind.main.FreeMindMain;
import freemind.main.FreeMindSecurityManager;
import freemind.main.FreeMindSplashModern;
import freemind.main.LoggingOutputStream;
import freemind.main.Resources;
import freemind.main.StdFormatter;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.preferences.FreemindPropertyListener;
import freemind.view.MapModule;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import splmm.SciPloreUpdateCheck;
import splmm.SciPloreUtils;
import splmm.Thread.EventSenderThread;

public class FreeMind
extends JFrame
implements FreeMindMain {
    private static final String SPLIT_PANE_POSITION = "split_pane_position";
    private static final String SPLIT_PANE_LAST_POSITION = "split_pane_last_position";
    public static final String RESOURCE_LOOKANDFEEL = "lookandfeel";
    public static final String RESOURCES_SELECTION_METHOD = "selection_method";
    public static final String RESOURCES_NODE_STYLE = "standardnodestyle";
    public static final String RESOURCES_ROOT_NODE_STYLE = "standardrootnodestyle";
    public static final String RESOURCES_NODE_TEXT_COLOR = "standardnodetextcolor";
    public static final String RESOURCES_SELECTED_NODE_COLOR = "standardselectednodecolor";
    public static final String RESOURCES_SELECTED_NODE_RECTANGLE_COLOR = "standardselectednoderectanglecolor";
    public static final String RESOURCE_DRAW_RECTANGLE_FOR_SELECTION = "standarddrawrectangleforselection";
    public static final String RESOURCES_EDGE_COLOR = "standardedgecolor";
    public static final String RESOURCES_EDGE_STYLE = "standardedgestyle";
    public static final String RESOURCES_CLOUD_COLOR = "standardcloudcolor";
    public static final String RESOURCES_LINK_COLOR = "standardlinkcolor";
    public static final String RESOURCES_BACKGROUND_COLOR = "standardbackgroundcolor";
    public static final String RESOURCE_PRINT_ON_WHITE_BACKGROUND = "printonwhitebackground";
    public static final String RESOURCES_WHEEL_VELOCITY = "wheel_velocity";
    public static final String RESOURCES_USE_TABBED_PANE = "use_tabbed_pane";
    public static final String RESOURCES_USE_SPLIT_PANE = "use_split_pane";
    public static final String RESOURCES_DELETE_NODES_WITHOUT_QUESTION = "delete_nodes_without_question";
    private Logger logger = null;
    protected static final FreeMindMain.VersionInformation VERSION = new FreeMindMain.VersionInformation("0.9.0 RC 7");
    public static final String XML_VERSION = "0.9.0";
    public static final String RESOURCES_REMIND_USE_RICH_TEXT_IN_NEW_LONG_NODES = "remind_use_rich_text_in_new_long_nodes";
    public static final String RESOURCES_EXECUTE_SCRIPTS_WITHOUT_ASKING = "resources_execute_scripts_without_asking";
    public static final String RESOURCES_EXECUTE_SCRIPTS_WITHOUT_FILE_RESTRICTION = "resources_execute_scripts_without_file_restriction";
    public static final String RESOURCES_EXECUTE_SCRIPTS_WITHOUT_NETWORK_RESTRICTION = "resources_execute_scripts_without_network_restriction";
    public static final String RESOURCES_EXECUTE_SCRIPTS_WITHOUT_EXEC_RESTRICTION = "resources_execute_scripts_without_exec_restriction";
    public static final String RESOURCES_SCRIPT_USER_KEY_NAME_FOR_SIGNING = "resources_script_user_key_name_for_signing";
    public static final String RESOURCES_CONVERT_TO_CURRENT_VERSION = "resources_convert_to_current_version";
    public static final String RESOURCES_CUT_NODES_WITHOUT_QUESTION = "resources_cut_nodes_without_question";
    public static final String RESOURCES_DON_T_SHOW_NOTE_ICONS = "resources_don_t_show_note_icons";
    public static final String RESOURCES_REMOVE_NOTES_WITHOUT_QUESTION = "resources_remove_notes_without_question";
    public static final String RESOURCES_SAVE_FOLDING_STATE = "resources_save_folding_state";
    public static final String RESOURCES_SIGNED_SCRIPT_ARE_TRUSTED = "resources_signed_script_are_trusted";
    public static final String RESOURCES_USE_DEFAULT_FONT_FOR_NOTES_TOO = "resources_use_default_font_for_notes_too";
    public static final String RESOURCES_USE_MARGIN_TOP_ZERO_FOR_NOTES = "resources_use_margin_top_zero_for_notes";
    public static Properties props;
    private static Properties defProps;
    private MenuBar menuBar;
    private JLabel status;
    private Map filetypes;
    private File autoPropertiesFile;
    private File patternsFile;
    Controller controller;
    private FreeMindCommon mFreeMindCommon;
    private static FileHandler mFileHandler;
    private JScrollPane mScrollPane = null;
    private JSplitPane mSplitPane;
    private JComponent mContentComponent = null;
    private JTabbedPane mTabbedPane = null;
    private boolean mTabbedPaneSelectionUpdate = true;
    private ImageIcon mWindowIcon;
    private Vector mTabbedPaneMapModules;

    public FreeMind(Properties pDefaultPreferences, Properties pUserPreferences, File pAutoPropertiesFile) {
        super("SciPlore MindMapping");
        System.setSecurityManager(new FreeMindSecurityManager());
        defProps = pDefaultPreferences;
        props = pUserPreferences;
        this.autoPropertiesFile = pAutoPropertiesFile;
        if (this.logger == null) {
            this.logger = this.getLogger(FreeMind.class.getName());
            StringBuffer info = new StringBuffer();
            info.append("freemind_version = ");
            info.append(VERSION);
            info.append("; freemind_xml_version = ");
            info.append(XML_VERSION);
            try {
                String propsLoc = "version.properties";
                URL versionUrl = this.getClass().getClassLoader().getResource(propsLoc);
                Properties buildNumberPros = new Properties();
                InputStream stream = versionUrl.openStream();
                buildNumberPros.load(stream);
                info.append("\nBuild: " + buildNumberPros.getProperty("build.number") + "\n");
                stream.close();
            }
            catch (Exception e) {
                info.append("Problems reading build number file: " + e);
            }
            info.append("\njava_version = ");
            info.append(System.getProperty("java.version"));
            info.append("; os_name = ");
            info.append(System.getProperty("os.name"));
            info.append("; os_version = ");
            info.append(System.getProperty("os.version"));
            this.logger.info(info.toString());
        }
        this.mFreeMindCommon = new FreeMindCommon(this);
        Resources.createInstance(this);
    }

    void init(FeedBack feedback) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        this.patternsFile = new File(this.getFreemindDirectory(), this.getDefaultProperty("patternsfile"));
        feedback.increase("FreeMind.progress.updateLookAndFeel");
        this.updateLookAndFeel();
        feedback.increase("FreeMind.progress.createController");
        this.setIconImage(this.mWindowIcon.getImage());
        this.getContentPane().setLayout(new BorderLayout());
        this.controller = new Controller(this);
        feedback.increase("FreeMind.progress.settingPreferences");
        Controller.addPropertyChangeListener(new FreemindPropertyListener(){

            @Override
            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.equals("language")) {
                    FreeMind.this.mFreeMindCommon.clearLanguageResources();
                    FreeMind.this.getResources();
                }
            }
        });
        this.controller.optionAntialiasAction.changeAntialias(this.getProperty("antialias"));
        feedback.increase("FreeMind.progress.propageteLookAndFeel");
        SwingUtilities.updateComponentTreeUI(this);
        feedback.increase("FreeMind.progress.buildScreen");
        this.setScreenBounds();
        feedback.increase("FreeMind.progress.createInitialMode");
        this.controller.createNewMode(this.getProperty("initial_mode"));
    }

    private void updateLookAndFeel() {
        try {
            String lookAndFeel = props.getProperty(RESOURCE_LOOKANDFEEL);
            boolean nimbus = false;
            if (!nimbus && lookAndFeel.equals("windows")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            } else if (!nimbus && lookAndFeel.equals("motif")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            } else if (!nimbus && lookAndFeel.equals("mac")) {
                UIManager.setLookAndFeel("javax.swing.plaf.mac.MacLookAndFeel");
            } else if (!nimbus && lookAndFeel.equals("metal")) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            } else if (!nimbus && lookAndFeel.equals("gtk")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            } else if (nimbus || !lookAndFeel.equals("nothing")) {
                if (!nimbus && lookAndFeel.indexOf(46) != -1) {
                    UIManager.setLookAndFeel(lookAndFeel);
                } else {
                    this.logger.info("Default (System) Look & Feel: " + UIManager.getSystemLookAndFeelClassName());
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Unable to set Look & Feel.");
        }
        this.mFreeMindCommon.loadUIProperties(defProps);
    }

    @Override
    public boolean isApplet() {
        return false;
    }

    @Override
    public File getPatternsFile() {
        return this.patternsFile;
    }

    @Override
    public Container getViewport() {
        return this.mScrollPane.getViewport();
    }

    @Override
    public FreeMindMain.VersionInformation getFreemindVersion() {
        return VERSION;
    }

    @Override
    public int getWinHeight() {
        return this.getHeight();
    }

    @Override
    public int getWinWidth() {
        return this.getWidth();
    }

    @Override
    public int getWinX() {
        return this.getX();
    }

    @Override
    public int getWinY() {
        return this.getY();
    }

    @Override
    public int getWinState() {
        return this.getExtendedState();
    }

    @Override
    public URL getResource(String name) {
        return this.getClass().getClassLoader().getResource(name);
    }

    @Override
    public String getProperty(String key) {
        return props.getProperty(key);
    }

    @Override
    public int getIntProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    @Override
    public Properties getProperties() {
        return props;
    }

    @Override
    public void setProperty(String key, String value) {
        props.setProperty(key, value);
    }

    public String getDefaultProperty(String key) {
        return defProps.getProperty(key);
    }

    @Override
    public void setDefaultProperty(String key, String value) {
        defProps.setProperty(key, value);
    }

    @Override
    public String getFreemindDirectory() {
        return System.getProperty("user.home") + File.separator + this.getProperty("properties_folder");
    }

    @Override
    public void saveProperties() {
        try {
            FileOutputStream out = new FileOutputStream(this.autoPropertiesFile);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)out, "8859_1");
            outputStreamWriter.write("#FreeMind ");
            outputStreamWriter.write(VERSION.toString());
            outputStreamWriter.write(10);
            outputStreamWriter.flush();
            props.store(out, null);
            ((OutputStream)out).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getController().getFilterController().saveConditions();
    }

    @Override
    public MapView getView() {
        return this.controller.getView();
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    @Override
    public void setView(MapView view) {
        this.mScrollPane.setViewportView(view);
    }

    @Override
    public MenuBar getFreeMindMenuBar() {
        return this.menuBar;
    }

    @Override
    public void out(String msg) {
        if (this.status != null) {
            this.status.setText(msg);
        }
    }

    @Override
    public void err(String msg) {
        if (this.status != null) {
            this.status.setText(msg);
        }
    }

    @Override
    public void openDocument(URL url) throws Exception {
        String osName;
        String correctedUrl = new String(url.toExternalForm());
        if (url.getProtocol().equals("file")) {
            correctedUrl = correctedUrl.replace('\\', '/').replaceAll(" ", "%20");
        }
        if ((osName = System.getProperty("os.name")).substring(0, 3).equals("Win")) {
            String propertyString = new String("default_browser_command_windows");
            propertyString = osName.indexOf("9") != -1 || osName.indexOf("Me") != -1 ? propertyString + "_9x" : propertyString + "_nt";
            String browser_command = new String();
            String command = new String();
            try {
                Object[] messageArguments = new Object[]{url.toString()};
                MessageFormat formatter = new MessageFormat(this.getProperty(propertyString));
                browser_command = formatter.format(messageArguments);
                if (url.getProtocol().equals("file")) {
                    command = "rundll32 url.dll,FileProtocolHandler " + url.toString();
                    if (System.getProperty("os.name").startsWith("Windows 2000")) {
                        command = "rundll32 shell32.dll,ShellExec_RunDLL " + url.toString();
                    }
                } else {
                    command = url.toString().startsWith("mailto:") ? "rundll32 url.dll,FileProtocolHandler " + url.toString() : browser_command;
                }
                Runtime.getRuntime().exec(command);
            }
            catch (IOException x) {
                this.controller.errorMessage("Could not invoke browser.\n\nFreemind excecuted the following statement on a command line:\n\"" + command + "\".\n\nYou may look at the user or default property called '" + propertyString + "'.");
                System.err.println("Caught: " + x);
            }
        } else if (osName.startsWith("Mac OS")) {
            String browser_command = new String();
            try {
                Object[] messageArguments = new Object[]{correctedUrl, url.toString()};
                MessageFormat formatter = new MessageFormat(this.getProperty("default_browser_command_mac"));
                browser_command = formatter.format(messageArguments);
                Runtime.getRuntime().exec(browser_command);
            }
            catch (IOException ex2) {
                this.controller.errorMessage("Could not invoke browser.\n\nFreemind excecuted the following statement on a command line:\n\"" + browser_command + "\".\n\nYou may look at the user or default property called 'default_browser_command_mac'.");
                System.err.println("Caught: " + ex2);
            }
        } else {
            String browser_command = new String();
            try {
                Object[] messageArguments = new Object[]{correctedUrl, url.toString()};
                MessageFormat formatter = new MessageFormat(this.getProperty("default_browser_command_other_os"));
                browser_command = formatter.format(messageArguments);
                Runtime.getRuntime().exec(browser_command);
            }
            catch (IOException ex2) {
                this.controller.errorMessage("Could not invoke browser.\n\nFreemind excecuted the following statement on a command line:\n\"" + browser_command + "\".\n\nYou may look at the user or default property called 'default_browser_command_other_os'.");
                System.err.println("Caught: " + ex2);
            }
        }
    }

    private String transpose(String input, char findChar, String replaceString) {
        String res = new String();
        for (int i = 0; i < input.length(); ++i) {
            char d = input.charAt(i);
            res = d == findChar ? res + replaceString : res + d;
        }
        return res;
    }

    @Override
    public void setWaitingCursor(boolean waiting) {
        if (waiting) {
            this.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            this.getRootPane().getGlassPane().setVisible(true);
        } else {
            this.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            this.getRootPane().getGlassPane().setVisible(false);
        }
    }

    private String getProgramForFile(String type) {
        if (this.filetypes == null) {
            this.filetypes = new HashMap();
            String raw = this.getProperty("filetypes");
            if (raw == null || raw.equals("")) {
                return "";
            }
            StringTokenizer tokens = new StringTokenizer(raw, ",");
            while (tokens.hasMoreTokens()) {
                StringTokenizer pair = new StringTokenizer(tokens.nextToken(), ":");
                String key = pair.nextToken().trim().toLowerCase();
                String value = pair.nextToken().trim();
                this.filetypes.put(key, value);
            }
        }
        return (String)this.filetypes.get(type.trim().toLowerCase());
    }

    @Override
    public ResourceBundle getResources() {
        return this.mFreeMindCommon.getResources();
    }

    @Override
    public String getResourceString(String resource) {
        return this.mFreeMindCommon.getResourceString(resource);
    }

    @Override
    public String getResourceString(String key, String resource) {
        return this.mFreeMindCommon.getResourceString(key, resource);
    }

    @Override
    public Logger getLogger(String forClass) {
        Logger loggerForClass = Logger.getLogger(forClass);
        if (mFileHandler == null) {
            Logger parentLogger = loggerForClass.getParent();
            Handler[] handlers = parentLogger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                Handler handler = handlers[i];
                if (!(handler instanceof ConsoleHandler)) continue;
                parentLogger.removeHandler(handler);
            }
            try {
                mFileHandler = new FileHandler(this.getFreemindDirectory() + File.separator + "log", 1400000, 5, false);
                mFileHandler.setFormatter(new StdFormatter());
                mFileHandler.setLevel(Level.FINEST);
                parentLogger.addHandler(mFileHandler);
                ConsoleHandler stdConsoleHandler = new ConsoleHandler();
                stdConsoleHandler.setFormatter(new StdFormatter());
                stdConsoleHandler.setLevel(Level.WARNING);
                parentLogger.addHandler(stdConsoleHandler);
                Logger logger = Logger.getLogger(StdFormatter.STDOUT.getName());
                LoggingOutputStream los = new LoggingOutputStream(logger, StdFormatter.STDOUT);
                System.setOut(new PrintStream(los, true));
                logger = Logger.getLogger(StdFormatter.STDERR.getName());
                los = new LoggingOutputStream(logger, StdFormatter.STDERR);
                System.setErr(new PrintStream(los, true));
            }
            catch (Exception e) {
                System.err.println("Error creating logging File Handler");
                e.printStackTrace();
            }
        }
        return loggerForClass;
    }

    public static void main(String[] args, Properties pDefaultPreferences, Properties pUserPreferences, File pAutoPropertiesFile) {
        final FreeMind frame = new FreeMind(pDefaultPreferences, pUserPreferences, pAutoPropertiesFile);
        FreeMindSplashModern splash = null;
        splash = new FreeMindSplashModern(frame);
        splash.setVisible(true);
        FeedBack feedBack = splash.getFeedBack();
        frame.mWindowIcon = splash.getWindowIcon();
        feedBack.setMaximumValue(9);
        frame.init(feedBack);
        feedBack.increase("FreeMind.progress.startCreateController");
        final ModeController ctrl = frame.createModeController(args);
        feedBack.increase("FreeMind.progress.loadMaps");
        frame.loadMaps(args, ctrl);
        Tools.waitForEventQueue();
        feedBack.increase("FreeMind.progress.endStartup");
        frame.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                NodeView selectedView = ctrl.getSelectedView();
                if (selectedView != null) {
                    selectedView.requestFocus();
                    MindMapNode selected = ctrl.getSelected();
                    if (selected != null) {
                        ctrl.centerNode(selected);
                    }
                }
                frame.removeWindowFocusListener(this);
            }
        });
        frame.setVisible(true);
        if (splash != null) {
            splash.setVisible(false);
        }
        SciPloreUpdateCheck.checkForUpdate(frame);
    }

    private void setScreenBounds() {
        this.menuBar = new MenuBar(this.controller);
        this.setJMenuBar(this.menuBar);
        this.mScrollPane = new MapView.ScrollPane();
        if (Resources.getInstance().getBoolProperty("no_scrollbar")) {
            this.mScrollPane.setVerticalScrollBarPolicy(21);
            this.mScrollPane.setHorizontalScrollBarPolicy(31);
        } else {
            this.mScrollPane.setVerticalScrollBarPolicy(22);
            this.mScrollPane.setHorizontalScrollBarPolicy(32);
        }
        this.status = new JLabel("!");
        this.status.setPreferredSize(this.status.getPreferredSize());
        this.status.setText("");
        this.mContentComponent = this.mScrollPane;
        boolean shouldUseTabbedPane = Resources.getInstance().getBoolProperty(RESOURCES_USE_TABBED_PANE);
        if (shouldUseTabbedPane) {
            InputMap map = (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
            KeyStroke keyStrokeCtrlUp = KeyStroke.getKeyStroke(38, 128);
            map.remove(keyStrokeCtrlUp);
            this.mTabbedPane = new JTabbedPane();
            this.mTabbedPane.setFocusable(false);
            this.mTabbedPaneMapModules = new Vector();
            this.mTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public synchronized void stateChanged(ChangeEvent pE) {
                    FreeMind.this.tabSelectionChanged();
                }
            });
            this.controller.getMapModuleManager().addListener(new MapModuleManager.MapModuleChangeObserver(){

                @Override
                public void afterMapModuleChange(MapModule pOldMapModule, Mode pOldMode, MapModule pNewMapModule, Mode pNewMode) {
                    int selectedIndex = FreeMind.this.mTabbedPane.getSelectedIndex();
                    if (pNewMapModule == null) {
                        return;
                    }
                    for (int i = 0; i < FreeMind.this.mTabbedPaneMapModules.size(); ++i) {
                        if (FreeMind.this.mTabbedPaneMapModules.get(i) != pNewMapModule) continue;
                        if (selectedIndex != i) {
                            FreeMind.this.mTabbedPane.setSelectedIndex(i);
                        }
                        return;
                    }
                    FreeMind.this.mTabbedPaneMapModules.add(pNewMapModule);
                    FreeMind.this.mTabbedPane.addTab(pNewMapModule.toString(), new JPanel());
                    FreeMind.this.mTabbedPane.setSelectedIndex(FreeMind.this.mTabbedPane.getTabCount() - 1);
                }

                @Override
                public void beforeMapModuleChange(MapModule pOldMapModule, Mode pOldMode, MapModule pNewMapModule, Mode pNewMode) {
                }

                @Override
                public boolean isMapModuleChangeAllowed(MapModule pOldMapModule, Mode pOldMode, MapModule pNewMapModule, Mode pNewMode) {
                    return true;
                }

                @Override
                public void numberOfOpenMapInformation(int pNumber) {
                }

                @Override
                public void afterMapClose(MapModule pOldMapModule, Mode pOldMode) {
                    for (int i = 0; i < FreeMind.this.mTabbedPaneMapModules.size(); ++i) {
                        if (FreeMind.this.mTabbedPaneMapModules.get(i) != pOldMapModule) continue;
                        FreeMind.this.logger.fine("Remove tab:" + i + " with title:" + FreeMind.this.mTabbedPane.getTitleAt(i));
                        FreeMind.this.mTabbedPaneSelectionUpdate = false;
                        FreeMind.this.mTabbedPane.removeTabAt(i);
                        FreeMind.this.mTabbedPaneMapModules.remove(i);
                        FreeMind.this.mTabbedPaneSelectionUpdate = true;
                        FreeMind.this.tabSelectionChanged();
                        return;
                    }
                }
            });
            this.controller.registerMapTitleChangeListener(new MapModuleManager.MapTitleChangeListener(){

                @Override
                public void setMapTitle(String pNewMapTitle, MapModule pMapModule, MindMap pModel) {
                    for (int i = 0; i < FreeMind.this.mTabbedPaneMapModules.size(); ++i) {
                        if (FreeMind.this.mTabbedPaneMapModules.get(i) != pMapModule) continue;
                        FreeMind.this.mTabbedPane.setTitleAt(i, pNewMapTitle + (pModel.isSaved() ? "" : "*"));
                    }
                }
            });
            this.getContentPane().add((Component)this.mTabbedPane, "Center");
        } else {
            this.getContentPane().add((Component)this.mContentComponent, "Center");
        }
        this.getContentPane().add((Component)this.status, "South");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FreeMind.this.controller.quit.actionPerformed(new ActionEvent(this, 0, "quit"));
            }
        });
        if (Tools.safeEquals(this.getProperty("toolbarVisible"), "false")) {
            this.controller.setToolbarVisible(false);
        }
        if (Tools.safeEquals(this.getProperty("leftToolbarVisible"), "false")) {
            this.controller.setLeftToolbarVisible(false);
        }
        this.setFocusTraversalKeysEnabled(false);
        this.pack();
        int win_width = this.getIntProperty("appwindow_width", 0);
        int win_height = this.getIntProperty("appwindow_height", 0);
        int win_x = this.getIntProperty("appwindow_x", 0);
        int win_y = this.getIntProperty("appwindow_y", 0);
        win_width = win_width > 0 ? win_width : 640;
        win_height = win_height > 0 ? win_height : 440;
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        Insets screenInsets = defaultToolkit.getScreenInsets(this.getGraphicsConfiguration());
        Dimension screenSize = defaultToolkit.getScreenSize();
        int screenWidth = screenSize.width - screenInsets.left - screenInsets.right;
        win_width = Math.min(win_width, screenWidth);
        int screenHeight = screenSize.height - screenInsets.top - screenInsets.bottom;
        win_height = Math.min(win_height, screenHeight);
        win_x = Math.max(screenInsets.left, win_x);
        win_x = Math.min(screenWidth + screenInsets.left - win_width, win_x);
        win_y = Math.max(screenInsets.top, win_y);
        win_y = Math.min(screenWidth + screenInsets.top - win_height, win_y);
        this.setBounds(win_x, win_y, win_width, win_height);
        int win_state = Integer.parseInt(props.getProperty("appwindow_state", "0"));
        win_state = (win_state & 1) != 0 ? 0 : win_state;
        this.setExtendedState(win_state);
    }

    private ModeController createModeController(String[] args) {
        ModeController ctrl = this.controller.getModeController();
        try {
            Class<?> macClass = Class.forName("accessories.plugins.MacChanges");
            macClass.getConstructors()[0].newInstance(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ctrl;
    }

    private void loadMaps(String[] args, ModeController pModeController) {
        boolean fileLoaded = false;
        for (int i = 0; i < args.length; ++i) {
            String fileArgument = args[i];
            if (!fileArgument.toLowerCase().endsWith(".mm")) continue;
            if (!Tools.isAbsolutePath(fileArgument)) {
                fileArgument = System.getProperty("user.dir") + System.getProperty("file.separator") + fileArgument;
            }
            try {
                pModeController.load(new File(fileArgument));
                fileLoaded = true;
                continue;
            }
            catch (Exception ex) {
                System.err.println("File " + fileArgument + " not found error");
            }
        }
        if (!fileLoaded) {
            String restoreable = this.getProperty("onStartIfNotSpecified");
            if (Tools.isPreferenceTrue(this.getProperty("loadLastMap")) && restoreable != null && restoreable.length() > 0) {
                try {
                    this.controller.getLastOpenedList().open(restoreable);
                    fileLoaded = true;
                }
                catch (Exception e) {
                    Resources.getInstance().logException(e);
                    this.out("An error occured on opening the file: " + restoreable + ".");
                }
            }
        }
        if (!fileLoaded && Tools.isPreferenceTrue(this.getProperty("load_new_map_when_no_other_is_specified"))) {
            pModeController.newMap();
        }
    }

    @Override
    public JFrame getJFrame() {
        return this;
    }

    @Override
    public ClassLoader getFreeMindClassLoader() {
        return this.mFreeMindCommon.getFreeMindClassLoader();
    }

    @Override
    public String getFreemindBaseDir() {
        return this.mFreeMindCommon.getFreemindBaseDir();
    }

    @Override
    public String getAdjustableProperty(String label) {
        return this.mFreeMindCommon.getAdjustableProperty(label);
    }

    private void tabSelectionChanged() {
        if (!this.mTabbedPaneSelectionUpdate) {
            return;
        }
        int selectedIndex = this.mTabbedPane.getSelectedIndex();
        for (int j = 0; j < this.mTabbedPane.getTabCount(); ++j) {
            if (j == selectedIndex) continue;
            this.mTabbedPane.setComponentAt(j, new JPanel());
        }
        if (selectedIndex < 0) {
            return;
        }
        MapModule module = (MapModule)this.mTabbedPaneMapModules.get(selectedIndex);
        this.logger.fine("Selected index of tab is now: " + selectedIndex + " with title:" + module.toString());
        if (module != this.controller.getMapModule()) {
            this.controller.getMapModuleManager().changeToMapModule(module.toString());
            try {
                String fileName = this.controller.getMapModule().getModel().getFile().getName();
                new EventSenderThread(SciPloreUtils.EVENT_CHANGE_ACTIVE_MINDMAP, fileName);
            }
            catch (NullPointerException e) {
                new EventSenderThread(SciPloreUtils.EVENT_CHANGE_ACTIVE_MINDMAP, "");
            }
        }
        this.mScrollPane.setVisible(true);
        this.mTabbedPane.setComponentAt(selectedIndex, this.mContentComponent);
    }

    @Override
    public JSplitPane insertComponentIntoSplitPane(JComponent pMindMapComponent) {
        if (this.mSplitPane != null) {
            return this.mSplitPane;
        }
        this.removeContentComponent();
        this.mSplitPane = new JSplitPane(0, this.mScrollPane, pMindMapComponent);
        this.mSplitPane.setContinuousLayout(true);
        this.mSplitPane.setOneTouchExpandable(false);
        this.mSplitPane.setResizeWeight(1.0);
        InputMap map = (InputMap)UIManager.get("SplitPane.ancestorInputMap");
        KeyStroke keyStrokeF6 = KeyStroke.getKeyStroke(117, 0);
        KeyStroke keyStrokeF8 = KeyStroke.getKeyStroke(119, 0);
        map.remove(keyStrokeF6);
        map.remove(keyStrokeF8);
        this.mContentComponent = this.mSplitPane;
        this.setContentComponent();
        int splitPanePosition = this.getIntProperty(SPLIT_PANE_POSITION, -1);
        int lastSplitPanePosition = this.getIntProperty(SPLIT_PANE_LAST_POSITION, -1);
        if (splitPanePosition != -1 && lastSplitPanePosition != -1) {
            this.mSplitPane.setDividerLocation(splitPanePosition);
            this.mSplitPane.setLastDividerLocation(lastSplitPanePosition);
        }
        return this.mSplitPane;
    }

    @Override
    public void removeSplitPane() {
        if (this.mSplitPane != null) {
            this.setProperty(SPLIT_PANE_POSITION, "" + this.mSplitPane.getDividerLocation());
            this.setProperty(SPLIT_PANE_LAST_POSITION, "" + this.mSplitPane.getLastDividerLocation());
            this.removeContentComponent();
            this.mContentComponent = this.mScrollPane;
            this.setContentComponent();
            this.mSplitPane = null;
        }
    }

    private void removeContentComponent() {
        if (this.mTabbedPane != null) {
            if (this.mTabbedPane.getSelectedIndex() >= 0) {
                this.mTabbedPane.setComponentAt(this.mTabbedPane.getSelectedIndex(), new JPanel());
            }
        } else {
            this.getContentPane().remove(this.mContentComponent);
            this.getRootPane().revalidate();
        }
    }

    private void setContentComponent() {
        if (this.mTabbedPane != null) {
            if (this.mTabbedPane.getSelectedIndex() >= 0) {
                this.mTabbedPane.setComponentAt(this.mTabbedPane.getSelectedIndex(), this.mContentComponent);
            }
        } else {
            this.getContentPane().add((Component)this.mContentComponent, "Center");
            this.getRootPane().revalidate();
        }
    }

    class FocusSearch
    extends Thread {
        Component lastFocussedC = null;
        FocusListener listener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent pE) {
                Tools.printStackTrace();
            }

            @Override
            public void focusLost(FocusEvent pE) {
            }
        };

        FocusSearch() {
        }

        @Override
        public void run() {
            super.run();
            while (true) {
                this.searchFocus(FreeMind.this);
                try {
                    FocusSearch.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    Resources.getInstance().logException(e);
                    continue;
                }
                break;
            }
        }

        private void searchFocus(Component pComponent) {
            if (pComponent.hasFocus() && pComponent != this.lastFocussedC) {
                FreeMind.this.logger.info("Fokus has " + pComponent);
                this.lastFocussedC = pComponent;
            }
            if (pComponent instanceof Container) {
                Container container = (Container)pComponent;
                for (int i = 0; i < container.getComponents().length; ++i) {
                    Component child = container.getComponents()[i];
                    this.searchFocus(child);
                }
            }
        }
    }
}

