/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.EdgeWidthFormatAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.modes.EdgeAdapter;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeActorXml;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;

public class EdgeWidthAction
extends NodeGeneralAction
implements NodeActorXml {
    private int mWidth;

    public EdgeWidthAction(MindMapController controller, int width) {
        super(controller, null, null);
        this.mWidth = width;
        this.setName(EdgeWidthAction.getWidthTitle(controller, width));
        this.addActor(this);
    }

    @Override
    public ActionPair apply(MindMap model, MindMapNode selected) {
        return this.getActionPair(selected, this.mWidth);
    }

    @Override
    public Class getDoActionClass() {
        return EdgeWidthFormatAction.class;
    }

    public void setEdgeWidth(MindMapNode node, int width) {
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(this.getActionPair(node, width));
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    private ActionPair getActionPair(MindMapNode selected, int width) {
        EdgeWidthFormatAction styleAction = this.createEdgeWidthFormatAction(selected, width);
        EdgeWidthFormatAction undoStyleAction = this.createEdgeWidthFormatAction(selected, ((EdgeAdapter)selected.getEdge()).getRealWidth());
        return new ActionPair((XmlAction)styleAction, (XmlAction)undoStyleAction);
    }

    private EdgeWidthFormatAction createEdgeWidthFormatAction(MindMapNode selected, int width) {
        EdgeWidthFormatAction edgeWidthAction = new EdgeWidthFormatAction();
        edgeWidthAction.setNode(this.getNodeID(selected));
        edgeWidthAction.setWidth(width);
        return edgeWidthAction;
    }

    @Override
    public void act(XmlAction action) {
        if (action instanceof EdgeWidthFormatAction) {
            EdgeWidthFormatAction edgeWithAction = (EdgeWidthFormatAction)action;
            NodeAdapter node = this.getNodeFromID(edgeWithAction.getNode());
            int width = edgeWithAction.getWidth();
            EdgeAdapter edge = (EdgeAdapter)node.getEdge();
            if (edge.getRealWidth() != width) {
                edge.setWidth(width);
                this.modeController.nodeChanged(node);
            }
        }
    }

    private static String getWidthTitle(MindMapController controller, int width) {
        String returnValue = width == -1 ? controller.getText("edge_width_parent") : (width == 0 ? controller.getText("edge_width_thin") : Integer.toString(width));
        return returnValue;
    }
}

