/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;
import splmm.Actions.AbstractMonitoringAction;
import splmm.BibTex;
import splmm.BookmarkMindMapNode;
import splmm.FileFilter.PdfFileFilter;
import splmm.Localization.LocalizationSupport;
import splmm.SciPloreUtils;
import splmm.SplmmAttributes;
import splmm.Thread.EventSenderThread;

public class AddMonitoringDirAction
extends AbstractMonitoringAction {
    private MindMapNode selected;

    public AddMonitoringDirAction(MindMapController controller) {
        super(LocalizationSupport.message("splmm_monitoringDir_add"), controller);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.selected = this.controller.getSelected();
        int result = this.ShowFileChooser(null);
        if (result == 0) {
            if (this.directory != null) {
                new EventSenderThread(SciPloreUtils.EVENT_ADD_MON_DIR, this.directory.getPath());
            } else {
                new EventSenderThread(SciPloreUtils.EVENT_ADD_MON_DIR, "");
            }
            this.controller.getFrame().out(LocalizationSupport.message("splmm_monitoringDir_importBookmarks"));
            this.AddMonitoringAtrributes(this.selected);
            this.ExecuteMyTask(new MyTask());
            this.controller.getFrame().out(LocalizationSupport.message("splmm_monitoringDir_pasteBookmarks"));
            this.controller.getSelectedView().getAttributeView().setOptimalColumnWidth();
            BookmarkMindMapNode.SetOptimalColumnWidth(this.selected, this.directory.getPath(), SciPloreUtils.SPLMM_DIRMON_SUBDIRS);
        }
    }

    private class MyTask
    extends AbstractMonitoringAction.Task {
        List<File> monDirFiles;
        List<MindMapNode> monDirFilesLinkedNodes;
        List<BibTex> bibTexList;
        MindMapNode node;
        MindMapNode equalNode;
        PdfFileFilter pdfFilter = new PdfFileFilter();

        private MyTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            int counter = 0;
            this.bibTexList = BookmarkMindMapNode.ReadBibtexFile();
            this.monDirFilesLinkedNodes = this.getNodesLinkedToMonDirFiles(AddMonitoringDirAction.this.controller.getRootNode());
            boolean importSubfolder = AddMonitoringDirAction.this.isImportSubfolder(AddMonitoringDirAction.this.selected);
            this.monDirFiles = this.getMonDirFilesFromDir(AddMonitoringDirAction.this.directory, importSubfolder);
            for (File monDirFile : this.monDirFiles) {
                System.out.println("Imported " + counter + " files.");
                ++counter;
                this.equalNode = AddMonitoringDirAction.this.GetEqualNodeFromList(this.monDirFilesLinkedNodes, monDirFile);
                if (this.equalNode == null) {
                    this.node = this.pdfFilter.accept(monDirFile) ? this.ImportBookmarksFromFile(monDirFile, this.bibTexList) : new BookmarkMindMapNode(monDirFile.getPath(), monDirFile.getName(), AddMonitoringDirAction.this.controller.getController());
                    if (this.node == null) continue;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            AddMonitoringDirAction.this.controller.paste(MyTask.this.node, AddMonitoringDirAction.this.selected);
                            AddMonitoringDirAction.this.controller.getController().getMapModule().getView().repaintSelecteds();
                        }
                    });
                    continue;
                }
                if (!this.pdfFilter.accept(this.equalNode.getLink())) continue;
                SplmmAttributes splmmAttributes = this.equalNode.getSPLMMAttributes();
                Date monDirFileLastModified = new Date(monDirFile.lastModified());
                if (splmmAttributes != null && !splmmAttributes.getBookmarksUpdated().before(monDirFileLastModified) || !AddMonitoringDirAction.this.isNodeParent(AddMonitoringDirAction.this.selected, this.equalNode)) continue;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AddMonitoringDirAction.this.importBookmarks(MyTask.this.equalNode);
                    }
                });
            }
            return null;
        }
    }
}

