/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import splmm.BookmarkMindMapNode;
import splmm.FileFilter.MonDirFileFilter;
import splmm.SciPloreUtils;
import splmm.SplmmAttributes;

public abstract class SplmmAbstractAction
extends AbstractAction {
    public MindMapController controller;

    public SplmmAbstractAction(String name, MindMapController controller) {
        super(name);
        this.controller = controller;
    }

    protected boolean isLinkedToPDF(MindMapNode node) {
        String link = node.getLink();
        if (link == null) {
            return false;
        }
        if (!link.contains(".")) {
            return false;
        }
        String dateiendung = link.substring(link.lastIndexOf("."));
        Boolean hasPDFendung = dateiendung.substring(1).equalsIgnoreCase("pdf");
        if (hasPDFendung.booleanValue()) {
            File file = this.getFileFromLink(node);
            return file != null && file.exists();
        }
        return false;
    }

    protected boolean isLinkedToMonDirFile(MindMapNode node) {
        MonDirFileFilter filter = new MonDirFileFilter();
        String link = node.getLink();
        if (filter.accept(link)) {
            File file = this.getFileFromLink(node);
            return file != null && file.exists();
        }
        return false;
    }

    protected File getFileFromLink(MindMapNode node) {
        File pdfFile;
        block11: {
            pdfFile = new File(node.getLink());
            if (!pdfFile.isAbsolute()) {
                pdfFile = new File(this.controller.getModel().getFile().getParent() + "\\\\" + node.getLink());
                if (pdfFile.exists()) {
                    try {
                        return pdfFile.getCanonicalFile();
                    }
                    catch (Exception e) {
                        SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                        break block11;
                    }
                }
                try {
                    URI uri = new URI("file:/" + node.getLink());
                    pdfFile = new File(uri);
                    pdfFile = new File(this.controller.getModel().getFile().getParent() + pdfFile.getPath());
                    if (pdfFile.exists()) {
                        try {
                            return pdfFile.getCanonicalFile();
                        }
                        catch (IOException e) {
                            SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                        }
                    }
                }
                catch (Exception e) {
                    SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                }
            }
        }
        try {
            return pdfFile.getCanonicalFile();
        }
        catch (Exception e) {
            SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
            return null;
        }
    }

    public void importBookmarks(MindMapNode node) {
        File pdfFile;
        if (this.isLinkedToPDF(node) && (pdfFile = this.getFileFromLink(node)).exists()) {
            MindMapNode bookmarkNode = BookmarkMindMapNode.getBookmarksFromFile(pdfFile, this.controller.getController());
            this.pasteBookmarks(node, bookmarkNode);
            this.controller.getSelectedView().getAttributeView().setOptimalColumnWidth();
        }
    }

    protected void importBookmarks(List<MindMapNode> equalNodes, File monDirFile, MindMapNode target) {
        MindMapNode bookmarkNode = BookmarkMindMapNode.getBookmarksFromFile(monDirFile, this.controller.getController());
        List<MindMapNode> newNodes = this.getNewNodes(equalNodes, bookmarkNode);
        List<MindMapNode> oldNodes = this.getOldNodes(bookmarkNode, newNodes);
        for (MindMapNode oldNode : oldNodes) {
            oldNode.removeFromParent();
        }
        if (bookmarkNode.hasChildren()) {
            MindMapNode equalChild = this.getEqualChild(bookmarkNode, target);
            if (equalChild == null) {
                this.controller.paste(bookmarkNode, target);
            } else {
                this.pasteBookmarks(equalChild, bookmarkNode);
            }
        }
        for (MindMapNode node : equalNodes) {
            if (node.getSPLMMAttributes() != null) {
                node.setSPLMMAttributes(new SplmmAttributes());
            }
            node.getSPLMMAttributes().setBookmarksUpdated(new Date());
        }
        this.controller.getSelectedView().getAttributeView().setOptimalColumnWidth();
    }

    private void pasteBookmarks(MindMapNode node, MindMapNode bookmarkNode) {
        List bookmarks = bookmarkNode.getChildren();
        for (MindMapNode bookmark : bookmarks) {
            MindMapNode equalChild = this.getEqualChild(bookmark, node);
            if (equalChild == null) {
                this.controller.paste(bookmark, node);
                continue;
            }
            this.pasteBookmarks(equalChild, bookmark);
        }
        if (node.getSPLMMAttributes() != null) {
            node.getSPLMMAttributes().setBookmarksUpdated(new Date());
        }
    }

    private MindMapNode getEqualChild(MindMapNode bookmark, MindMapNode node) {
        ListIterator childrenFolded = node.childrenFolded();
        while (childrenFolded.hasNext()) {
            MindMapNode child = (MindMapNode)childrenFolded.next();
            if (!child.getText().equalsIgnoreCase(bookmark.getText())) continue;
            return child;
        }
        ListIterator childrenUnFolded = node.childrenUnfolded();
        while (childrenUnFolded.hasNext()) {
            MindMapNode child = (MindMapNode)childrenUnFolded.next();
            if (!child.getText().equalsIgnoreCase(bookmark.getText())) continue;
            return child;
        }
        return null;
    }

    private MindMapNode getEqualChildRecursive(MindMapNode bookmark, MindMapNode node) {
        ListIterator childrenFolded = node.childrenFolded();
        while (childrenFolded.hasNext()) {
            MindMapNode equalChild;
            MindMapNode child = (MindMapNode)childrenFolded.next();
            if (child.getText().equalsIgnoreCase(bookmark.getText())) {
                return child;
            }
            if (!child.hasChildren() || (equalChild = this.getEqualChildRecursive(bookmark, child)) == null) continue;
            return equalChild;
        }
        ListIterator childrenUnFolded = node.childrenUnfolded();
        while (childrenUnFolded.hasNext()) {
            MindMapNode equalChild;
            MindMapNode child = (MindMapNode)childrenUnFolded.next();
            if (child.getText().equalsIgnoreCase(bookmark.getText())) {
                return child;
            }
            if (!child.hasChildren() || (equalChild = this.getEqualChildRecursive(bookmark, child)) == null) continue;
            return equalChild;
        }
        return null;
    }

    private List<MindMapNode> getEqualChildrenRecursive(MindMapNode bookmark, MindMapNode node) {
        ArrayList<MindMapNode> result = new ArrayList<MindMapNode>();
        ListIterator childrenFolded = node.childrenFolded();
        while (childrenFolded.hasNext()) {
            MindMapNode child = (MindMapNode)childrenFolded.next();
            if (child.getText().equalsIgnoreCase(bookmark.getText())) {
                result.add(child);
                continue;
            }
            if (!child.hasChildren()) continue;
            result.addAll(this.getEqualChildrenRecursive(bookmark, child));
        }
        ListIterator childrenUnFolded = node.childrenUnfolded();
        while (childrenUnFolded.hasNext()) {
            MindMapNode child = (MindMapNode)childrenUnFolded.next();
            if (child.getText().equalsIgnoreCase(bookmark.getText())) {
                result.add(child);
                continue;
            }
            if (!child.hasChildren()) continue;
            result.addAll(this.getEqualChildrenRecursive(bookmark, child));
        }
        return result;
    }

    public void importOnlyNewBookmarksToTarget(List<MindMapNode> nodes, MindMapNode target) {
        File pdfFile;
        if (nodes.size() <= 0) {
            return;
        }
        MindMapNode node = nodes.get(0);
        if (this.isLinkedToPDF(node) && (pdfFile = this.getFileFromLink(node)).exists()) {
            MindMapNode bookmarkNode = BookmarkMindMapNode.getBookmarksFromFile(pdfFile, this.controller.getController());
            List<MindMapNode> newNodes = this.getNewNodes(nodes, bookmarkNode);
            List<MindMapNode> oldNodes = this.getOldNodes(bookmarkNode, newNodes);
            for (MindMapNode oldNode : oldNodes) {
                oldNode.removeFromParent();
            }
            if (bookmarkNode.hasChildren()) {
                MindMapNode equalChild = this.getEqualChild(bookmarkNode, target);
                if (equalChild == null) {
                    this.controller.paste(bookmarkNode, target);
                } else {
                    this.pasteBookmarks(equalChild, bookmarkNode);
                }
            }
            this.controller.getSelectedView().getAttributeView().setOptimalColumnWidth();
        }
    }

    private List<MindMapNode> getOldNodes(MindMapNode bookmarkNode, List<MindMapNode> newNodes) {
        boolean delete = true;
        List bookmarks = bookmarkNode.getChildren();
        ArrayList<MindMapNode> result = new ArrayList<MindMapNode>();
        for (MindMapNode bookmark : bookmarks) {
            for (MindMapNode newNode : newNodes) {
                if (!this.isNodeParent(bookmark, newNode) && !newNodes.contains(bookmark)) continue;
                delete = false;
                break;
            }
            if (delete) {
                result.add(bookmark);
            } else {
                result.addAll(this.getOldNodes(bookmark, newNodes));
            }
            delete = true;
        }
        return result;
    }

    private List<MindMapNode> getNewNodes(List<MindMapNode> nodes, MindMapNode bookmarkNode) {
        List bookmarks = bookmarkNode.getChildren();
        ArrayList<MindMapNode> result = new ArrayList<MindMapNode>();
        for (MindMapNode bookmark : bookmarks) {
            boolean add = true;
            for (MindMapNode node : nodes) {
                String nodeTitle = node.getText();
                String bookmarkTitle = bookmark.getText();
                nodeTitle = nodeTitle.replaceAll("\r", "");
                nodeTitle = nodeTitle.replaceAll("\n", "");
                nodeTitle = nodeTitle.replaceAll("\t", " ");
                bookmarkTitle = bookmarkTitle.replaceAll("\r", "");
                bookmarkTitle = bookmarkTitle.replaceAll("\n", "");
                if (!nodeTitle.equalsIgnoreCase(bookmarkTitle = bookmarkTitle.replaceAll("\t", " "))) continue;
                add = false;
                break;
            }
            if (add) {
                bookmark.setSPLMMAttributes(new SplmmAttributes());
                bookmark.getSPLMMAttributes().setBookmarksUpdated(new Date());
                result.add(bookmark);
            }
            result.addAll(this.getNewNodes(nodes, bookmark));
        }
        return result;
    }

    protected boolean isNodeParent(MindMapNode maybeParent, MindMapNode child) {
        for (MindMapNode parent = child.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!parent.equals(maybeParent)) continue;
            return true;
        }
        return false;
    }

    protected boolean isDoubleNode(MindMapNode equalNode) {
        List<MindMapNode> maybeDoubleNodes = this.getEqualChildrenRecursive(equalNode, this.controller.getRootNode());
        for (MindMapNode node : maybeDoubleNodes) {
            if (node.equals(equalNode)) continue;
            return true;
        }
        return false;
    }
}

