/*
 * Decompiled with CFR 0.152.
 */
package splmm.Preferences;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferencesChangeListener;
import splmm.SciPloreUtils;
import splmm.SciPloreWebClient;

public class SplmmPreferences {
    private static final Preferences preferences = Preferences.userRoot().node("SplmmPreferences");
    public static final String JAB_REF_PATH = "JabRefPath";
    public static final String UPDATE_INFO = "UpdateInfo";
    public static final String ALLOW_USAGE_MINING = "AllowUsageMining";
    public static final String ALLOW_IR_ON_MM = "AllowIRonMM";
    public static final String ALLOW_IR_ON_LD = "AllowIRonLD";
    public static final String ALLOW_BACKUP = "AllowBackup";
    public static final String VERSION = "Version";
    public static final String AUTO_IMPORT = "AutoImport";
    public static final String USER_NAME = "UserName";
    public static final String PASSWORD = "Password";
    public static final String CREDENTIALS_VALIDATED = "CredentialsValidated";
    public static final String ANONYMOUS_USER_NAME = "AnonymousUserName";
    public static final String BACKUP_SAVE = "BackupSave";
    public static final String START_COUNTER = "StartCounter";
    public static final String INFORMED_UPDATE_VERSION = "InformedUpdateVersion";
    public static final String SHOW_BACKUP_NOTIFICATION = "ShowBackupNotification";
    public static final String FILE_TYPES = "FileTypes";
    public static final String SUBFOLDERS = "SubFolders";
    public static final String AUTO_MON_DIR = "AutomaticMonitoredDir";
    public static final String IGNORE_SUBFOLDERS = "IgnoreSubfolder";
    public static final String IR_NOTIFICATION_COUNTER = "IrNotificationCounter";
    public static final String SHOW_IR_NOTIFICATION = "ShowIrNotification";
    public static final String SCREEN_RES = "ScreenResolution";
    public static final String SEND_EVENT_BIB_LINKED = "SendEvent_BibLinked";
    public static final String SEND_EVENT_BACKUP = "SendEvent_Backup";
    public static final String SEND_EVENT_IRMM = "SendEvent_Irmm";
    public static final String SEND_EVENT_IRLD = "SendEvent_Irld";
    public static final String SEND_EVENT_AUTO_IMPORT = "SendEvent_AutoImport";
    public static final String SEND_EVENT_OLD_USERNAME = "SendEvent_OldUsername";
    public static final String SEND_EVENT_ALLOW_USAGE_MINING = "SendEvent_AllowUsageMining";
    public static final String RANDOM_TAB = "RandomTab";
    public static final String RANDOM_UM = "RandomUM";
    public static final String RANDOM_IRMM = "RandomIRMM";
    public static final String RANDOM_IRLD = "RandomIRLD";
    public static final String RANDOM_BACKUP = "RandomBackup";
    public static final String RANDOM_INFOTEXT = "RandomInfotext";
    public static final String RANDOM_INFOLABEL = "RandomInfolabel";
    public static final String RANDOM_PRIVACY_BUTTON = "RandomPrivacyButton";

    public static void init() {
        preferences.addPreferenceChangeListener(new SplmmPreferencesChangeListener());
    }

    public static void setRandomTab(String randomTab) {
        preferences.put(RANDOM_TAB, randomTab);
    }

    public static String getRandomTab() {
        return preferences.get(RANDOM_TAB, null);
    }

    public static void setRandomUM(String randomUM) {
        preferences.put(RANDOM_UM, randomUM);
    }

    public static String getRandomUM() {
        return preferences.get(RANDOM_UM, null);
    }

    public static void setRandomIRMM(String randomIRMM) {
        preferences.put(RANDOM_IRMM, randomIRMM);
    }

    public static String getRandomIRMM() {
        return preferences.get(RANDOM_IRMM, null);
    }

    public static void setRandomIRLD(String randomIRLD) {
        preferences.put(RANDOM_IRLD, randomIRLD);
    }

    public static String getRandomIRLD() {
        return preferences.get(RANDOM_IRLD, null);
    }

    public static void setRandomBackup(String randomBackup) {
        preferences.put(RANDOM_BACKUP, randomBackup);
    }

    public static String getRandomBackup() {
        return preferences.get(RANDOM_BACKUP, null);
    }

    public static void setRandomInfoText(String randomInfoText) {
        preferences.put(RANDOM_INFOTEXT, randomInfoText);
    }

    public static String getRandomInfoText() {
        return preferences.get(RANDOM_INFOTEXT, null);
    }

    public static void setRandomInfoLabel(String randomInfoLabel) {
        preferences.put(RANDOM_INFOLABEL, randomInfoLabel);
    }

    public static String getRandomInfoLabel() {
        return preferences.get(RANDOM_INFOLABEL, null);
    }

    public static void setRandomPrivacyButton(String randomPrivacyButton) {
        preferences.put(RANDOM_PRIVACY_BUTTON, randomPrivacyButton);
    }

    public static String getRandomPrivacyButton() {
        return preferences.get(RANDOM_PRIVACY_BUTTON, null);
    }

    public static void setScreenResolution(String screenResolution) {
        preferences.put(SCREEN_RES, screenResolution);
    }

    public static String getScreenResolution() {
        return preferences.get(SCREEN_RES, null);
    }

    public static void setSendOldUsername(String oldUsername) {
        preferences.put(SEND_EVENT_OLD_USERNAME, oldUsername);
    }

    public static String getSendOldUsername() {
        return preferences.get(SEND_EVENT_OLD_USERNAME, null);
    }

    public static void setAutoMonDir(boolean auto) {
        preferences.putBoolean(AUTO_MON_DIR, auto);
    }

    public static boolean getAutoMonDir() {
        return preferences.getBoolean(AUTO_MON_DIR, true);
    }

    public static void setImportSubfolders(boolean ignore) {
        preferences.putBoolean(IGNORE_SUBFOLDERS, ignore);
    }

    public static boolean getImportSubfolders() {
        return preferences.getBoolean(IGNORE_SUBFOLDERS, true);
    }

    public static void setStringList(String name, List<String> stringList) {
        try {
            if (preferences.nodeExists(name)) {
                preferences.node(name).removeNode();
            }
            Preferences listNode = preferences.node(name);
            String keyPrefix = name;
            int i = 0;
            for (String string : stringList) {
                String key = keyPrefix + i;
                listNode.put(key, string);
                ++i;
            }
        }
        catch (BackingStoreException e) {
            SciPloreUtils.logException(SplmmPreferences.class.getName(), e, Level.WARNING);
        }
    }

    public static ArrayList<String> getStringList(String name, ArrayList<String> defaultList) {
        ArrayList<String> stringList = new ArrayList<String>();
        try {
            if (!preferences.nodeExists(name)) {
                return defaultList;
            }
            Preferences listNode = preferences.node(name);
            for (String key : listNode.keys()) {
                stringList.add(listNode.get(key, null));
            }
        }
        catch (BackingStoreException e) {
            SciPloreUtils.logException(SplmmPreferences.class.getName(), e, Level.WARNING);
        }
        return stringList;
    }

    public static void setShowIrNotification(boolean show) {
        preferences.putBoolean(SHOW_IR_NOTIFICATION, show);
    }

    public static boolean getShowIrNotification() {
        return preferences.getBoolean(SHOW_IR_NOTIFICATION, true);
    }

    public static void setShowBackupNotification(boolean show) {
        preferences.putBoolean(SHOW_BACKUP_NOTIFICATION, show);
    }

    public static boolean getShowBackupNotification() {
        return preferences.getBoolean(SHOW_BACKUP_NOTIFICATION, true);
    }

    public static void setSendEventBibLinked(boolean send) {
        preferences.putBoolean(SEND_EVENT_BIB_LINKED, send);
    }

    public static boolean getSendEventBibLinked() {
        return preferences.getBoolean(SEND_EVENT_BIB_LINKED, true);
    }

    public static void setSendEventBackup(boolean send) {
        preferences.putBoolean(SEND_EVENT_BACKUP, send);
    }

    public static boolean getSendEventBackup() {
        return preferences.getBoolean(SEND_EVENT_BACKUP, true);
    }

    public static void setSendEventUsageMining(boolean send) {
        preferences.putBoolean(SEND_EVENT_ALLOW_USAGE_MINING, send);
    }

    public static boolean getSendEventUsageMining() {
        return preferences.getBoolean(SEND_EVENT_ALLOW_USAGE_MINING, true);
    }

    public static void setSendEventIrmm(boolean send) {
        preferences.putBoolean(SEND_EVENT_IRMM, send);
    }

    public static boolean getSendEventIrmm() {
        return preferences.getBoolean(SEND_EVENT_IRMM, true);
    }

    public static void setSendEventIrld(boolean send) {
        preferences.putBoolean(SEND_EVENT_IRLD, send);
    }

    public static boolean getSendEventIrld() {
        return preferences.getBoolean(SEND_EVENT_IRLD, true);
    }

    public static void setSendEventAutoImport(boolean send) {
        preferences.putBoolean(SEND_EVENT_AUTO_IMPORT, send);
    }

    public static boolean getSendEventAutoImport() {
        return preferences.getBoolean(SEND_EVENT_AUTO_IMPORT, true);
    }

    public static void setInformedUpdateVersion(String version) {
        preferences.put(INFORMED_UPDATE_VERSION, version);
    }

    public static String getInformedUpdateVersion() {
        return preferences.get(INFORMED_UPDATE_VERSION, "");
    }

    public static void setIrNotificationCounter(int starts) {
        preferences.putInt(IR_NOTIFICATION_COUNTER, starts);
    }

    public static int getIrNotificationCounter() {
        return preferences.getInt(IR_NOTIFICATION_COUNTER, 0);
    }

    public static void setStartCounter(int starts) {
        preferences.putInt(START_COUNTER, starts);
    }

    public static int getStartCounter() {
        return preferences.getInt(START_COUNTER, 0);
    }

    public static void setVersion(double version) {
        preferences.putDouble(VERSION, version);
    }

    public static double getVersion() {
        return preferences.getDouble(VERSION, -1.0);
    }

    public static void setJabRefPath(String path) {
        preferences.put(JAB_REF_PATH, path);
    }

    public static String getJabRefPath() {
        return preferences.get(JAB_REF_PATH, null);
    }

    public static void setUpdateInfo(Boolean updateInfo) {
        preferences.putBoolean(UPDATE_INFO, updateInfo);
    }

    public static Boolean getUpdateInfo() {
        return preferences.getBoolean(UPDATE_INFO, true);
    }

    public static void setAllowUsageMining(Boolean allowUsageMining) {
        preferences.putBoolean(ALLOW_USAGE_MINING, allowUsageMining);
    }

    public static Boolean getAllowUsageMining() {
        return preferences.getBoolean(ALLOW_USAGE_MINING, true);
    }

    public static void setAllowIRonMM(Boolean allowIRonMM) {
        preferences.putBoolean(ALLOW_IR_ON_MM, allowIRonMM);
    }

    public static Boolean getAllowIRonMM() {
        return preferences.getBoolean(ALLOW_IR_ON_MM, true);
    }

    public static void setAllowIRonLD(Boolean allowIRonLD) {
        preferences.putBoolean(ALLOW_IR_ON_LD, allowIRonLD);
    }

    public static Boolean getAllowIRonLD() {
        return preferences.getBoolean(ALLOW_IR_ON_LD, true);
    }

    public static void setAllowBackup(Boolean allowBackup) {
        preferences.putBoolean(ALLOW_BACKUP, allowBackup);
    }

    public static Boolean getAllowBackup() {
        return preferences.getBoolean(ALLOW_BACKUP, true);
    }

    public static void setAutoImport(Boolean autoImport) {
        preferences.putBoolean(AUTO_IMPORT, autoImport);
    }

    public static Boolean getAutoImport() {
        return preferences.getBoolean(AUTO_IMPORT, true);
    }

    public static void setUserName(String userName) {
        if (SplmmPreferences.getUserName() != null && !SplmmPreferences.getUserName().equalsIgnoreCase(userName)) {
            SplmmPreferences.setSendOldUsername(SplmmPreferences.getUserName());
        }
        preferences.put(USER_NAME, userName);
    }

    public static String getUserName() {
        return preferences.get(USER_NAME, null);
    }

    public static void setBackupSave(boolean backupSave) {
        preferences.putBoolean(BACKUP_SAVE, backupSave);
    }

    public static boolean getBackupSave() {
        return preferences.getBoolean(BACKUP_SAVE, false);
    }

    public static void setAnonymousUserName(String anonymousUserName) {
        preferences.put(ANONYMOUS_USER_NAME, anonymousUserName);
    }

    public static String getAnonymousUserName() {
        return preferences.get(ANONYMOUS_USER_NAME, null);
    }

    public static void setCredentialsValidated(Boolean validated) {
        preferences.putBoolean(CREDENTIALS_VALIDATED, validated);
    }

    public static Boolean getCredentialsValidated() {
        return preferences.getBoolean(CREDENTIALS_VALIDATED, false);
    }

    public static void setPassword(String password) {
        if (password == null || password.isEmpty()) {
            preferences.remove(PASSWORD);
            return;
        }
        try {
            password = SplmmPreferences.convertToSaltedMD5Digest("spl", password);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(SciPloreUtils.getStackTraceAsString(e));
            JOptionPane.showMessageDialog(null, LocalizationSupport.message("could.not.save.password"), LocalizationSupport.message("error"), 0);
            password = null;
        }
        preferences.put(PASSWORD, password);
    }

    public static String getPassword() {
        return preferences.get(PASSWORD, null);
    }

    public static void createUUID() {
        if (SplmmPreferences.getAnonymousUserName() != null) {
            boolean created;
            SplmmPreferences.setUserName(SplmmPreferences.getAnonymousUserName());
            if (!SplmmPreferences.getCredentialsValidated().booleanValue() && !(created = SciPloreWebClient.createAnonymousUser(SplmmPreferences.getAnonymousUserName()).booleanValue())) {
                UUID uuid;
                while (!(created = SciPloreWebClient.createAnonymousUser((uuid = UUID.randomUUID()).toString()).booleanValue())) {
                }
                SplmmPreferences.setUserName(uuid.toString());
            }
        } else {
            String username;
            SplmmPreferences.setCredentialsValidated(false);
            Boolean created = false;
            do {
                UUID uuid;
                if ((username = (uuid = UUID.randomUUID()).toString()) == null || username.isEmpty()) continue;
                SplmmPreferences.setAnonymousUserName(username);
                created = SciPloreWebClient.createAnonymousUser(username);
            } while (!created.booleanValue());
            SplmmPreferences.setUserName(username);
        }
        SplmmPreferences.setPassword(null);
    }

    public static boolean validateBackupEntry() {
        return SplmmPreferences.validateBackupEntry(SplmmPreferences.getUserName(), SplmmPreferences.getPassword());
    }

    public static boolean validateBackupEntry(String username, String password) {
        if (username == null || username.isEmpty() || password == null || password.isEmpty()) {
            JOptionPane.showMessageDialog(null, LocalizationSupport.message("enter.user.name.and.password.to.backup.mindmaps"), LocalizationSupport.message("error"), 0);
            return false;
        }
        SplmmPreferences.setUserName(username);
        SplmmPreferences.setPassword(password);
        SplmmPreferences.setCredentialsValidated(false);
        SciPloreWebClient.ValidationState state = SciPloreWebClient.validateUserData(username, password);
        if (state == SciPloreWebClient.ValidationState.VALID) {
            return true;
        }
        if (state == SciPloreWebClient.ValidationState.EXCEPTION) {
            JOptionPane.showMessageDialog(null, LocalizationSupport.message("could.not.validate.user.name.and.password"), LocalizationSupport.message("problem"), 0);
        } else if (state == SciPloreWebClient.ValidationState.NOT_VALID) {
            return false;
        }
        return true;
    }

    private static String convertToSaltedMD5Digest(String salt, String plainText) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update((salt + plainText).getBytes());
        byte[] md5Digest = md5.digest();
        StringBuilder stringBuilder = new StringBuilder();
        for (byte aMd5Digest : md5Digest) {
            stringBuilder.append(SplmmPreferences.toHexString(aMd5Digest));
        }
        return stringBuilder.toString();
    }

    public static String toHexString(byte b) {
        int value = (b & 0x7F) + (b < 0 ? 128 : 0);
        String ret = value < 16 ? "0" : "";
        ret = ret + Integer.toHexString(value).toUpperCase();
        return ret;
    }

    public static void checkInEvents() {
        boolean send;
        if (!SplmmPreferences.getAllowUsageMining().booleanValue()) {
            return;
        }
        if (SplmmPreferences.getSendEventBibLinked()) {
            send = SplmmPreferences.getJabRefPath() == null || SplmmPreferences.getJabRefPath().isEmpty() ? SciPloreWebClient.sendEvent(SciPloreUtils.EVENT_BIB_LINKED, "0") : SciPloreWebClient.sendEvent(SciPloreUtils.EVENT_BIB_LINKED, SplmmPreferences.getJabRefPath());
            if (send) {
                SplmmPreferences.setSendEventBibLinked(false);
            } else {
                return;
            }
        }
        if (SplmmPreferences.getSendEventBackup()) {
            send = SciPloreWebClient.sendEvent(SciPloreUtils.EVENT_BACKUP, "" + SciPloreUtils.parseBoolean(SplmmPreferences.getAllowBackup()));
            if (send) {
                SplmmPreferences.setSendEventBackup(false);
            } else {
                return;
            }
        }
        if (SplmmPreferences.getSendEventIrmm()) {
            send = SciPloreWebClient.sendEvent(SciPloreUtils.EVENT_IRMM, "" + SciPloreUtils.parseBoolean(SplmmPreferences.getAllowIRonMM()));
            if (send) {
                SplmmPreferences.setSendEventIrmm(false);
            } else {
                return;
            }
        }
        if (SplmmPreferences.getSendEventIrld()) {
            send = SciPloreWebClient.sendEvent(SciPloreUtils.EVENT_IRLD, "" + SciPloreUtils.parseBoolean(SplmmPreferences.getAllowIRonLD()));
            if (send) {
                SplmmPreferences.setSendEventIrld(false);
            } else {
                return;
            }
        }
        if (SplmmPreferences.getSendEventAutoImport()) {
            send = SciPloreWebClient.sendEvent(SciPloreUtils.EVENT_AUTO_IMPORT, "" + SciPloreUtils.parseBoolean(SplmmPreferences.getAutoImport()));
            if (send) {
                SplmmPreferences.setSendEventAutoImport(false);
            } else {
                return;
            }
        }
    }
}

