/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.hibernate.Session;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sciplore.resources.Document;
import org.sciplore.resources.Resource;

@Entity
public class DocumentFulltext
extends Resource {
    public static final short DOCUMENTFULLTEXT_TYPE_ABSTRACT = 2;
    public static final short DOCUMENTFULLTEXT_TYPE_KEYWORDS = 3;
    public static final short DOCUMENTFULLTEXT_TYPE_INTRODUCTION = 4;
    public static final short DOCUMENTFULLTEXT_TYPE_RELATEDWORK = 5;
    public static final short DOCUMENTFULLTEXT_TYPE_METHODOLOGY = 6;
    public static final short DOCUMENTFULLTEXT_TYPE_RESULTS = 7;
    public static final short DOCUMENTFULLTEXT_TYPE_DISCUSSION = 8;
    public static final short DOCUMENTFULLTEXT_TYPE_CONCLUSION = 9;
    public static final short DOCUMENTFULLTEXT_TYPE_SUMMARY = 10;
    public static final short DOCUMENTFULLTEXT_TYPE_OUTLOOK = 11;
    public static final short DOCUMENTFULLTEXT_TYPE_ACKNOWLEDGMENT = 12;
    public static final short DOCUMENTFULLTEXT_TYPE_BIBLIOGRAPHY = 13;
    public static final short DOCUMENTFULLTEXT_TYPE_OTHER = 14;
    public static final short DOCUMENTFULLTEXT_TYPE_BASICCONCEPTS = 15;
    public static final short DOCUMENTFULLTEXT_TYPE_EXPERIMENTS = 16;
    public static final short DOCUMENTFULLTEXT_TYPE_TEXT = 17;
    @ManyToOne
    @JoinColumn(name="document_id", nullable=false)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Document document;
    private Short field;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    private Short rank;
    private String text;

    public DocumentFulltext getDocumentFulltext(DocumentFulltext df) {
        if (df.getId() != null) {
            return this.getDocumentFulltext(df.getId());
        }
        return this.getDocumentFulltext(df.getDocument(), df.getField(), df.getRank());
    }

    public DocumentFulltext getDocumentFulltext(Integer id) {
        return (DocumentFulltext)this.getSession().get(DocumentFulltext.class, (Serializable)id);
    }

    public DocumentFulltext getDocumentFulltext(Document d, Short f, Short r) {
        return (DocumentFulltext)this.getSession().createCriteria(DocumentFulltext.class).add((Criterion)Restrictions.eq((String)"document", (Object)d)).add((Criterion)Restrictions.eq((String)"field", (Object)f)).add((Criterion)Restrictions.eq((String)"rank", (Object)r)).setMaxResults(1).uniqueResult();
    }

    public DocumentFulltext() {
    }

    public DocumentFulltext(Session s) {
        this.setSession(s);
    }

    public Document getDocument() {
        return this.document;
    }

    public Short getField() {
        return this.field;
    }

    public String getFieldName() {
        switch (this.field) {
            case 2: {
                return "abstract";
            }
            case 12: {
                return "acknowledgment";
            }
            case 15: {
                return "basicconcepts";
            }
            case 13: {
                return "bibliography";
            }
            case 9: {
                return "conclusion";
            }
            case 8: {
                return "discussion";
            }
            case 16: {
                return "experiments";
            }
            case 4: {
                return "introduction";
            }
            case 3: {
                return "keywords";
            }
            case 6: {
                return "methodology";
            }
            case 14: {
                return "other";
            }
            case 11: {
                return "outlook";
            }
            case 5: {
                return "relatedwork";
            }
            case 7: {
                return "results";
            }
            case 10: {
                return "summary";
            }
            case 17: {
                return "text";
            }
        }
        return "unknown";
    }

    public Integer getId() {
        return this.id;
    }

    public Short getRank() {
        return this.rank;
    }

    public String getText() {
        return this.text;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setField(Short field) {
        this.field = field;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setRank(Short rank) {
        this.rank = rank;
    }

    public void setText(String text) {
        this.text = text;
    }
}

