/*
 * Decompiled with CFR 0.152.
 */
package plugins.svg;

import freemind.extensions.ExportHook;
import freemind.main.Resources;
import freemind.view.mindmapview.MapView;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class ExportVectorGraphic
extends ExportHook {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SVGGraphics2D fillSVGGraphics2D(MapView view) {
        DOMImplementation impl = GenericDOMImplementation.getDOMImplementation();
        String namespaceURI = "http://www.w3.org/2000/svg";
        Document domFactory = impl.createDocument(namespaceURI, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)domFactory);
        ctx.setEmbeddedFontsOn(true);
        SVGGeneratorContext.GraphicContextDefaults defaults = new SVGGeneratorContext.GraphicContextDefaults();
        defaults.setFont(new Font("Arial", 0, 12));
        ctx.setGraphicContextDefaults(defaults);
        ctx.setPrecision(12);
        SVGGraphics2D g2d = new SVGGraphics2D(ctx, false);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        try {
            view.preparePrinting();
            Rectangle innerBounds = view.getInnerBounds();
            g2d.setSVGCanvasSize(new Dimension(innerBounds.width, innerBounds.height));
            g2d.translate(-innerBounds.x, -innerBounds.y);
            view.print((Graphics)g2d);
        }
        finally {
            view.endPrinting();
        }
        return g2d;
    }

    public void transForm(Source xmlSource, InputStream xsltStream, File resultFile, String areaCode) {
        StreamSource xsltSource = new StreamSource(xsltStream);
        StreamResult result = new StreamResult(resultFile);
        try {
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.setParameter("destination_dir", resultFile.getName() + "_files/");
            trans.setParameter("area_code", areaCode);
            trans.setParameter("folding_type", this.getController().getFrame().getProperty("html_export_folding"));
            trans.transform(xmlSource, result);
        }
        catch (Exception e) {
            Resources.getInstance().logException((Throwable)e);
        }
    }
}

