/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.controller.Controller;
import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.modes.ModeController;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.BorderLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

public class EditNodeBase {
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_SPLIT = 2;
    protected NodeView node;
    private EditControl editControl;
    private ModeController controller;
    protected String text;
    protected FocusListener textFieldListener = null;

    EditNodeBase(NodeView node, String text, ModeController controller, EditControl editControl) {
        this.controller = controller;
        this.editControl = editControl;
        this.node = node;
        this.text = text;
    }

    protected MapView getView() {
        return this.controller.getView();
    }

    protected ModeController getModeController() {
        return this.controller;
    }

    protected Controller getController() {
        return this.controller.getController();
    }

    protected String getText(String string) {
        return this.controller.getText(string);
    }

    protected FreeMindMain getFrame() {
        return this.controller.getFrame();
    }

    protected boolean binOptionIsTrue(String option) {
        return Resources.getInstance().getBoolProperty(option);
    }

    public void closeEdit() {
        if (this.textFieldListener != null) {
            this.textFieldListener.focusLost(null);
        }
    }

    protected String getText() {
        return this.text;
    }

    public Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public EditControl getEditControl() {
        return this.editControl;
    }

    public NodeView getNode() {
        return this.node;
    }

    public FocusListener getTextFieldListener() {
        return this.textFieldListener;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setTextFieldListener(FocusListener listener) {
        this.textFieldListener = listener;
    }

    protected void redispatchKeyEvents(final JTextComponent textComponent, KeyEvent firstKeyEvent) {
        if (textComponent.hasFocus()) {
            return;
        }
        final KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        class KeyEventQueue
        implements KeyEventDispatcher,
        FocusListener {
            LinkedList events = new LinkedList();

            KeyEventQueue() {
            }

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                this.events.add(e);
                return true;
            }

            @Override
            public void focusGained(FocusEvent e) {
                e.getComponent().removeFocusListener(this);
                currentKeyboardFocusManager.removeKeyEventDispatcher(this);
                for (KeyEvent ke : this.events) {
                    ke.setSource(textComponent);
                    textComponent.dispatchEvent(ke);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        }
        KeyEventQueue keyEventDispatcher = new KeyEventQueue();
        currentKeyboardFocusManager.addKeyEventDispatcher(keyEventDispatcher);
        textComponent.addFocusListener(keyEventDispatcher);
        if (firstKeyEvent == null) {
            return;
        }
        if (firstKeyEvent.getKeyChar() == '\uffff') {
            switch (firstKeyEvent.getKeyCode()) {
                case 36: {
                    textComponent.setCaretPosition(0);
                    break;
                }
                case 35: {
                    textComponent.setCaretPosition(textComponent.getDocument().getLength());
                }
            }
        } else {
            textComponent.selectAll();
            textComponent.dispatchEvent(firstKeyEvent);
        }
    }

    protected class EditPopupMenu
    extends JPopupMenu {
        public EditPopupMenu(JTextComponent textComponent) {
            this.add(new EditCopyAction(textComponent));
        }
    }

    protected class EditCopyAction
    extends AbstractAction {
        private JTextComponent textComponent;

        public EditCopyAction(JTextComponent textComponent) {
            super(EditNodeBase.this.getText("copy"));
            this.textComponent = textComponent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selection = this.textComponent.getSelectedText();
            if (selection != null) {
                EditNodeBase.this.getClipboard().setContents(new StringSelection(selection), null);
            }
        }
    }

    public static interface EditControl {
        public void cancel();

        public void ok(String var1);

        public void split(String var1, int var2);
    }

    static abstract class EditDialog
    extends JDialog {
        private EditNodeBase base;

        EditDialog(EditNodeBase base) {
            super((JFrame)((Object)base.getFrame()), base.getText("edit_long_node"), true);
            this.getContentPane().setLayout(new BorderLayout());
            this.setDefaultCloseOperation(0);
            DialogWindowListener dfl = new DialogWindowListener();
            this.addWindowListener(dfl);
            this.base = base;
        }

        protected void confirmedSubmit() {
            if (this.isChanged()) {
                int action = JOptionPane.showConfirmDialog(this, this.base.getText("long_node_changed_submit"), "", 1);
                if (action == 2) {
                    return;
                }
                if (action == 0) {
                    this.submit();
                    return;
                }
            }
            this.cancel();
        }

        protected void confirmedCancel() {
            int action;
            if (this.isChanged() && (action = JOptionPane.showConfirmDialog(this, this.base.getText("long_node_changed_cancel"), "", 2)) == 2) {
                return;
            }
            this.cancel();
        }

        protected void submit() {
            this.setVisible(false);
        }

        protected void cancel() {
            this.setVisible(false);
        }

        protected void split() {
            this.setVisible(false);
        }

        protected abstract boolean isChanged();

        void setBase(EditNodeBase base) {
            this.base = base;
        }

        EditNodeBase getBase() {
            return this.base;
        }

        class CancelAction
        extends AbstractAction {
            CancelAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EditDialog.this.confirmedCancel();
            }
        }

        class SplitAction
        extends AbstractAction {
            SplitAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EditDialog.this.split();
            }
        }

        class SubmitAction
        extends AbstractAction {
            SubmitAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EditDialog.this.submit();
            }
        }

        class DialogWindowListener
        extends WindowAdapter {
            DialogWindowListener() {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (EditDialog.this.isVisible()) {
                    EditDialog.this.confirmedSubmit();
                }
            }
        }
    }
}

