/*
 * Decompiled with CFR 0.152.
 */
package plugins.latex;

import atp.sHotEqn;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import plugins.latex.LatexNodeHook;

public class JZoomedHotEqn
extends sHotEqn {
    private static double zoom = 1.0;
    static String editorTitle = null;
    private LatexNodeHook model;

    JZoomedHotEqn(LatexNodeHook model) {
        this.setDebug(false);
        this.setEditable(false);
        this.setBorder(true);
        this.model = model;
        this.setEquation(model.getContent());
        if (editorTitle == null) {
            editorTitle = model.getMindMapController().getText("plugins/latex/LatexNodeHook.editorTitle");
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.isValid() ? super.getPreferredSize() : this.getSizeof(this.getEquation());
        dimension.height = (int)((double)dimension.height * zoom);
        dimension.width = (int)((double)dimension.width * zoom);
        return dimension;
    }

    public void paint(Graphics g) {
        if (zoom != 1.0) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform transform = g2.getTransform();
            g2.scale(zoom, zoom);
            super.paint(g);
            g2.setTransform(transform);
        } else {
            super.paint(g);
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        if (zoom < 1.0) {
            super.setBounds(x, y, (int)((double)w / zoom), (int)((double)h / zoom));
        } else {
            super.setBounds(x, y, w, h);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            this.edit();
            e.consume();
            return;
        }
        super.mouseClicked(e);
    }

    private void edit() {
        JTextArea textArea = new JTextArea(this.getEquation());
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane editorScrollPane = new JScrollPane(textArea);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        editorScrollPane.setPreferredSize(new Dimension(500, 160));
        JDialog edit = new JDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), editorTitle, true);
        edit.getContentPane().add(editorScrollPane);
        edit.setDefaultCloseOperation(2);
        edit.pack();
        edit.setLocationRelativeTo((Component)((Object)this));
        edit.setVisible(true);
        String eq = textArea.getText();
        this.model.setContentUndoable(eq);
    }

    public void setModel(LatexNodeHook model) {
        this.model = model;
        this.setEquation(model.getContent());
        this.revalidate();
        this.repaint();
    }
}

