/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins.time;

import accessories.plugins.time.JCalendar;
import accessories.plugins.time.JDayChooser;
import accessories.plugins.time.JMonthChooser;
import accessories.plugins.time.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JTripleCalendar
extends JPanel
implements PropertyChangeListener {
    private JCalendar calendarWidget;
    private JLabel leftLabel;
    private JLabel rightLabel;
    private JInfoPanel leftPanel;
    private JInfoPanel rightPanel;

    public JTripleCalendar() {
        this.setName("JTripleCalendar");
        GridLayout gridLayout = new GridLayout(3, 1);
        gridLayout.setHgap(50);
        this.setLayout(gridLayout);
        this.leftPanel = this.createInfoPanel();
        this.rightPanel = this.createInfoPanel();
        this.add(this.leftPanel);
        this.calendarWidget = new JCalendar();
        this.calendarWidget.addPropertyChangeListener(this);
        this.add(this.calendarWidget);
        this.add(this.rightPanel);
    }

    private JInfoPanel createInfoPanel() {
        JInfoPanel panel = new JInfoPanel();
        return panel;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("JTripleCalendar");
        frame.setDefaultCloseOperation(2);
        JTripleCalendar jcalendar = new JTripleCalendar();
        frame.getContentPane().add(jcalendar);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Calendar gregorianCalendar = (Calendar)this.calendarWidget.getCalendar().clone();
        gregorianCalendar.add(2, -1);
        this.leftPanel.setDate(gregorianCalendar);
        gregorianCalendar.add(2, 2);
        this.rightPanel.setDate(gregorianCalendar);
    }

    public Calendar getCalendar() {
        return this.calendarWidget.getCalendar();
    }

    public Date getDate() {
        return this.calendarWidget.getDate();
    }

    public JDayChooser getDayChooser() {
        return this.calendarWidget.getDayChooser();
    }

    public void setDate(Date date) {
        this.calendarWidget.setDate(date);
    }

    public void setCalendar(Calendar c) {
        this.calendarWidget.setCalendar(c);
    }

    public JYearChooser getYearChooser() {
        return this.calendarWidget.getYearChooser();
    }

    private static class JInfoPanel
    extends JPanel {
        private JDayChooser dayChooser;
        private JMonthChooser monthChooser;
        private JYearChooser yearChooser;

        public JInfoPanel() {
            this.setLayout(new BorderLayout());
            JPanel monthYearPanel = new JPanel();
            monthYearPanel.setLayout(new BorderLayout());
            this.monthChooser = new JMonthChooser();
            this.monthChooser.setEnabled(false);
            this.yearChooser = new JYearChooser();
            this.yearChooser.setEnabled(false);
            monthYearPanel.add((Component)this.monthChooser, "West");
            monthYearPanel.add((Component)this.yearChooser, "Center");
            this.dayChooser = new JDayChooser(true){

                @Override
                protected void init() {
                    super.init();
                    this.selectedColor = this.oldDayBackgroundColor;
                }
            };
            this.dayChooser.setEnabled(false);
            this.add((Component)monthYearPanel, "North");
            this.add((Component)this.dayChooser, "Center");
        }

        public void setDate(Calendar calendar) {
            int year = calendar.get(1);
            int month = calendar.get(2);
            this.monthChooser.setMonth(month);
            this.yearChooser.setYear(year);
            this.dayChooser.setYear(year);
            this.dayChooser.setMonth(month);
            this.dayChooser.setEnabled(false);
        }
    }
}

