/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.event;

import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import java.io.Serializable;

public class EventDispatcher
implements INotificationSupport,
INotificationListener,
Serializable {
    private final Object owner;
    private EventType[] types = new EventType[4];
    private INotificationListener[] listeners = new INotificationListener[4];

    public EventDispatcher(Object pOwner) {
        this.owner = pOwner;
    }

    public synchronized void addNotificationListener(EventType type, INotificationListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener may not be null");
        }
        int length = this.listeners.length;
        int i = 0;
        while (i < length) {
            if (this.listeners[i] == null) break;
            ++i;
        }
        if (i >= length) {
            INotificationListener[] tempListeners = new INotificationListener[length + 4];
            System.arraycopy(this.listeners, 0, tempListeners, 0, length);
            this.listeners = tempListeners;
            EventType[] tempIds = new EventType[length + 4];
            System.arraycopy(this.types, 0, tempIds, 0, length);
            this.types = tempIds;
        }
        this.types[i] = type;
        this.listeners[i] = listener;
    }

    public synchronized void attach(INotificationSupport support) {
        int length = this.listeners.length;
        int i = 0;
        while (i < length) {
            EventType tempType = this.types[i];
            if (tempType != null) {
                support.addNotificationListener(tempType, this.listeners[i]);
            }
            ++i;
        }
    }

    public synchronized void clear() {
        this.types = new EventType[4];
        this.listeners = new INotificationListener[4];
    }

    public synchronized void detach(INotificationSupport support) {
        int length = this.listeners.length;
        int i = 0;
        while (i < length) {
            EventType tempType = this.types[i];
            if (tempType != null) {
                support.removeNotificationListener(tempType, this.listeners[i]);
            }
            ++i;
        }
    }

    public Object getOwner() {
        return this.owner;
    }

    public void handleEvent(Event event) {
        EventType typeId = event.getEventType();
        int length = this.listeners.length;
        int i = 0;
        while (i < length) {
            EventType id = this.types[i];
            if (id == typeId || id == EventType.ALWAYS) {
                this.listeners[i].handleEvent(event);
            }
            ++i;
        }
    }

    protected boolean hasListener(EventType type, INotificationListener listener) {
        int length = this.listeners.length;
        int i = 0;
        while (i < length) {
            if (this.types[i] == type && this.listeners[i] == listener) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized boolean isEmpty() {
        int i = 0;
        while (i < this.listeners.length) {
            if (this.listeners[i] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public synchronized void removeNotificationListener(EventType type, INotificationListener listener) {
        int length = this.listeners.length;
        int i = 0;
        while (i < length) {
            if (this.types[i] == type && this.listeners[i] == listener) {
                this.types[i] = null;
                this.listeners[i] = null;
                break;
            }
            ++i;
        }
    }

    public void triggerEvent(Event event) {
        this.handleEvent(event);
    }

    public void triggerEventReverse(Event event) {
        EventType typeId = event.getEventType();
        int i = this.listeners.length;
        while (i >= 0) {
            EventType id = this.types[i];
            if (id == typeId || id == EventType.ALWAYS) {
                this.listeners[i].handleEvent(event);
            }
            --i;
        }
    }
}

