/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.string.Converter;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgTools {
    private static int nesting = 0;
    public static final IFunctor toString = new IFunctor(){

        public Object perform(IFunctorCall call) throws FunctorInvocationException {
            Args args = (Args)call.getReceiver();
            StringBuilder sb = new StringBuilder();
            if (args.isNamed()) {
                for (String name : args.names()) {
                    sb.append(name);
                    sb.append(" = ");
                    sb.append(args.get(name));
                    sb.append("\n");
                }
            } else {
                int i = 0;
                while (i < args.size()) {
                    sb.append(i);
                    sb.append(" = ");
                    sb.append(args.get(i));
                    sb.append("\n");
                    ++i;
                }
            }
            return sb.toString();
        }
    };
    private static Set visited;

    protected static ILocator createLocator(Object optionValue, ILocator defaultValue, ILocatorFactory factory) {
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof ILocator) {
            return (ILocator)optionValue;
        }
        if (optionValue instanceof File) {
            try {
                return factory.createLocator(((File)optionValue).getAbsolutePath());
            }
            catch (IOException e) {
                return defaultValue;
            }
        }
        if (optionValue instanceof String) {
            if (StringTools.isEmpty((String)optionValue)) {
                return defaultValue;
            }
            try {
                return factory.createLocator((String)optionValue);
            }
            catch (IOException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static IArgs getArgs(IArgs args, String name, IArgs defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = args.get(name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof IArgs) {
            return (IArgs)optionValue;
        }
        if (optionValue instanceof String) {
            optionValue = Converter.asMap((String)optionValue);
        }
        if (optionValue instanceof Map) {
            return new Args((Map)optionValue);
        }
        if (optionValue instanceof List) {
            return new Args((List)optionValue);
        }
        return defaultValue;
    }

    public static boolean getBool(IArgs args, String name, boolean defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = args.get(name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Boolean) {
            return (Boolean)optionValue;
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            return Converter.asBoolean(optionString, defaultValue);
        }
        return defaultValue;
    }

    public static byte getByte(IArgs args, String name, byte defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object value = args.get(name);
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            try {
                return Byte.parseByte((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static char getChar(IArgs args, String name, char defaultValue) {
        String valueString;
        if (args == null) {
            return defaultValue;
        }
        Object value = args.get(name);
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof String && (valueString = (String)value).length() > 0) {
            return valueString.charAt(0);
        }
        return defaultValue;
    }

    public static char[] getCharArray(IArgs args, String name, char[] defaultValue) throws IllegalArgumentException {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = args.get(name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof char[]) {
            return (char[])optionValue;
        }
        if (optionValue instanceof String) {
            return ((String)optionValue).toCharArray();
        }
        throw new IllegalArgumentException("argument '" + name + "' must be of type string or char[]");
    }

    public static Class getClass(IArgs args, String name, Class defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = args.get(name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Class) {
            return (Class)optionValue;
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            try {
                return ClassTools.createClass(optionString, Object.class, null);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static Date getDate(IArgs args, String name, Date defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = args.get(name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Date) {
            return (Date)optionValue;
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            try {
                return DateFormat.getInstance().parse(optionString);
            }
            catch (ParseException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static <T extends EnumItem> T getEnumItem(IArgs args, EnumMeta<T> meta, String name) {
        if (args == null) {
            return meta.getDefault();
        }
        Object optionValue = args.get(name);
        if (optionValue == null) {
            return meta.getDefault();
        }
        if (optionValue instanceof EnumItem) {
            return (T)((EnumItem)optionValue);
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            return meta.getItemOrDefault(optionString);
        }
        return meta.getDefault();
    }

    public static <T extends EnumItem> T getEnumItem(IArgs args, EnumMeta<T> meta, String name, String defaultValue) {
        if (args == null) {
            return meta.getItemOrDefault(defaultValue);
        }
        Object optionValue = args.get(name);
        if (optionValue == null) {
            return meta.getItemOrDefault(defaultValue);
        }
        if (optionValue instanceof EnumItem) {
            return (T)((EnumItem)optionValue);
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            return meta.getItemOrDefault(optionString);
        }
        return meta.getItemOrDefault(defaultValue);
    }

    public static File getFile(IArgs args, String name, File defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object value = args.get(name);
        if (value instanceof File) {
            return (File)value;
        }
        if (value instanceof String) {
            return new File((String)value);
        }
        if (value instanceof FileLocator) {
            return ((FileLocator)value).getFile();
        }
        if (value instanceof ILocator) {
            return new File(((ILocator)value).getFullName());
        }
        return defaultValue;
    }

    public static float getFloat(IArgs args, String name, float defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object value = args.get(name);
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.indexOf("%") != -1) {
                try {
                    Number result = NumberFormat.getPercentInstance().parse(stringValue);
                    return result.floatValue();
                }
                catch (ParseException e) {
                    return defaultValue;
                }
            }
            try {
                return Float.parseFloat(stringValue);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static int getInt(IArgs args, String name, int defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object value = args.get(name);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static ILocator getLocator(IArgs args, String name, ILocator defaultValue, ILocatorFactory factory) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = args.get(name);
        return ArgTools.createLocator(optionValue, defaultValue, factory);
    }

    public static List<ILocator> getLocators(IArgs args, String name, ILocatorFactory factory) {
        if (args == null) {
            return null;
        }
        Object optionValue = args.get(name);
        if (optionValue == null) {
            return null;
        }
        ArrayList<ILocator> locators = new ArrayList<ILocator>();
        if (optionValue instanceof Collection) {
            for (Object candidate : (Collection)optionValue) {
                ILocator locator = ArgTools.createLocator(candidate, null, factory);
                if (locator == null) continue;
                locators.add(locator);
            }
        } else {
            ILocator locator = ArgTools.createLocator(optionValue, null, factory);
            if (locator != null) {
                locators.add(locator);
            }
        }
        return locators;
    }

    public static Map getMap(IArgs args, String name, Map defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = args.get(name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Map) {
            return (Map)optionValue;
        }
        if (optionValue instanceof String) {
            return Converter.asMap((String)optionValue);
        }
        return defaultValue;
    }

    public static Object getObject(IArgs args, String name, Object defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = args.get(name);
        if (optionValue == null) {
            return defaultValue;
        }
        return optionValue;
    }

    public static Point2D getPoint(IArgs args, String name, Point2D defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = args.get(name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Point2D) {
            return (Point2D)optionValue;
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            String[] coords = optionString.split("[x*@]");
            if (coords == null || coords.length != 2) {
                return defaultValue;
            }
            try {
                float x = Float.parseFloat(coords[0]);
                float y = Float.parseFloat(coords[1]);
                return new Point2D.Float(x, y);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static String getString(IArgs args, String name, String defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = args.get(name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof String) {
            return (String)optionValue;
        }
        if (optionValue instanceof char[]) {
            return new String((char[])optionValue);
        }
        return String.valueOf(optionValue);
    }

    public static String prefix(String prefix, String name) {
        if (name == null) {
            return null;
        }
        if (prefix == null || prefix.length() == 0) {
            return name;
        }
        return String.valueOf(prefix) + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static IArgs toArgs(Object value) {
        if (value instanceof IArgs) {
            return (IArgs)value;
        }
        if (value instanceof String) {
            value = Converter.asMap((String)value);
        }
        if (value instanceof Map) {
            return new Args((Map)value);
        }
        if (value instanceof List) {
            return new Args((List)value);
        }
        return Args.EMPTY;
    }

    public static List toList(IArgs args) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = args.size();
        while (i > 0) {
            result.add(args.get(--i));
        }
        return result;
    }

    public static Map toMap(IArgs args) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (args != null) {
            for (String name : args.names()) {
                result.put(name, args.get(name));
            }
        }
        return result;
    }

    public static synchronized String toString(IArgs args, String prefix) {
        if (visited == null) {
            visited = new HashSet();
            nesting = 0;
        }
        if (visited.contains(args)) {
            return "...recursive...";
        }
        if (nesting == 4) {
            return "...nested to deeply...";
        }
        visited.add(args);
        ++nesting;
        try {
            StringBuilder sb = new StringBuilder();
            if (args.isNamed()) {
                Object value;
                for (String name : args.names()) {
                    value = args.get(name);
                    if (value instanceof IArgs) continue;
                    ArgTools.toStringPlain(prefix, sb, name, value);
                }
                for (String name : args.names()) {
                    value = args.get(name);
                    if (!(value instanceof IArgs)) continue;
                    ArgTools.toStringArgs(prefix, sb, name, (IArgs)value);
                }
            } else {
                int i = 0;
                while (i < args.size()) {
                    Object value = args.get(i);
                    if (value instanceof IArgs) {
                        ArgTools.toStringArgs(prefix, sb, "" + i, (IArgs)value);
                    } else {
                        ArgTools.toStringPlain(prefix, sb, "" + i, value);
                    }
                    ++i;
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (--nesting == 0) {
                visited = null;
            }
        }
    }

    protected static void toStringArgs(String prefix, StringBuilder sb, String name, IArgs value) {
        int i = 1;
        while (i < nesting) {
            sb.append("   ");
            ++i;
        }
        sb.append(name);
        sb.append(" = ");
        sb.append("{");
        sb.append("\n");
        sb.append(ArgTools.toString(value, prefix));
        sb.append("\n");
        i = 1;
        while (i < nesting) {
            sb.append("   ");
            ++i;
        }
        sb.append("}");
        sb.append("\n");
    }

    protected static void toStringPlain(String prefix, StringBuilder sb, String name, Object value) {
        int i = 1;
        while (i < nesting) {
            sb.append("   ");
            ++i;
        }
        sb.append(name);
        sb.append(" = ");
        sb.append(StringTools.safeString(value));
        sb.append("\n");
    }
}

