/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.functor.IFunctorCallFactory;
import de.intarsys.tools.functor.INamedFunctor;
import de.intarsys.tools.reflect.IMethodHandler;
import de.intarsys.tools.reflect.MethodInvocationException;
import de.intarsys.tools.reflect.ObjectCreationException;

public class FunctorMethodHandler
implements IMethodHandler,
IAttributeSupport {
    private final IFunctor invoker;
    private final String name;

    public static IMethodHandler create(IFunctor functor) {
        if (functor instanceof IMethodHandler) {
            return (IMethodHandler)((Object)functor);
        }
        if (functor instanceof INamedFunctor) {
            return new FunctorMethodHandler(((INamedFunctor)functor).getId(), functor);
        }
        return new FunctorMethodHandler("unknown", functor);
    }

    public FunctorMethodHandler(String name, IFunctor invoker) {
        this.name = name;
        this.invoker = invoker;
    }

    public Object getAttribute(Object key) {
        if (this.invoker instanceof IAttributeSupport) {
            return ((IAttributeSupport)((Object)this.invoker)).getAttribute(key);
        }
        return null;
    }

    public IFunctor getInvoker() {
        return this.invoker;
    }

    public String getName() {
        return this.name;
    }

    public Object invoke(Object receiver, IArgs args) throws MethodInvocationException {
        IFunctorCall call;
        if (this.invoker == null) {
            return null;
        }
        if (receiver instanceof IFunctorCallFactory) {
            try {
                call = ((IFunctorCallFactory)receiver).createFunctorCall(this.invoker, receiver, args);
            }
            catch (ObjectCreationException e) {
                throw new MethodInvocationException(this.getName(), e);
            }
        } else {
            call = new FunctorCall(receiver, args);
        }
        try {
            return this.invoker.perform(call);
        }
        catch (FunctorInvocationException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            throw new MethodInvocationException(this.getName(), cause);
        }
    }

    public Object removeAttribute(Object key) {
        if (this.invoker instanceof IAttributeSupport) {
            return ((IAttributeSupport)((Object)this.invoker)).removeAttribute(key);
        }
        return null;
    }

    public Object setAttribute(Object key, Object value) {
        if (this.invoker instanceof IAttributeSupport) {
            return ((IAttributeSupport)((Object)this.invoker)).setAttribute(key, value);
        }
        return null;
    }
}

