/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JOptionPane;
import splmm.SciPloreUtils;

public class FreeMindStarter {
    static final String JAVA_VERSION = System.getProperty("java.version");
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$io$File;

    public static void main(String[] args) {
        FreeMindStarter starter = new FreeMindStarter();
        starter.checkJavaVersion();
        Properties defaultPreferences = starter.readDefaultPreferences();
        starter.createUserDirectory(defaultPreferences);
        Properties userPreferences = starter.readUsersPreferences(defaultPreferences);
        starter.setDefaultLocale(userPreferences);
        try {
            Class<?> mainClass = Class.forName("freemind.main.FreeMind");
            Method mainMethod = mainClass.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = FreeMindStarter.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$util$Properties == null ? (class$java$util$Properties = FreeMindStarter.class$("java.util.Properties")) : class$java$util$Properties, class$java$util$Properties == null ? (class$java$util$Properties = FreeMindStarter.class$("java.util.Properties")) : class$java$util$Properties, class$java$io$File == null ? (class$java$io$File = FreeMindStarter.class$("java.io.File")) : class$java$io$File);
            mainMethod.invoke(null, args, defaultPreferences, userPreferences, starter.getUserPreferencesFile(defaultPreferences));
        }
        catch (Exception e) {
            e.printStackTrace();
            String s = SciPloreUtils.getStackTraceAsString((Exception)e);
            JOptionPane.showMessageDialog(null, "freemind.main.FreeMind can't be started", "Startup problem", 0);
            System.exit(1);
        }
    }

    private void checkJavaVersion() {
        System.out.println("Checking Java Version...");
        if (JAVA_VERSION.compareTo("1.6.0") < 0) {
            String message = "Warning: SciPlore MindMapping requires version Java 1.6.0 or higher (your version: " + JAVA_VERSION + ", installed in " + System.getProperty("java.home") + ").";
            System.err.println(message);
            JOptionPane.showMessageDialog(null, message, "FreeMind", 2);
            System.exit(1);
        }
    }

    private void createUserDirectory(Properties pDefaultProperties) {
        File userPropertiesFolder = new File(this.getFreeMindDirectory(pDefaultProperties));
        try {
            if (!userPropertiesFolder.exists()) {
                userPropertiesFolder.mkdir();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Cannot create folder for user properties and logging: '" + userPropertiesFolder.getAbsolutePath() + "'");
        }
    }

    private void setDefaultLocale(Properties pProperties) {
        String lang = pProperties.getProperty("language");
        if (lang == null) {
            return;
        }
        Locale localeDef = null;
        switch (lang.length()) {
            case 2: {
                localeDef = new Locale(lang);
                break;
            }
            case 5: {
                localeDef = new Locale(lang.substring(0, 1), lang.substring(3, 4));
                break;
            }
            default: {
                return;
            }
        }
        Locale.setDefault(localeDef);
    }

    private Properties readUsersPreferences(Properties defaultPreferences) {
        Properties auto = null;
        auto = new Properties(defaultPreferences);
        try {
            FileInputStream in = null;
            File autoPropertiesFile = this.getUserPreferencesFile(defaultPreferences);
            in = new FileInputStream(autoPropertiesFile);
            auto.load(in);
            ((InputStream)in).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Panic! Error while loading default properties.");
        }
        return auto;
    }

    private File getUserPreferencesFile(Properties defaultPreferences) {
        if (defaultPreferences == null) {
            System.err.println("Panic! Error while loading default properties.");
            System.exit(1);
        }
        String freemindDirectory = this.getFreeMindDirectory(defaultPreferences);
        File userPropertiesFolder = new File(freemindDirectory);
        File autoPropertiesFile = new File(userPropertiesFolder, defaultPreferences.getProperty("autoproperties"));
        return autoPropertiesFile;
    }

    private String getFreeMindDirectory(Properties defaultPreferences) {
        return System.getProperty("user.home") + File.separator + defaultPreferences.getProperty("properties_folder");
    }

    public Properties readDefaultPreferences() {
        String propsLoc = "freemind.properties";
        URL defaultPropsURL = this.getClass().getClassLoader().getResource(propsLoc);
        Properties props = new Properties();
        try {
            InputStream in = defaultPropsURL.openStream();
            props.load(in);
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Panic! Error while loading default properties.");
        }
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

