/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Stoppable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class StreamPrinter
implements Runnable,
Stoppable {
    private InputStream stream;
    private PrintStream out;
    private Stoppable stop;
    private boolean stopped;
    private boolean flush;
    private Thread thread;

    public StreamPrinter(InputStream s, PrintStream p) {
        this.stream = s;
        this.out = p;
        this.thread = new Thread(this);
    }

    public void start() throws InterruptedException {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStop(Stoppable tostop) {
        StreamPrinter streamPrinter = this;
        synchronized (streamPrinter) {
            this.stop = tostop;
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlush(boolean flush) {
        StreamPrinter streamPrinter = this;
        synchronized (streamPrinter) {
            this.flush = flush;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Stoppable stoppable = this;
        synchronized (stoppable) {
            this.stopped = true;
        }
        if (this.stop != null) {
            stoppable = this.stop;
            synchronized (stoppable) {
                if (!this.stop.isStopped()) {
                    this.stop.stop();
                }
            }
        }
    }

    public void join() throws InterruptedException {
        this.thread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (!this.stopped) {
                boolean me;
                int buf = this.stream.read();
                if (buf == -1) return;
                Object object = this;
                synchronized (object) {
                    me = this.flush;
                }
                object = this.out;
                synchronized (object) {
                    this.out.print((char)buf);
                    if (me) {
                        this.out.flush();
                    }
                }
            }
            return;
        }
        catch (IOException e) {
            this.out.println("I/O error");
            return;
        }
        finally {
            PrintStream printStream = this.out;
            synchronized (printStream) {
                this.out.flush();
            }
            this.stop();
        }
    }
}

