/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.net.URLDownload;

public class UrlDragDrop
implements DropTargetListener {
    private static Logger logger = Logger.getLogger(UrlDragDrop.class.getName());
    private FieldEditor feditor;
    private EntryEditor editor;
    private JabRefFrame frame;

    public UrlDragDrop(EntryEditor _editor, JabRefFrame _frame, FieldEditor _feditor) {
        this.editor = _editor;
        this.feditor = _feditor;
        this.frame = _frame;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void drop(DropTargetDropEvent dtde) {
        Transferable tsf = dtde.getTransferable();
        dtde.acceptDrop(3);
        DataFlavor dtURL = null;
        try {
            dtURL = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "Class not found for DnD... should not happen", e);
        }
        try {
            URL url = (URL)tsf.getTransferData(dtURL);
            JOptionChoice res = (JOptionChoice)JOptionPane.showInputDialog(this.editor, "", Globals.lang("Select action"), 3, null, new JOptionChoice[]{new JOptionChoice(Globals.lang("Insert URL"), 0), new JOptionChoice(Globals.lang("Download file"), 1)}, new JOptionChoice(Globals.lang("Insert URL"), 0));
            switch (res.getId()) {
                case 0: {
                    this.feditor.setText(url.toString());
                    this.editor.updateField(this.feditor);
                    break;
                }
                case 1: {
                    try {
                        File file = new File(new File(Globals.prefs.get("pdfDirectory")), this.editor.getEntry().getField("bibtexkey") + ".pdf");
                        URLDownload udl = new URLDownload(this.editor, url, file);
                        this.frame.output(Globals.lang("Downloading..."));
                        udl.download();
                        this.frame.output(Globals.lang("Download completed"));
                        this.feditor.setText(file.toURI().toURL().toString());
                        this.editor.updateField(this.feditor);
                        break;
                    }
                    catch (IOException ioex) {
                        logger.log(Level.SEVERE, "Error while downloading file", ioex);
                        JOptionPane.showMessageDialog(this.editor, Globals.lang("File download"), Globals.lang("Error while downloading file:" + ioex.getMessage()), 0);
                    }
                }
            }
            return;
        }
        catch (UnsupportedFlavorException nfe) {
        }
        catch (IOException ioex) {
            logger.log(Level.WARNING, "!should not happen!", ioex);
        }
        try {
            List filelist = (List)tsf.getTransferData(DataFlavor.javaFileListFlavor);
            if (filelist.size() > 1) {
                JOptionPane.showMessageDialog(this.editor, Globals.lang("Only one item is supported"), Globals.lang("Drag and Drop Error"), 0);
                return;
            }
            File fl = (File)filelist.get(0);
            this.feditor.setText(fl.toURI().toURL().toString());
            this.editor.updateField(this.feditor);
        }
        catch (UnsupportedFlavorException nfe) {
            JOptionPane.showMessageDialog(this.editor, Globals.lang("Operation not supported"), Globals.lang("Drag and Drop Error"), 0);
            logger.log(Level.WARNING, "Transfer exception", nfe);
        }
        catch (IOException ioex) {
            logger.log(Level.WARNING, "Transfer exception", ioex);
        }
    }

    private static class JOptionChoice {
        private String label;
        private int id;

        public JOptionChoice(String _label, int _id) {
            this.label = _label;
            this.id = _id;
        }

        public String toString() {
            return this.label;
        }

        public int getId() {
            return this.id;
        }
    }
}

