/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertString;
import net.sf.jabref.undo.UndoableStringChange;

public class StringChange
extends Change {
    BibtexString string;
    String mem;
    String tmp;
    String disk;
    String label;
    InfoPane tp = new InfoPane();
    JScrollPane sp = new JScrollPane(this.tp);
    private BibtexString tmpString;

    public StringChange(BibtexString string, BibtexString tmpString, String label, String mem, String tmp, String disk) {
        this.tmpString = tmpString;
        this.name = Globals.lang("Modified string") + ": '" + label + "'";
        this.string = string;
        this.label = label;
        this.mem = mem;
        this.tmp = tmp;
        this.disk = disk;
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML><H2>");
        sb.append(Globals.lang("Modified string"));
        sb.append("</H2><H3>");
        sb.append(Globals.lang("Label")).append(":</H3>");
        sb.append(label);
        sb.append("<H3>");
        sb.append(Globals.lang("New content")).append(":</H3>");
        sb.append(disk);
        if (string != null) {
            sb.append("<H3>");
            sb.append(Globals.lang("Current content")).append(":</H3>");
            sb.append(string.getContent());
        } else {
            sb.append("<P><I>");
            sb.append(Globals.lang("Cannot merge this change")).append(": ");
            sb.append(Globals.lang("The string has been removed locally")).append("</I>");
        }
        sb.append("</HTML>");
        this.tp.setText(sb.toString());
    }

    public boolean makeChange(BasePanel panel, BibtexDatabase secondary, NamedCompound undoEdit) {
        if (this.string != null) {
            this.string.setContent(this.disk);
            undoEdit.addEdit(new UndoableStringChange(panel, this.string, false, this.mem, this.disk));
        } else {
            String newId = Util.createNeutralId();
            BibtexString bs = new BibtexString(newId, this.label, this.disk);
            try {
                panel.database().addString(bs);
                undoEdit.addEdit(new UndoableInsertString(panel, panel.database(), bs));
            }
            catch (KeyCollisionException ex) {
                Globals.logger("Error: could not add string '" + this.string.getName() + "': " + ex.getMessage());
            }
        }
        if (this.tmpString != null) {
            this.tmpString.setContent(this.disk);
        } else {
            BibtexString bs = new BibtexString(Util.createNeutralId(), this.label, this.disk);
            secondary.addString(bs);
        }
        return true;
    }

    JComponent description() {
        return this.sp;
    }
}

