/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.PushToApplication;

public class PushToLatexEditor
implements PushToApplication {
    private boolean couldNotCall = false;
    private boolean notDefined = false;
    private JPanel settings = null;
    private JTextField ledPath = new JTextField(30);
    private JTextField citeCommand = new JTextField(30);

    public String getName() {
        return Globals.menuTitle("Insert selected citations into LatexEditor");
    }

    public String getApplicationName() {
        return "LatexEditor";
    }

    public String getTooltip() {
        return Globals.lang("Push to LatexEditor");
    }

    public Icon getIcon() {
        return GUIGlobals.getImage("edit");
    }

    public String getKeyStrokeName() {
        return null;
    }

    public void pushEntries(BibtexDatabase database, BibtexEntry[] entries, String keyString, MetaData metaData) {
        this.couldNotCall = false;
        this.notDefined = false;
        String led = Globals.prefs.get("latexEditorPath");
        if (led == null || led.trim().length() == 0) {
            this.notDefined = true;
            return;
        }
        try {
            StringBuffer toSend = new StringBuffer("-i ").append(Globals.prefs.get("citeCommandLed")).append("{").append(keyString).append("}");
            Runtime.getRuntime().exec(led + " " + toSend.toString());
        }
        catch (IOException excep) {
            this.couldNotCall = true;
            excep.printStackTrace();
        }
    }

    public void operationCompleted(BasePanel panel) {
        if (this.notDefined) {
            panel.output(Globals.lang("Error") + ": " + Globals.lang("Path to %0 not defined", this.getApplicationName()) + ".");
        } else if (this.couldNotCall) {
            panel.output(Globals.lang("Error") + ": " + Globals.lang("Could not call executable") + " '" + Globals.prefs.get("latexEditorPath") + "'.");
        } else {
            Globals.lang("Pushed citations to %0", "LatexEditor");
        }
    }

    public boolean requiresBibtexKeys() {
        return true;
    }

    public JPanel getSettingsPanel() {
        if (this.settings == null) {
            this.initSettingsPanel();
        }
        this.ledPath.setText(Globals.prefs.get("latexEditorPath"));
        this.citeCommand.setText(Globals.prefs.get("citeCommandLed"));
        return this.settings;
    }

    private void initSettingsPanel() {
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref, 4dlu, fill:pref", ""));
        builder.append(new JLabel(Globals.lang("Path to LatexEditor (LEd.exe)") + ":"));
        builder.append(this.ledPath);
        BrowseAction action = new BrowseAction(null, this.ledPath, false);
        JButton browse = new JButton(Globals.lang("Browse"));
        browse.addActionListener(action);
        builder.append(browse);
        builder.nextLine();
        builder.append(Globals.lang("Cite command") + ":");
        builder.append(this.citeCommand);
        this.settings = builder.getPanel();
    }

    public void storeSettings() {
        Globals.prefs.put("latexEditorPath", this.ledPath.getText());
        Globals.prefs.put("citeCommandLed", this.citeCommand.getText());
    }
}

