/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import antlr.collections.AST;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FieldContentSelector;
import net.sf.jabref.FieldTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.ExplicitGroup;
import net.sf.jabref.groups.KeywordGroup;
import net.sf.jabref.groups.SearchGroup;
import net.sf.jabref.search.SearchExpressionParser;

class GroupDialog
extends JDialog {
    private static final int INDEX_EXPLICITGROUP = 0;
    private static final int INDEX_KEYWORDGROUP = 1;
    private static final int INDEX_SEARCHGROUP = 2;
    private static final int TEXTFIELD_LENGTH = 30;
    private JTextField m_name = new JTextField(30);
    private JRadioButton m_explicitRadioButton = new JRadioButton(Globals.lang("Statically group entries by manual assignment"));
    private JRadioButton m_keywordsRadioButton = new JRadioButton(Globals.lang("Dynamically group entries by searching a field for a keyword"));
    private JRadioButton m_searchRadioButton = new JRadioButton(Globals.lang("Dynamically group entries by a free-form search expression"));
    private JRadioButton m_independentButton = new JRadioButton(Globals.lang("Independent group: When selected, view only this group's entries"));
    private JRadioButton m_intersectionButton = new JRadioButton(Globals.lang("Refine supergroup: When selected, view entries contained in both this group and its supergroup"));
    private JRadioButton m_unionButton = new JRadioButton(Globals.lang("Include subgroups: When selected, view entries contained in this group or its subgroups"));
    private JTextField m_kgSearchField = new JTextField(30);
    private FieldTextField m_kgSearchTerm = new FieldTextField("keywords", "", false);
    private JCheckBox m_kgCaseSensitive = new JCheckBox(Globals.lang("Case sensitive"));
    private JCheckBox m_kgRegExp = new JCheckBox(Globals.lang("Regular Expression"));
    private JTextField m_sgSearchExpression = new JTextField(30);
    private JCheckBox m_sgCaseSensitive = new JCheckBox(Globals.lang("Case sensitive"));
    private JCheckBox m_sgRegExp = new JCheckBox(Globals.lang("Regular Expression"));
    private JButton m_ok = new JButton(Globals.lang("Ok"));
    private JButton m_cancel = new JButton(Globals.lang("Cancel"));
    private JPanel m_optionsPanel = new JPanel();
    private JLabel m_description = new JLabel(){

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = 1;
            return d;
        }
    };
    private boolean m_okPressed = false;
    private final JabRefFrame m_parent;
    private final BasePanel m_basePanel;
    private AbstractGroup m_resultingGroup;
    private AbstractUndoableEdit m_undoAddPreviousEntires = null;
    private final AbstractGroup m_editedGroup;
    private CardLayout m_optionsLayout = new CardLayout();

    public GroupDialog(JabRefFrame jabrefFrame, BasePanel basePanel, AbstractGroup editedGroup) {
        super(jabrefFrame, Globals.lang("Edit group"), true);
        this.m_basePanel = basePanel;
        this.m_parent = jabrefFrame;
        this.m_editedGroup = editedGroup;
        this.m_kgSearchField.setText(jabrefFrame.prefs().get("groupsDefaultField"));
        ButtonGroup groupType = new ButtonGroup();
        groupType.add(this.m_explicitRadioButton);
        groupType.add(this.m_keywordsRadioButton);
        groupType.add(this.m_searchRadioButton);
        ButtonGroup groupHierarchy = new ButtonGroup();
        groupHierarchy.add(this.m_independentButton);
        groupHierarchy.add(this.m_intersectionButton);
        groupHierarchy.add(this.m_unionButton);
        this.m_description.setVerticalAlignment(1);
        this.getRootPane().setDefaultButton(this.m_ok);
        this.m_optionsPanel.setLayout(this.m_optionsLayout);
        this.m_optionsPanel.add((Component)new JPanel(), "0");
        FormLayout layoutKG = new FormLayout("right:pref, 4dlu, fill:1dlu:grow, 2dlu, left:pref");
        DefaultFormBuilder builderKG = new DefaultFormBuilder(layoutKG);
        builderKG.append(Globals.lang("Field"));
        builderKG.append((Component)this.m_kgSearchField, 3);
        builderKG.nextLine();
        builderKG.append(Globals.lang("Keyword"));
        builderKG.append(this.m_kgSearchTerm);
        builderKG.append(new FieldContentSelector(this.m_parent, this.m_basePanel, this, this.m_kgSearchTerm, this.m_basePanel.metaData(), null, true, ", "));
        builderKG.nextLine();
        builderKG.append((Component)this.m_kgCaseSensitive, 3);
        builderKG.nextLine();
        builderKG.append((Component)this.m_kgRegExp, 3);
        this.m_optionsPanel.add((Component)builderKG.getPanel(), "1");
        FormLayout layoutSG = new FormLayout("right:pref, 4dlu, fill:1dlu:grow");
        DefaultFormBuilder builderSG = new DefaultFormBuilder(layoutSG);
        builderSG.append(Globals.lang("Search expression"));
        builderSG.append(this.m_sgSearchExpression);
        builderSG.nextLine();
        builderSG.append((Component)this.m_sgCaseSensitive, 3);
        builderSG.nextLine();
        builderSG.append((Component)this.m_sgRegExp, 3);
        this.m_optionsPanel.add((Component)builderSG.getPanel(), "2");
        FormLayout layoutBP = new FormLayout("pref, 4dlu, pref", "p");
        layoutBP.setColumnGroups(new int[][]{{1, 3}});
        ButtonBarBuilder builderBP = new ButtonBarBuilder();
        builderBP.addGlue();
        builderBP.addGridded(this.m_ok);
        builderBP.addGridded(this.m_cancel);
        builderBP.addGlue();
        builderBP.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        FormLayout layoutAll = new FormLayout("right:pref, 4dlu, fill:600px, 4dlu, fill:pref", "p, 3dlu, p, 3dlu, p, 0dlu, p, 0dlu, p, 3dlu, p, 3dlu, p, 0dlu, p, 0dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, top:80dlu, 9dlu, p, 9dlu, p");
        DefaultFormBuilder builderAll = new DefaultFormBuilder(layoutAll);
        builderAll.setDefaultDialogBorder();
        builderAll.appendSeparator(Globals.lang("General"));
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append(Globals.lang("Name"));
        builderAll.append(this.m_name);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.m_explicitRadioButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.m_keywordsRadioButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.m_searchRadioButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.appendSeparator(Globals.lang("Hierarchical context"));
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.m_independentButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.m_intersectionButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.m_unionButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.appendSeparator(Globals.lang("Options"));
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.m_optionsPanel, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.appendSeparator(Globals.lang("Description"));
        builderAll.nextLine();
        builderAll.nextLine();
        JScrollPane sp = new JScrollPane(this.m_description, 20, 30){

            public Dimension getPreferredSize() {
                return this.getMaximumSize();
            }
        };
        builderAll.append((Component)sp, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.appendSeparator();
        builderAll.nextLine();
        builderAll.nextLine();
        Container cp = this.getContentPane();
        cp.add((Component)builderAll.getPanel(), "Center");
        cp.add((Component)builderBP.getPanel(), "South");
        this.pack();
        this.setResizable(false);
        this.updateComponents();
        this.setLayoutForSelectedGroup();
        Util.placeDialog(this, this.m_parent);
        ItemListener radioButtonItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                GroupDialog.this.setLayoutForSelectedGroup();
                GroupDialog.this.updateComponents();
            }
        };
        this.m_explicitRadioButton.addItemListener(radioButtonItemListener);
        this.m_keywordsRadioButton.addItemListener(radioButtonItemListener);
        this.m_searchRadioButton.addItemListener(radioButtonItemListener);
        this.m_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GroupDialog.this.dispose();
            }
        });
        this.m_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GroupDialog.this.m_okPressed = true;
                if (GroupDialog.this.m_explicitRadioButton.isSelected()) {
                    if (GroupDialog.this.m_editedGroup instanceof ExplicitGroup) {
                        GroupDialog.this.m_resultingGroup = GroupDialog.this.m_editedGroup.deepCopy();
                        GroupDialog.this.m_resultingGroup.setName(GroupDialog.this.m_name.getText().trim());
                        GroupDialog.this.m_resultingGroup.setHierarchicalContext(GroupDialog.this.getContext());
                    } else {
                        GroupDialog.this.m_resultingGroup = new ExplicitGroup(GroupDialog.this.m_name.getText().trim(), GroupDialog.this.getContext());
                        if (GroupDialog.this.m_editedGroup != null) {
                            GroupDialog.this.addPreviousEntries();
                        }
                    }
                } else if (GroupDialog.this.m_keywordsRadioButton.isSelected()) {
                    GroupDialog.this.m_resultingGroup = new KeywordGroup(GroupDialog.this.m_name.getText().trim(), GroupDialog.this.m_kgSearchField.getText().trim(), GroupDialog.this.m_kgSearchTerm.getText().trim(), GroupDialog.this.m_kgCaseSensitive.isSelected(), GroupDialog.this.m_kgRegExp.isSelected(), GroupDialog.this.getContext());
                    if ((GroupDialog.this.m_editedGroup instanceof ExplicitGroup || GroupDialog.this.m_editedGroup instanceof SearchGroup) && GroupDialog.this.m_resultingGroup.supportsAdd()) {
                        GroupDialog.this.addPreviousEntries();
                    }
                } else if (GroupDialog.this.m_searchRadioButton.isSelected()) {
                    try {
                        GroupDialog.this.m_resultingGroup = new SearchGroup(GroupDialog.this.m_name.getText().trim(), GroupDialog.this.m_sgSearchExpression.getText().trim(), GroupDialog.this.m_sgCaseSensitive.isSelected(), GroupDialog.this.m_sgRegExp.isSelected(), GroupDialog.this.getContext());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                GroupDialog.this.dispose();
            }
        });
        CaretListener caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                GroupDialog.this.updateComponents();
            }
        };
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                GroupDialog.this.updateComponents();
            }
        };
        this.m_name.addCaretListener(caretListener);
        this.m_kgSearchField.addCaretListener(caretListener);
        this.m_kgSearchTerm.addCaretListener(caretListener);
        this.m_kgCaseSensitive.addItemListener(itemListener);
        this.m_kgRegExp.addItemListener(itemListener);
        this.m_sgSearchExpression.addCaretListener(caretListener);
        this.m_sgRegExp.addItemListener(itemListener);
        this.m_sgCaseSensitive.addItemListener(itemListener);
        if (editedGroup instanceof KeywordGroup) {
            KeywordGroup group = (KeywordGroup)editedGroup;
            this.m_name.setText(group.getName());
            this.m_kgSearchField.setText(group.getSearchField());
            this.m_kgSearchTerm.setText(group.getSearchExpression());
            this.m_kgCaseSensitive.setSelected(group.isCaseSensitive());
            this.m_kgRegExp.setSelected(group.isRegExp());
            this.m_keywordsRadioButton.setSelected(true);
            this.setContext(editedGroup.getHierarchicalContext());
        } else if (editedGroup instanceof SearchGroup) {
            SearchGroup group = (SearchGroup)editedGroup;
            this.m_name.setText(group.getName());
            this.m_sgSearchExpression.setText(group.getSearchExpression());
            this.m_sgCaseSensitive.setSelected(group.isCaseSensitive());
            this.m_sgRegExp.setSelected(group.isRegExp());
            this.m_searchRadioButton.setSelected(true);
            this.setContext(editedGroup.getHierarchicalContext());
        } else if (editedGroup instanceof ExplicitGroup) {
            this.m_name.setText(editedGroup.getName());
            this.m_explicitRadioButton.setSelected(true);
            this.setContext(editedGroup.getHierarchicalContext());
        } else {
            this.m_explicitRadioButton.setSelected(true);
            this.setContext(0);
        }
    }

    public boolean okPressed() {
        return this.m_okPressed;
    }

    public AbstractGroup getResultingGroup() {
        return this.m_resultingGroup;
    }

    private void setLayoutForSelectedGroup() {
        if (this.m_explicitRadioButton.isSelected()) {
            this.m_optionsLayout.show(this.m_optionsPanel, String.valueOf(0));
        } else if (this.m_keywordsRadioButton.isSelected()) {
            this.m_optionsLayout.show(this.m_optionsPanel, String.valueOf(1));
        } else if (this.m_searchRadioButton.isSelected()) {
            this.m_optionsLayout.show(this.m_optionsPanel, String.valueOf(2));
        }
    }

    private void updateComponents() {
        boolean okEnabled;
        boolean bl = okEnabled = this.m_name.getText().trim().length() > 0;
        if (!okEnabled) {
            this.setDescription(Globals.lang("Please enter a name for the group."));
            this.m_ok.setEnabled(false);
            return;
        }
        if (this.m_keywordsRadioButton.isSelected()) {
            String s1 = this.m_kgSearchField.getText().trim();
            okEnabled = okEnabled && s1.matches("\\w+");
            String s2 = this.m_kgSearchTerm.getText().trim();
            boolean bl2 = okEnabled = okEnabled && s2.length() > 0;
            if (!okEnabled) {
                this.setDescription(Globals.lang("Please enter the field to search (e.g. <b>keywords</b>) and the keyword to search it for (e.g. <b>electrical</b>)."));
            } else if (this.m_kgRegExp.isSelected()) {
                try {
                    Pattern.compile(s2);
                    this.setDescription(KeywordGroup.getDescriptionForPreview(s1, s2, this.m_kgCaseSensitive.isSelected(), this.m_kgRegExp.isSelected()));
                }
                catch (Exception e) {
                    okEnabled = false;
                    this.setDescription(this.formatRegExException(s2, e));
                }
            } else {
                this.setDescription(KeywordGroup.getDescriptionForPreview(s1, s2, this.m_kgCaseSensitive.isSelected(), this.m_kgRegExp.isSelected()));
            }
            this.setNameFontItalic(true);
        } else if (this.m_searchRadioButton.isSelected()) {
            String s1 = this.m_sgSearchExpression.getText().trim();
            if (!(okEnabled &= s1.length() > 0)) {
                this.setDescription(Globals.lang("Please enter a search term. For example, to search all fields for <b>Smith</b>, enter%c<p><tt>smith</tt><p>To search the field <b>Author</b> for <b>Smith</b> and the field <b>Title</b> for <b>electrical</b>, enter%c<p><tt>author%esmith and title%eelectrical</tt>"));
            } else {
                AST ast = SearchExpressionParser.checkSyntax(s1, this.m_sgCaseSensitive.isSelected(), this.m_sgRegExp.isSelected());
                this.setDescription(SearchGroup.getDescriptionForPreview(s1, ast, this.m_sgCaseSensitive.isSelected(), this.m_sgRegExp.isSelected()));
                if (this.m_sgRegExp.isSelected()) {
                    try {
                        Pattern.compile(s1);
                    }
                    catch (Exception e) {
                        okEnabled = false;
                        this.setDescription(this.formatRegExException(s1, e));
                    }
                }
            }
            this.setNameFontItalic(true);
        } else if (this.m_explicitRadioButton.isSelected()) {
            this.setDescription(ExplicitGroup.getDescriptionForPreview());
            this.setNameFontItalic(false);
        }
        this.m_ok.setEnabled(okEnabled);
    }

    private void addPreviousEntries() {
        int i = JOptionPane.showConfirmDialog(this.m_basePanel.frame(), Globals.lang("Assign the original group's entries to this group?"), Globals.lang("Change of Grouping Method"), 0, 3);
        if (i == 1) {
            return;
        }
        Vector<BibtexEntry> vec = new Vector<BibtexEntry>();
        for (BibtexEntry entry : this.m_basePanel.database().getEntries()) {
            if (!this.m_editedGroup.contains(entry)) continue;
            vec.add(entry);
        }
        if (vec.size() > 0) {
            BibtexEntry[] entries = new BibtexEntry[vec.size()];
            vec.toArray(entries);
            if (!Util.warnAssignmentSideEffects(new AbstractGroup[]{this.m_resultingGroup}, entries, this.m_basePanel.getDatabase(), this)) {
                return;
            }
            if (!(this.m_resultingGroup instanceof ExplicitGroup)) {
                this.m_undoAddPreviousEntires = this.m_resultingGroup.add(entries);
            }
        }
    }

    protected void setDescription(String description) {
        this.m_description.setText("<html>" + description + "</html>");
    }

    protected String formatRegExException(String regExp, Exception e) {
        String[] sa = e.getMessage().split("\\n");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < sa.length; ++i) {
            if (i > 0) {
                sb.append("<br>");
            }
            sb.append(Util.quoteForHTML(sa[i]));
        }
        String s = Globals.lang("The regular expression <b>%0</b> is invalid%c", Util.quoteForHTML(regExp)) + "<p><tt>" + sb.toString() + "</tt>";
        if (!(e instanceof PatternSyntaxException)) {
            return s;
        }
        int lastNewline = s.lastIndexOf("<br>");
        int hat = s.lastIndexOf("^");
        if (lastNewline >= 0 && hat >= 0 && hat > lastNewline) {
            return s.substring(0, lastNewline + 4) + s.substring(lastNewline + 4).replaceAll(" ", "&nbsp;");
        }
        return s;
    }

    public AbstractUndoableEdit getUndoForAddPreviousEntries() {
        return this.m_undoAddPreviousEntires;
    }

    protected void setNameFontItalic(boolean italic) {
        Font f = this.m_name.getFont();
        if (f.isItalic() != italic) {
            f = f.deriveFont(italic ? 2 : 0);
            this.m_name.setFont(f);
        }
    }

    protected int getContext() {
        if (this.m_independentButton.isSelected()) {
            return 0;
        }
        if (this.m_intersectionButton.isSelected()) {
            return 1;
        }
        if (this.m_unionButton.isSelected()) {
            return 2;
        }
        return 0;
    }

    protected void setContext(int context) {
        switch (context) {
            case 1: {
                this.m_intersectionButton.setSelected(true);
                return;
            }
            case 2: {
                this.m_unionButton.setSelected(true);
                return;
            }
        }
        this.m_independentButton.setSelected(true);
    }
}

