/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.AllEntriesGroup;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeNode;

class UndoableResetGroups
extends AbstractUndoableEdit {
    private final GroupTreeNode m_groupsBackup;
    private final GroupTreeNode m_groupsRootHandle;
    private final GroupSelector m_groupSelector;
    private boolean m_revalidate = true;

    public UndoableResetGroups(GroupSelector groupSelector, GroupTreeNode groupsRoot) {
        this.m_groupsBackup = groupsRoot.deepCopy();
        this.m_groupsRootHandle = groupsRoot;
        this.m_groupSelector = groupSelector;
    }

    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("clear all groups");
    }

    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("clear all groups");
    }

    public void undo() {
        super.undo();
        this.m_groupsRootHandle.removeAllChildren();
        this.m_groupsRootHandle.setGroup(this.m_groupsBackup.getGroup().deepCopy());
        for (int i = 0; i < this.m_groupsBackup.getChildCount(); ++i) {
            this.m_groupsRootHandle.add(((GroupTreeNode)this.m_groupsBackup.getChildAt(i)).deepCopy());
        }
        if (this.m_revalidate) {
            this.m_groupSelector.revalidateGroups();
        }
    }

    public void redo() {
        super.redo();
        this.m_groupsRootHandle.removeAllChildren();
        this.m_groupsRootHandle.setGroup(new AllEntriesGroup());
        if (this.m_revalidate) {
            this.m_groupSelector.revalidateGroups();
        }
    }

    public void setRevalidate(boolean revalidate) {
        this.m_revalidate = revalidate;
    }
}

