/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.UndoableEditListener;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldNameLabel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.external.DownloadExternalFile;
import net.sf.jabref.external.DroppedFileHandler;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.MoveFileAction;
import net.sf.jabref.external.RegExpFileSearch;
import net.sf.jabref.external.UnknownExternalFileType;
import net.sf.jabref.groups.EntryTableTransferHandler;
import net.sf.jabref.gui.AutoCompleteListener;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListEntryEditor;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileListEditor
extends JTable
implements FieldEditor,
DownloadExternalFile.DownloadCallback {
    FieldNameLabel label;
    FileListEntryEditor editor = null;
    private JabRefFrame frame;
    private MetaData metaData;
    private String fieldName;
    private EntryEditor entryEditor;
    private JPanel panel;
    private FileListTableModel tableModel;
    private JScrollPane sPane;
    private JButton add;
    private JButton remove;
    private JButton up;
    private JButton down;
    private JButton auto;
    private JButton download;
    private JPopupMenu menu = new JPopupMenu();
    private JMenuItem openLink = new JMenuItem(Globals.lang("Open"));
    private JMenuItem rename = new JMenuItem(Globals.lang("Move/rename file"));
    private JMenuItem moveToFileDir = new JMenuItem(Globals.lang("Move to file directory"));

    public FileListEditor(JabRefFrame frame, MetaData metaData, String fieldName, String content, EntryEditor entryEditor) {
        this.frame = frame;
        this.metaData = metaData;
        this.fieldName = fieldName;
        this.entryEditor = entryEditor;
        this.label = new FieldNameLabel(" " + Util.nCase(fieldName) + " ");
        this.tableModel = new FileListTableModel();
        this.setText(content);
        this.setModel(this.tableModel);
        this.sPane = new JScrollPane(this);
        this.setTableHeader(null);
        this.addMouseListener(new TableClickListener());
        this.add = new JButton(GUIGlobals.getImage("add"));
        this.add.setToolTipText(Globals.lang("New file link (INSERT)"));
        this.remove = new JButton(GUIGlobals.getImage("remove"));
        this.remove.setToolTipText(Globals.lang("Remove file link (DELETE)"));
        this.up = new JButton(GUIGlobals.getImage("up"));
        this.down = new JButton(GUIGlobals.getImage("down"));
        this.auto = new JButton(Globals.lang("Auto"));
        this.download = new JButton(Globals.lang("Download"));
        this.add.setMargin(new Insets(0, 0, 0, 0));
        this.remove.setMargin(new Insets(0, 0, 0, 0));
        this.up.setMargin(new Insets(0, 0, 0, 0));
        this.down.setMargin(new Insets(0, 0, 0, 0));
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileListEditor.this.addEntry();
            }
        });
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileListEditor.this.removeEntries();
            }
        });
        this.up.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileListEditor.this.moveEntry(-1);
            }
        });
        this.down.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileListEditor.this.moveEntry(1);
            }
        });
        this.auto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileListEditor.this.autoSetLinks();
            }
        });
        this.download.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileListEditor.this.downloadFile();
            }
        });
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("fill:pref,1dlu,fill:pref,1dlu,fill:pref", "fill:pref,fill:pref"));
        builder.append(this.up);
        builder.append(this.add);
        builder.append(this.auto);
        builder.append(this.down);
        builder.append(this.remove);
        builder.append(this.download);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.sPane, "Center");
        this.panel.add((Component)builder.getPanel(), "East");
        FileListEditorTransferHandler th = new FileListEditorTransferHandler();
        this.setTransferHandler(th);
        this.panel.setTransferHandler(th);
        this.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
        this.getActionMap().put("delete", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int row = FileListEditor.this.getSelectedRow();
                FileListEditor.this.removeEntries();
                row = Math.min(row, FileListEditor.this.getRowCount() - 1);
                if (row >= 0) {
                    FileListEditor.this.setRowSelectionInterval(row, row);
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("INSERT"), "insert");
        this.getActionMap().put("insert", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.addEntry();
            }
        });
        this.menu.add(this.openLink);
        this.openLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.openSelectedFile();
            }
        });
        this.menu.add(this.rename);
        this.rename.addActionListener(new MoveFileAction(frame, entryEditor, this, false));
        this.menu.add(this.moveToFileDir);
        this.moveToFileDir.addActionListener(new MoveFileAction(frame, entryEditor, this, true));
    }

    private void openSelectedFile() {
        int row = this.getSelectedRow();
        if (row >= 0) {
            FileListEntry entry = this.tableModel.getEntry(row);
            try {
                ExternalFileType type = Globals.prefs.getExternalFileTypeByName(entry.getType().getName());
                Util.openExternalFileAnyFormat(this.metaData, entry.getLink(), type != null ? type : entry.getType());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public FileListTableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public JComponent getPane() {
        return this.panel;
    }

    @Override
    public JComponent getTextComponent() {
        return this;
    }

    @Override
    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public void setLabelColor(Color c) {
        this.label.setForeground(c);
    }

    @Override
    public String getText() {
        return this.tableModel.getStringRepresentation();
    }

    @Override
    public void setText(String newText) {
        this.tableModel.setContent(newText);
    }

    @Override
    public void append(String text) {
    }

    @Override
    public void updateFont() {
    }

    @Override
    public void paste(String textToInsert) {
    }

    @Override
    public String getSelectedText() {
        return null;
    }

    private void addEntry(String initialLink) {
        FileListEntry entry;
        int row = this.getSelectedRow();
        if (row == -1) {
            row = 0;
        }
        if (this.editListEntry(entry = new FileListEntry("", initialLink, null), true)) {
            this.tableModel.addEntry(row, entry);
        }
        this.entryEditor.updateField(this);
    }

    private void addEntry() {
        this.addEntry("");
    }

    private void removeEntries() {
        int[] rows = this.getSelectedRows();
        if (rows != null) {
            for (int i = rows.length - 1; i >= 0; --i) {
                this.tableModel.removeEntry(rows[i]);
            }
        }
        this.entryEditor.updateField(this);
    }

    private void moveEntry(int i) {
        int[] sel = this.getSelectedRows();
        if (sel.length != 1 || this.tableModel.getRowCount() < 2) {
            return;
        }
        int toIdx = sel[0] + i;
        if (toIdx >= this.tableModel.getRowCount()) {
            toIdx -= this.tableModel.getRowCount();
        }
        if (toIdx < 0) {
            toIdx += this.tableModel.getRowCount();
        }
        FileListEntry entry = this.tableModel.getEntry(sel[0]);
        this.tableModel.removeEntry(sel[0]);
        this.tableModel.addEntry(toIdx, entry);
        this.entryEditor.updateField(this);
        this.setRowSelectionInterval(toIdx, toIdx);
    }

    private boolean editListEntry(FileListEntry entry, boolean openBrowse) {
        if (this.editor == null) {
            this.editor = new FileListEntryEditor(this.frame, entry, false, true, this.metaData);
        } else {
            this.editor.setEntry(entry);
        }
        this.editor.setVisible(true, openBrowse);
        if (this.editor.okPressed()) {
            this.tableModel.fireTableDataChanged();
        }
        this.entryEditor.updateField(this);
        return this.editor.okPressed();
    }

    private void autoSetLinks() {
        this.auto.setEnabled(false);
        BibtexEntry entry = this.entryEditor.getEntry();
        JDialog diag = new JDialog((Frame)this.frame, true);
        FileListEditor.autoSetLinks(entry, this.tableModel, this.metaData, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileListEditor.this.auto.setEnabled(true);
                if (e.getID() > 0) {
                    FileListEditor.this.entryEditor.updateField(FileListEditor.this);
                    FileListEditor.this.frame.output(Globals.lang("Finished autosetting external links."));
                } else {
                    FileListEditor.this.frame.output(Globals.lang("Finished autosetting external links.") + " " + Globals.lang("No files found."));
                }
            }
        }, diag);
    }

    public static Thread autoSetLinks(final Collection<BibtexEntry> entries, final NamedCompound ce, final Set<BibtexEntry> changedEntries, final ArrayList<File> dirs) {
        Runnable r = new Runnable(){

            public void run() {
                Map<BibtexEntry, List<File>> result;
                ExternalFileType[] types = Globals.prefs.getExternalFileTypeSelection();
                ArrayList<String> extensions = new ArrayList<String>();
                for (int i = 0; i < types.length; ++i) {
                    ExternalFileType type = types[i];
                    extensions.add(type.getExtension());
                }
                if (Globals.prefs.getBoolean("useRegExpSearch")) {
                    String regExp = Globals.prefs.get("regExpSearchExpression");
                    result = RegExpFileSearch.findFilesForSet(entries, extensions, dirs, regExp);
                } else {
                    result = Util.findAssociatedFiles(entries, extensions, dirs);
                }
                for (BibtexEntry anEntry : result.keySet()) {
                    FileListTableModel tableModel = new FileListTableModel();
                    String oldVal = anEntry.getField("file");
                    if (oldVal != null) {
                        tableModel.setContent(oldVal);
                    }
                    List<File> files = result.get(anEntry);
                    for (File f : files) {
                        f = FileListEditor.relativizePath(f, dirs);
                        boolean alreadyHas = false;
                        for (int j = 0; j < tableModel.getRowCount(); ++j) {
                            FileListEntry existingEntry = tableModel.getEntry(j);
                            if (!new File(existingEntry.getLink()).equals(f)) continue;
                            alreadyHas = true;
                            break;
                        }
                        if (alreadyHas) continue;
                        int index = f.getPath().lastIndexOf(46);
                        if (index >= 0 && index < f.getPath().length() - 1) {
                            ExternalFileType type = Globals.prefs.getExternalFileTypeByExt(f.getPath().substring(index + 1).toLowerCase());
                            FileListEntry flEntry = new FileListEntry(f.getName(), f.getPath(), type);
                            tableModel.addEntry(tableModel.getRowCount(), flEntry);
                        } else {
                            FileListEntry flEntry = new FileListEntry(f.getName(), f.getPath(), new UnknownExternalFileType(""));
                            tableModel.addEntry(tableModel.getRowCount(), flEntry);
                        }
                        String newVal = tableModel.getStringRepresentation();
                        if (newVal.length() == 0) {
                            newVal = null;
                        }
                        UndoableFieldChange change = new UndoableFieldChange(anEntry, "file", oldVal, newVal);
                        ce.addEdit(change);
                        anEntry.setField("file", newVal);
                        changedEntries.add(anEntry);
                    }
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
        return t;
    }

    public static Thread autoSetLinks(BibtexEntry entry, final FileListTableModel tableModel, final MetaData metaData, final ActionListener callback, final JDialog diag) {
        final ArrayList<BibtexEntry> entries = new ArrayList<BibtexEntry>();
        entries.add(entry);
        ExternalFileType[] types = Globals.prefs.getExternalFileTypeSelection();
        JProgressBar prog = new JProgressBar(0, types.length - 1);
        prog.setIndeterminate(true);
        prog.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel label = new JLabel(Globals.lang("Searching for files"));
        if (diag != null) {
            diag.setTitle(Globals.lang("Autosetting links"));
            diag.getContentPane().add((Component)prog, "Center");
            diag.getContentPane().add((Component)label, "South");
            diag.pack();
            diag.setLocationRelativeTo(diag.getParent());
        }
        Runnable r = new Runnable(){

            public void run() {
                Map<BibtexEntry, List<File>> result;
                boolean foundAny = false;
                ExternalFileType[] types = Globals.prefs.getExternalFileTypeSelection();
                ArrayList<File> dirs = new ArrayList<File>();
                if (metaData.getFileDirectory("file") != null) {
                    dirs.add(new File(metaData.getFileDirectory("file")));
                }
                ArrayList<String> extensions = new ArrayList<String>();
                for (int i = 0; i < types.length; ++i) {
                    ExternalFileType type = types[i];
                    extensions.add(type.getExtension());
                }
                if (Globals.prefs.getBoolean("useRegExpSearch")) {
                    String regExp = Globals.prefs.get("regExpSearchExpression");
                    result = RegExpFileSearch.findFilesForSet(entries, extensions, dirs, regExp);
                } else {
                    result = Util.findAssociatedFiles(entries, extensions, dirs);
                }
                for (BibtexEntry anEntry : result.keySet()) {
                    List<File> files = result.get(anEntry);
                    for (File f : files) {
                        f = FileListEditor.relativizePath(f, dirs);
                        boolean alreadyHas = false;
                        for (int j = 0; j < tableModel.getRowCount(); ++j) {
                            FileListEntry existingEntry = tableModel.getEntry(j);
                            if (!new File(existingEntry.getLink()).equals(f)) continue;
                            alreadyHas = true;
                            break;
                        }
                        if (alreadyHas) continue;
                        int index = f.getPath().lastIndexOf(46);
                        if (index >= 0 && index < f.getPath().length() - 1) {
                            ExternalFileType type = Globals.prefs.getExternalFileTypeByExt(f.getPath().substring(index + 1));
                            FileListEntry flEntry = new FileListEntry(f.getName(), f.getPath(), type);
                            tableModel.addEntry(tableModel.getRowCount(), flEntry);
                            foundAny = true;
                            continue;
                        }
                        FileListEntry flEntry = new FileListEntry(f.getName(), f.getPath(), new UnknownExternalFileType(""));
                        tableModel.addEntry(tableModel.getRowCount(), flEntry);
                        foundAny = true;
                    }
                }
                final int id = foundAny ? 1 : 0;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (diag != null) {
                            diag.dispose();
                        }
                        if (callback != null) {
                            callback.actionPerformed(new ActionEvent(this, id, ""));
                        }
                    }
                });
            }
        };
        Thread t = new Thread(r);
        t.start();
        if (diag != null) {
            diag.setVisible(true);
        }
        return t;
    }

    public static File relativizePath(File f, ArrayList<File> dirs) {
        String pth = f.getPath();
        for (File dir : dirs) {
            if (dir.getPath().length() <= 0 || !pth.startsWith(dir.getPath())) continue;
            String subs = pth.substring(dir.getPath().length());
            if (subs.length() > 0 && (subs.charAt(0) == '/' || subs.charAt(0) == '\\')) {
                subs = subs.substring(1);
            }
            return new File(subs);
        }
        return f;
    }

    private void downloadFile() {
        int answer;
        String bibtexKey = this.entryEditor.getEntry().getCiteKey();
        if (bibtexKey == null && (answer = JOptionPane.showConfirmDialog(this.frame, Globals.lang("This entry has no BibTeX key. Generate key now?"), Globals.lang("Download file"), 2, 3)) == 0) {
            EntryEditor.GenerateKeyAction l = this.entryEditor.generateKeyAction;
            l.actionPerformed(null);
            bibtexKey = this.entryEditor.getEntry().getCiteKey();
        }
        DownloadExternalFile def = new DownloadExternalFile(this.frame, this.frame.basePanel().metaData(), bibtexKey);
        try {
            def.download(this);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void downloadComplete(FileListEntry file) {
        this.tableModel.addEntry(this.tableModel.getRowCount(), file);
        this.entryEditor.updateField(this);
    }

    @Override
    public boolean hasUndoInformation() {
        return false;
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean hasRedoInformation() {
        return false;
    }

    @Override
    public void redo() {
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
    }

    @Override
    public void setAutoCompleteListener(AutoCompleteListener listener) {
    }

    @Override
    public void clearAutoCompleteSuggestion() {
    }

    class FileListEditorTransferHandler
    extends TransferHandler {
        protected DataFlavor urlFlavor;
        protected DataFlavor stringFlavor = DataFlavor.stringFlavor;

        public FileListEditorTransferHandler() {
            try {
                this.urlFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
            }
            catch (ClassNotFoundException e) {
                Globals.logger("Unable to configure drag and drop for file link table");
                e.printStackTrace();
            }
        }

        public int getSourceActions(JComponent c) {
            return 0x40000000;
        }

        public boolean importData(JComponent comp, Transferable t) {
            try {
                List<File> files = null;
                if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    files = (List<File>)t.getTransferData(DataFlavor.javaFileListFlavor);
                }
                if (t.isDataFlavorSupported(this.urlFlavor)) {
                    URL dropLink = (URL)t.getTransferData(this.urlFlavor);
                    System.out.println("URL: " + dropLink);
                }
                if (t.isDataFlavorSupported(this.stringFlavor)) {
                    String dropStr = (String)t.getTransferData(this.stringFlavor);
                    files = EntryTableTransferHandler.getFilesFromDraggedFilesString(dropStr);
                }
                if (files != null) {
                    final List<File> theFiles = files;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            for (File f : theFiles) {
                                String name = f.getAbsolutePath();
                                String extension = "";
                                ExternalFileType fileType = null;
                                int index = name.lastIndexOf(46);
                                if (index >= 0 && index < name.length()) {
                                    extension = name.substring(index + 1).toLowerCase();
                                    fileType = Globals.prefs.getExternalFileTypeByExt(extension);
                                }
                                if (fileType == null) continue;
                                DroppedFileHandler dfh = new DroppedFileHandler(FileListEditor.this.frame, FileListEditor.this.frame.basePanel());
                                dfh.handleDroppedfile(name, fileType, true, FileListEditor.this.entryEditor.getEntry());
                            }
                        }
                    });
                    return true;
                }
            }
            catch (IOException ioe) {
                System.err.println("failed to read dropped data: " + ioe.toString());
            }
            catch (UnsupportedFlavorException ufe) {
                System.err.println("drop type error: " + ufe.toString());
            }
            System.err.println("can't transfer input: ");
            DataFlavor[] inflavs = t.getTransferDataFlavors();
            for (int i = 0; i < inflavs.length; ++i) {
                System.out.println("  " + inflavs[i].toString());
            }
            return false;
        }

        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            for (int i = 0; i < transferFlavors.length; ++i) {
                DataFlavor inflav = transferFlavors[i];
                if (!inflav.match(this.urlFlavor) && !inflav.match(this.stringFlavor) && !inflav.match(DataFlavor.javaFileListFlavor)) continue;
                return true;
            }
            return false;
        }
    }

    class TableClickListener
    extends MouseAdapter {
        TableClickListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                int row = FileListEditor.this.rowAtPoint(e.getPoint());
                if (row >= 0) {
                    FileListEntry entry = FileListEditor.this.tableModel.getEntry(row);
                    FileListEditor.this.editListEntry(entry, false);
                }
            } else if (e.isPopupTrigger()) {
                this.processPopupTrigger(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.processPopupTrigger(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.processPopupTrigger(e);
            }
        }

        private void processPopupTrigger(MouseEvent e) {
            int row = FileListEditor.this.rowAtPoint(e.getPoint());
            if (row >= 0) {
                FileListEditor.this.setRowSelectionInterval(row, row);
                FileListEditor.this.menu.show(FileListEditor.this, e.getX(), e.getY());
            }
        }
    }
}

