/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.JPanel;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.Util;
import net.sf.jabref.imports.CiteSeerEntryFetcherHandler;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.OAI2Fetcher;
import org.xml.sax.helpers.DefaultHandler;

public class CiteSeerEntryFetcher
implements EntryFetcher {
    static final String OAI_URL = "http://cs1.ist.psu.edu/cgi-bin/oai.cgi?verb=GetRecord&metadataPrefix=oai_citeseer&identifier=oai:CiteSeerPSU:";
    protected SAXParser saxParser;
    protected boolean stop;

    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter frame) {
        this.stop = false;
        String[] ids = query.trim().split("[;,\\s]+");
        for (int i = 0; i < ids.length && !this.stop; ++i) {
            String id = ids[i];
            if ((id = id.replaceAll("(http://citeseer.ist.psu.edu/|\\.html|oai:CiteSeerPSU:)", "")).matches("^\\d+$")) {
                BibtexEntry entry = new BibtexEntry(Util.createNeutralId(), BibtexEntryType.getType("article"));
                entry.setField("citeseerurl", id);
                try {
                    URL citeseerUrl = new URL(OAI_URL + id);
                    HttpURLConnection citeseerConnection = (HttpURLConnection)citeseerUrl.openConnection();
                    InputStream inputStream = citeseerConnection.getInputStream();
                    CiteSeerEntryFetcherHandler handlerBase = new CiteSeerEntryFetcherHandler(entry);
                    if (this.saxParser == null) {
                        this.saxParser = SAXParserFactory.newInstance().newSAXParser();
                    }
                    this.saxParser.parse(inputStream, (DefaultHandler)handlerBase);
                    for (String name : entry.getAllFields()) {
                        entry.setField(name, OAI2Fetcher.correctLineBreaks(entry.getField(name).toString()));
                    }
                    dialog.addEntry(entry);
                    dialog.setProgress(i + 1, ids.length);
                }
                catch (Exception e) {
                    frame.showMessage(Globals.lang("Error fetching from Citeseer:\n" + e.getLocalizedMessage()), Globals.lang("Fetch Citeseer"), 0);
                }
                return true;
            }
            frame.showMessage(Globals.lang("Citeseer only supports numerical ids, '%0' is invalid.\nSee the help for further information.", id), Globals.lang("Fetch Citeseer"), 1);
        }
        return false;
    }

    public String getHelpPage() {
        return GUIGlobals.citeSeerHelp;
    }

    public URL getIcon() {
        return GUIGlobals.getIconUrl("citeseer");
    }

    public String getKeyName() {
        return "Fetch CiteSeer";
    }

    public JPanel getOptionsPanel() {
        return null;
    }

    public String getTitle() {
        return Globals.menuTitle("Fetch CiteSeer by ID");
    }

    public void stopFetching() {
        this.stop = true;
    }
}

