/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.Util;
import net.sf.jabref.gui.ImportInspectionDialog;
import net.sf.jabref.imports.EntryFetcher;

public class GeneralFetcher
extends SidePaneComponent
implements ActionListener {
    JTextField tf = new JTextField();
    JPanel pan = new JPanel();
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JButton go = new JButton(Globals.lang("Fetch"));
    JButton helpBut = new JButton(GUIGlobals.getImage("helpSmall"));
    JButton reset = new JButton(Globals.lang("Reset"));
    HelpAction help;
    EntryFetcher fetcher;
    SidePaneManager sidePaneManager;
    Action action;
    JabRefFrame frame;

    public GeneralFetcher(SidePaneManager p0, JabRefFrame frame, EntryFetcher fetcher) {
        super(p0, fetcher.getIcon(), fetcher.getTitle());
        JPanel pan;
        this.sidePaneManager = p0;
        this.frame = frame;
        this.fetcher = fetcher;
        this.action = new FetcherAction();
        this.help = new HelpAction(Globals.helpDiag, fetcher.getHelpPage(), "Help");
        this.helpBut.addActionListener(this.help);
        this.helpBut.setMargin(new Insets(0, 0, 0, 0));
        this.tf.setPreferredSize(new Dimension(1, this.tf.getPreferredSize().height));
        this.tf.setName("tf");
        this.reset.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                GeneralFetcher.this.tf.setText("");
                new FocusRequester(GeneralFetcher.this.tf);
            }
        });
        JPanel main = new JPanel();
        main.setLayout(this.gbl);
        this.con.fill = 1;
        this.con.insets = new Insets(0, 0, 2, 0);
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.weighty = 1.0;
        this.con.insets = new Insets(0, 0, 0, 0);
        this.con.fill = 1;
        this.gbl.setConstraints(this.tf, this.con);
        main.add(this.tf);
        this.con.weighty = 0.0;
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.go, this.con);
        main.add(this.go);
        this.con.gridwidth = fetcher.getHelpPage() != null ? 1 : 0;
        this.reset.setName("reset");
        this.gbl.setConstraints(this.reset, this.con);
        main.add(this.reset);
        if (fetcher.getHelpPage() != null) {
            this.con.gridwidth = 0;
            this.gbl.setConstraints(this.helpBut, this.con);
            main.add(this.helpBut);
        }
        if ((pan = fetcher.getOptionsPanel()) != null) {
            this.gbl.setConstraints(pan, this.con);
            main.add(pan);
        }
        main.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)main, "Center");
        this.go.addActionListener(this);
        this.tf.addActionListener(this);
    }

    public void setHelpResourceOwner(Class c) {
        this.help.setResourceOwner(c);
    }

    public JTextField getTextField() {
        return this.tf;
    }

    public Action getAction() {
        return this.action;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.tf.getText().trim().length() == 0) {
            return;
        }
        final ImportInspectionDialog dialog = new ImportInspectionDialog(this.frame, this.frame.basePanel(), BibtexFields.DEFAULT_INSPECTION_FIELDS, this.fetcher.getTitle(), false);
        dialog.addCallBack(this.fetcher);
        Util.placeDialog(dialog, this.frame);
        dialog.setVisible(true);
        new Thread(new Runnable(){

            public void run() {
                if (GeneralFetcher.this.fetcher.processQuery(GeneralFetcher.this.tf.getText().trim(), dialog, GeneralFetcher.this.frame)) {
                    dialog.entryListComplete();
                } else {
                    dialog.dispose();
                }
            }
        }).start();
    }

    class FetcherAction
    extends AbstractAction {
        public FetcherAction() {
            super(GeneralFetcher.this.fetcher.getTitle(), new ImageIcon(GeneralFetcher.this.fetcher.getIcon()));
            if (GeneralFetcher.this.fetcher.getKeyName() != null && GeneralFetcher.this.fetcher.getKeyName().length() > 0) {
                this.putValue("AcceleratorKey", Globals.prefs.getKey(GeneralFetcher.this.fetcher.getKeyName()));
            }
        }

        public void actionPerformed(ActionEvent e) {
            String fetcherTitle = GeneralFetcher.this.fetcher.getTitle();
            if (!GeneralFetcher.this.sidePaneManager.hasComponent(fetcherTitle)) {
                GeneralFetcher.this.sidePaneManager.register(fetcherTitle, GeneralFetcher.this);
            }
            if (GeneralFetcher.this.frame.getTabbedPane().getTabCount() > 0) {
                GeneralFetcher.this.sidePaneManager.toggle(fetcherTitle);
                if (GeneralFetcher.this.sidePaneManager.isComponentVisible(fetcherTitle)) {
                    new FocusRequester(GeneralFetcher.this.getTextField());
                }
            }
        }
    }
}

