/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibsonomyScraper;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.net.URLDownload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSTORFetcher2
implements EntryFetcher {
    protected static int MAX_PAGES_TO_LOAD = 8;
    protected static final String JSTOR_URL = "http://www.jstor.org";
    protected static final String SEARCH_URL = "http://www.jstor.org/action/doBasicSearch?Query=";
    protected static final String SEARCH_URL_END = "&x=0&y=0&wc=on";
    protected static final String SINGLE_CIT_ENC = "http://www.jstor.org/action/exportSingleCitation?singleCitation=true&suffix=";
    protected static final Pattern idPattern = Pattern.compile("<a class=\"title\" href=\"/stable/(\\d+)\\?");
    protected static final Pattern nextPagePattern = Pattern.compile("<a href=\"(.*)\">Next &gt;");
    protected static final String noAccessIndicator = "We do not recognize you as having access to JSTOR";
    protected boolean stopFetching = false;
    protected boolean noAccessFound = false;

    @Override
    public String getHelpPage() {
        return "JSTOR.html";
    }

    @Override
    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    @Override
    public String getKeyName() {
        return "Search JSTOR";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return Globals.menuTitle("Search JSTOR");
    }

    @Override
    public void stopFetching() {
        this.stopFetching = true;
        this.noAccessFound = false;
    }

    @Override
    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter status) {
        this.stopFetching = false;
        try {
            List<String> citations = this.getCitations(query);
            if (citations == null) {
                return false;
            }
            if (citations.size() == 0) {
                if (!this.noAccessFound) {
                    status.showMessage(Globals.lang("No entries found for the search string '%0'", query), Globals.lang("Search JSTOR"), 1);
                } else {
                    status.showMessage(Globals.lang("No entries found. It looks like you do not have access to search JStor.", query), Globals.lang("Search JSTOR"), 1);
                }
                return false;
            }
            int i = 0;
            for (String cit : citations) {
                if (this.stopFetching) break;
                BibtexEntry entry = this.getSingleCitation(cit);
                if (entry != null) {
                    dialog.addEntry(entry);
                }
                dialog.setProgress(++i, citations.size());
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            status.showMessage(Globals.lang("Error while fetching from JSTOR") + ": " + e.getMessage());
            return false;
        }
    }

    protected List<String> getCitations(String query) throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            String urlQuery = SEARCH_URL + URLEncoder.encode(query, "UTF-8") + SEARCH_URL_END;
            String nextPage = null;
            for (int count = 1; (nextPage = this.getCitationsFromUrl(urlQuery, ids)) != null && count < MAX_PAGES_TO_LOAD; ++count) {
                urlQuery = nextPage;
            }
            return ids;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getCitationsFromUrl(String urlQuery, List<String> ids) throws IOException {
        String cont;
        URL url = new URL(urlQuery);
        URLDownload ud = new URLDownload(url);
        ud.download();
        String entirePage = cont = ud.getStringContent();
        Matcher m = idPattern.matcher(cont);
        if (m.find()) {
            while (m.find()) {
                ids.add(m.group(1));
                cont = cont.substring(m.end());
                m = idPattern.matcher(cont);
            }
        } else {
            if (entirePage.indexOf(noAccessIndicator) >= 0) {
                this.noAccessFound = true;
                return null;
            }
            return null;
        }
        m = nextPagePattern.matcher(entirePage);
        if (m.find()) {
            String newQuery = JSTOR_URL + m.group(1);
            return newQuery;
        }
        return null;
    }

    protected BibtexEntry getSingleCitation(String cit) {
        return BibsonomyScraper.getEntry(SINGLE_CIT_ENC + cit);
    }
}

