/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.journals;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.journals.JournalAbbreviations;
import net.sf.jabref.net.URLDownload;

public class ManageJournalsPanel
extends JPanel {
    JabRefFrame frame;
    JTextField personalFile = new JTextField();
    AbbreviationsTableModel tableModel = new AbbreviationsTableModel();
    JTable userTable;
    JPanel userPanel = new JPanel();
    JPanel journalEditPanel;
    JPanel externalFilesPanel = new JPanel();
    JPanel addExtPan = new JPanel();
    JTextField nameTf = new JTextField();
    JTextField newNameTf = new JTextField();
    JTextField abbrTf = new JTextField();
    List<ExternalFileEntry> externals = new ArrayList<ExternalFileEntry>();
    JDialog dialog;
    JRadioButton newFile = new JRadioButton(Globals.lang("New file"));
    JRadioButton oldFile = new JRadioButton(Globals.lang("Existing file"));
    JButton add = new JButton(GUIGlobals.getImage("add"));
    JButton remove = new JButton(GUIGlobals.getImage("remove"));
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    JButton help = new JButton(Globals.lang("Help"));
    JButton browseOld = new JButton(Globals.lang("Browse"));
    JButton browseNew = new JButton(Globals.lang("Browse"));
    JButton addExt = new JButton(GUIGlobals.getImage("add"));

    public ManageJournalsPanel(final JabRefFrame frame) {
        this.frame = frame;
        this.personalFile.setEditable(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.newFile);
        group.add(this.oldFile);
        this.addExtPan.setLayout(new BorderLayout());
        this.addExtPan.add((Component)this.addExt, "East");
        this.addExtPan.setToolTipText(Globals.lang("Add"));
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:200dlu:grow, 4dlu, fill:pref", "pref, 20dlu, 20dlu, fill:200dlu, 4dlu, pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Globals.lang("Personal journal list"), cc.xyw(2, 1, 6));
        builder.add((Component)this.newFile, cc.xy(3, 2));
        builder.add((Component)this.newNameTf, cc.xy(5, 2));
        builder.add((Component)this.browseNew, cc.xy(7, 2));
        builder.add((Component)this.oldFile, cc.xy(3, 3));
        builder.add((Component)this.personalFile, cc.xy(5, 3));
        builder.add((Component)this.browseOld, cc.xy(7, 3));
        this.userPanel.setLayout(new BorderLayout());
        builder.add((Component)this.userPanel, cc.xyw(2, 4, 4));
        ButtonStackBuilder butBul = new ButtonStackBuilder();
        butBul.addGridded(this.add);
        butBul.addGridded(this.remove);
        butBul.addGlue();
        builder.add((Component)butBul.getPanel(), cc.xy(7, 4));
        builder.addSeparator(Globals.lang("External files"), cc.xyw(2, 6, 6));
        this.externalFilesPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)builder.getPanel(), "North");
        this.add((Component)this.externalFilesPanel, "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addGridded(this.ok);
        bb.addGridded(this.cancel);
        bb.addUnrelatedGap();
        bb.addGridded(this.help);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.dialog = new JDialog(frame, Globals.lang("Journal abbreviations"), false);
        this.dialog.getContentPane().add((Component)this, "Center");
        this.dialog.getContentPane().add((Component)bb.getPanel(), "South");
        FormLayout layout2 = new FormLayout("right:pref, 4dlu, fill:180dlu", "");
        DefaultFormBuilder builder2 = new DefaultFormBuilder(layout2);
        builder2.append(Globals.lang("Journal name"));
        builder2.append(this.nameTf);
        builder2.nextLine();
        builder2.append(Globals.lang("ISO abbreviation"));
        builder2.append(this.abbrTf);
        this.journalEditPanel = builder2.getPanel();
        this.browseNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name;
                File old = null;
                if (!ManageJournalsPanel.this.newNameTf.getText().equals("")) {
                    old = new File(ManageJournalsPanel.this.newNameTf.getText());
                }
                if ((name = FileDialogs.getNewFile(frame, old, null, 1, false)) != null) {
                    if (old == null || ManageJournalsPanel.this.tableModel.getRowCount() > 0) {
                        // empty if block
                    }
                    ManageJournalsPanel.this.newNameTf.setText(name);
                    ManageJournalsPanel.this.newFile.setSelected(true);
                }
            }
        });
        this.browseOld.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name;
                File old = null;
                if (!ManageJournalsPanel.this.personalFile.getText().equals("")) {
                    old = new File(ManageJournalsPanel.this.personalFile.getText());
                }
                if ((name = FileDialogs.getNewFile(frame, old, null, 0, false)) != null) {
                    if (old == null || ManageJournalsPanel.this.tableModel.getRowCount() > 0) {
                        // empty if block
                    }
                    ManageJournalsPanel.this.personalFile.setText(name);
                    ManageJournalsPanel.this.oldFile.setSelected(true);
                    ManageJournalsPanel.this.oldFile.setEnabled(true);
                    ManageJournalsPanel.this.setupUserTable();
                }
            }
        });
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ManageJournalsPanel.this.readyToClose()) {
                    ManageJournalsPanel.this.storeSettings();
                    ManageJournalsPanel.this.dialog.dispose();
                }
            }
        });
        this.help.addActionListener(new HelpAction(Globals.helpDiag, GUIGlobals.journalAbbrHelp));
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ManageJournalsPanel.this.dialog.dispose();
            }
        };
        this.cancel.addActionListener(cancelAction);
        this.add.addActionListener(this.tableModel);
        this.remove.addActionListener(this.tableModel);
        this.addExt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManageJournalsPanel.this.externals.add(new ExternalFileEntry());
                ManageJournalsPanel.this.buildExternalsPanel();
            }
        });
        ActionMap am = this.getActionMap();
        InputMap im = this.getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", cancelAction);
        int xSize = this.getPreferredSize().width;
        this.dialog.setSize(xSize + 10, 700);
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setValues() {
        this.personalFile.setText(Globals.prefs.get("personalJournalList"));
        if (this.personalFile.getText().length() == 0) {
            this.newFile.setSelected(true);
            this.oldFile.setEnabled(false);
        } else {
            this.oldFile.setSelected(true);
            this.oldFile.setEnabled(true);
        }
        this.setupUserTable();
        this.setupExternals();
        this.buildExternalsPanel();
    }

    private void buildExternalsPanel() {
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("fill:pref:grow", ""));
        for (ExternalFileEntry efe : this.externals) {
            builder.append(efe.getPanel());
            builder.nextLine();
        }
        builder.append(Box.createVerticalGlue());
        builder.nextLine();
        builder.append(this.addExtPan);
        builder.nextLine();
        builder.append(Box.createVerticalGlue());
        JScrollPane pane = new JScrollPane(builder.getPanel());
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.externalFilesPanel.setMinimumSize(new Dimension(400, 400));
        this.externalFilesPanel.setPreferredSize(new Dimension(400, 400));
        this.externalFilesPanel.removeAll();
        this.externalFilesPanel.add((Component)pane, "Center");
        this.externalFilesPanel.revalidate();
        this.externalFilesPanel.repaint();
    }

    private void setupExternals() {
        String[] externalFiles = Globals.prefs.getStringArray("externalJournalLists");
        if (externalFiles == null || externalFiles.length == 0) {
            ExternalFileEntry efe = new ExternalFileEntry();
            this.externals.add(efe);
        } else {
            for (int i = 0; i < externalFiles.length; ++i) {
                ExternalFileEntry efe = new ExternalFileEntry(externalFiles[i]);
                this.externals.add(efe);
            }
        }
    }

    public void setupUserTable() {
        JournalAbbreviations userAbbr = new JournalAbbreviations();
        String filename = this.personalFile.getText();
        if (!filename.equals("") && new File(filename).exists()) {
            try {
                userAbbr.readJournalList(new File(filename));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.tableModel.setJournals(userAbbr.getJournals());
        this.userTable = new JTable(this.tableModel);
        this.userTable.addMouseListener(this.tableModel.getMouseListener());
        this.userPanel.add((Component)new JScrollPane(this.userTable), "Center");
    }

    public boolean readyToClose() {
        if (this.newFile.isSelected()) {
            if (this.newNameTf.getText().length() > 0) {
                File f = new File(this.newNameTf.getText());
                return !f.exists() || JOptionPane.showConfirmDialog(this, "'" + f.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Store journal abbreviations"), 2) == 0;
            }
            if (this.tableModel.getRowCount() > 0) {
                JOptionPane.showMessageDialog(this, Globals.lang("You must choose a file name to store journal abbreviations"), Globals.lang("Store journal abbreviations"), 0);
                return false;
            }
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSettings() {
        File f = null;
        if (this.newFile.isSelected()) {
            if (this.newNameTf.getText().length() > 0) {
                f = new File(this.newNameTf.getText());
            }
        } else {
            f = new File(this.personalFile.getText());
        }
        if (f != null) {
            FileWriter fw = null;
            try {
                fw = new FileWriter(f, false);
                for (JournalEntry entry : this.tableModel.getJournals()) {
                    fw.write(entry.name);
                    fw.write(" = ");
                    fw.write(entry.abbreviation);
                    fw.write(Globals.NEWLINE);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            String filename = f.getPath();
            if (filename.equals("")) {
                filename = null;
            }
            Globals.prefs.put("personalJournalList", filename);
        }
        ArrayList<String> extFiles = new ArrayList<String>();
        for (ExternalFileEntry efe : this.externals) {
            if (efe.getValue().equals("")) continue;
            extFiles.add(efe.getValue());
        }
        if (extFiles.size() == 0) {
            Globals.prefs.put("externalJournalLists", "");
        } else {
            String[] list = extFiles.toArray(new String[extFiles.size()]);
            Globals.prefs.putStringArray("externalJournalLists", list);
        }
        Globals.initializeJournalNames();
        for (int i = 0; i < this.frame.baseCount(); ++i) {
            this.frame.baseAt(i).addJournalListToAutoCompleter();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JournalEntry
    implements Comparable<JournalEntry> {
        String name;
        String abbreviation;

        public JournalEntry(String name, String abbreviation) {
            this.name = name;
            this.abbreviation = abbreviation;
        }

        @Override
        public int compareTo(JournalEntry other) {
            return this.name.compareTo(other.name);
        }
    }

    class ExternalFileEntry {
        private JPanel pan;
        private JTextField tf;
        private JButton browse = new JButton(Globals.lang("Browse"));
        private JButton view = new JButton(Globals.lang("Preview"));
        private JButton clear = new JButton(GUIGlobals.getImage("delete"));
        private JButton download = new JButton(Globals.lang("Download"));

        public ExternalFileEntry() {
            this.tf = new JTextField();
            this.setupPanel();
        }

        public ExternalFileEntry(String filename) {
            this.tf = new JTextField(filename);
            this.setupPanel();
        }

        private void setupPanel() {
            this.tf.setEditable(false);
            BrowseAction browseA = new BrowseAction(this.tf, false);
            this.browse.addActionListener(browseA);
            DownloadAction da = new DownloadAction(this.tf);
            this.download.addActionListener(da);
            DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("fill:pref:grow, 4dlu, fill:pref, 4dlu, fill:pref, 4dlu, fill:pref, 4dlu, fill:pref", ""));
            builder.append(this.tf);
            builder.append(this.browse);
            builder.append(this.download);
            builder.append(this.view);
            builder.append(this.clear);
            this.pan = builder.getPanel();
            this.view.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JournalAbbreviations abbr = new JournalAbbreviations(new File(ExternalFileEntry.this.tf.getText()));
                        JTable table = new JTable(abbr.getTableModel());
                        JScrollPane pane = new JScrollPane(table);
                        JOptionPane.showMessageDialog(null, pane, Globals.lang("Journal list preview"), 1);
                    }
                    catch (FileNotFoundException ex) {
                        JOptionPane.showMessageDialog(null, Globals.lang("File '%0' not found", ExternalFileEntry.this.tf.getText()), Globals.lang("Error"), 0);
                    }
                }
            });
            this.clear.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ManageJournalsPanel.this.externals.remove(ExternalFileEntry.this);
                    ManageJournalsPanel.this.buildExternalsPanel();
                }
            });
            this.clear.setToolTipText(Globals.lang("Remove"));
        }

        public JPanel getPanel() {
            return this.pan;
        }

        public String getValue() {
            return this.tf.getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AbbreviationsTableModel
    extends AbstractTableModel
    implements ActionListener {
        String[] names = new String[]{Globals.lang("Journal name"), Globals.lang("Abbreviation")};
        ArrayList<JournalEntry> journals = null;

        public void setJournals(Map<String, String> journals) {
            this.journals = new ArrayList();
            for (Map.Entry<String, String> entry : journals.entrySet()) {
                this.journals.add(new JournalEntry(entry.getKey(), entry.getValue()));
            }
            this.fireTableDataChanged();
        }

        public ArrayList<JournalEntry> getJournals() {
            return this.journals;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.journals.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.journals.get((int)row).name;
            }
            return this.journals.get((int)row).abbreviation;
        }

        @Override
        public void setValueAt(Object object, int row, int col) {
            JournalEntry entry = this.journals.get(row);
            if (col == 0) {
                entry.name = (String)object;
            } else {
                entry.abbreviation = (String)object;
            }
        }

        @Override
        public String getColumnName(int i) {
            return this.names[i];
        }

        @Override
        public boolean isCellEditable(int i, int i1) {
            return false;
        }

        public MouseListener getMouseListener() {
            return new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        JTable table = (JTable)e.getSource();
                        int row = table.rowAtPoint(e.getPoint());
                        ManageJournalsPanel.this.nameTf.setText((String)AbbreviationsTableModel.this.getValueAt(row, 0));
                        ManageJournalsPanel.this.abbrTf.setText((String)AbbreviationsTableModel.this.getValueAt(row, 1));
                        if (JOptionPane.showConfirmDialog(ManageJournalsPanel.this.dialog, ManageJournalsPanel.this.journalEditPanel, Globals.lang("Edit journal"), 2) == 0) {
                            AbbreviationsTableModel.this.setValueAt(ManageJournalsPanel.this.nameTf.getText(), row, 0);
                            AbbreviationsTableModel.this.setValueAt(ManageJournalsPanel.this.abbrTf.getText(), row, 1);
                            Collections.sort(AbbreviationsTableModel.this.journals);
                            AbbreviationsTableModel.this.fireTableDataChanged();
                        }
                    }
                }
            };
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows;
            if (e.getSource() == ManageJournalsPanel.this.add) {
                ManageJournalsPanel.this.nameTf.setText("");
                ManageJournalsPanel.this.abbrTf.setText("");
                if (JOptionPane.showConfirmDialog(ManageJournalsPanel.this.dialog, ManageJournalsPanel.this.journalEditPanel, Globals.lang("Edit journal"), 2) == 0) {
                    this.journals.add(new JournalEntry(ManageJournalsPanel.this.nameTf.getText(), ManageJournalsPanel.this.abbrTf.getText()));
                    Collections.sort(this.journals);
                    this.fireTableDataChanged();
                }
            } else if (e.getSource() == ManageJournalsPanel.this.remove && (rows = ManageJournalsPanel.this.userTable.getSelectedRows()).length > 0) {
                for (int i = rows.length - 1; i >= 0; --i) {
                    this.journals.remove(rows[i]);
                }
                this.fireTableDataChanged();
            }
        }
    }

    class BrowseAction
    extends AbstractAction {
        JTextField comp;
        boolean dir;

        public BrowseAction(JTextField tc, boolean dir) {
            super(Globals.lang("Browse"));
            this.dir = dir;
            this.comp = tc;
        }

        public void actionPerformed(ActionEvent e) {
            String chosen = null;
            chosen = this.dir ? FileDialogs.getNewDir(ManageJournalsPanel.this.frame, new File(this.comp.getText()), "_non__", 0, false) : FileDialogs.getNewFile(ManageJournalsPanel.this.frame, new File(this.comp.getText()), "_non__", 0, false);
            if (chosen != null) {
                File newFile = new File(chosen);
                this.comp.setText(newFile.getPath());
            }
        }
    }

    class DownloadAction
    extends AbstractAction {
        JTextField comp;

        public DownloadAction(JTextField tc) {
            super(Globals.lang("Download"));
            this.comp = tc;
        }

        public void actionPerformed(ActionEvent e) {
            String chosen = null;
            chosen = JOptionPane.showInputDialog(Globals.lang("Choose the URL to download. The default value points to a list provided by the JabRef developers."), (Object)"http://jabref.sf.net/journals/journal_abbreviations_general.txt");
            if (chosen == null) {
                return;
            }
            try {
                URL url = new URL(chosen);
                String toName = FileDialogs.getNewFile(ManageJournalsPanel.this.frame, new File(System.getProperty("user.home")), null, 1, false);
                if (toName == null) {
                    return;
                }
                File toFile = new File(toName);
                URLDownload ud = new URLDownload(this.comp, url, toFile);
                ud.download();
                this.comp.setText(toFile.getPath());
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
        }
    }
}

