/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.mods;

import java.util.Vector;
import net.sf.jabref.AuthorList;
import wsi.ra.tool.WSITools;

public class PersonName {
    protected String givenName = null;
    protected String surname = null;
    protected String middleName = null;

    public PersonName() {
    }

    public PersonName(String name) {
        this.parseName(name);
    }

    public PersonName(String firstName, String _middleName, String lastName) {
        this.givenName = firstName;
        this.middleName = _middleName;
        this.surname = lastName;
    }

    protected void parseName(String author) {
        Vector<String> v = new Vector<String>();
        String authorMod = AuthorList.fixAuthor_firstNameFirst(author);
        WSITools.tokenize(v, authorMod, " \n\r");
        if (v.size() == 1) {
            this.surname = v.get(0);
        } else if (v.size() == 2) {
            this.givenName = v.get(0);
            this.surname = v.get(1);
        } else {
            this.givenName = v.get(0);
            this.middleName = v.get(1);
            this.surname = v.get(2);
        }
    }

    public String getGivenNames() {
        String result = "";
        if (this.givenName != null) {
            result = result + this.givenName;
        }
        if (this.middleName != null) {
            result = result + " " + this.middleName;
        }
        return result;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String lastName) {
        this.surname = lastName;
    }

    public String getFirstname() {
        return this.givenName;
    }

    public void setFirstname(String firstName) {
        this.givenName = firstName;
    }

    public String getMiddlename() {
        return this.middleName;
    }

    public void setMiddlename(String _middleName) {
        this.middleName = _middleName;
    }

    public String getFullname() {
        String fullName = "";
        if (this.givenName != null && this.givenName != "") {
            fullName = fullName + this.givenName + " ";
        }
        if (this.middleName != null && this.middleName != "") {
            fullName = fullName + this.middleName + " ";
        }
        if (this.surname != null && this.surname != "") {
            fullName = fullName + this.surname;
        }
        return fullName.trim();
    }

    public String toString() {
        return this.surname;
    }
}

