/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.msbib;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.export.layout.format.XMLChars;
import net.sf.jabref.mods.PageNumbers;
import net.sf.jabref.mods.PersonName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSBibEntry {
    protected String sourceType = "Misc";
    protected String bibTexEntry = null;
    protected String tag = null;
    protected String GUID = null;
    protected int LCID = -1;
    protected List<PersonName> authors = null;
    protected List<PersonName> bookAuthors = null;
    protected List<PersonName> editors = null;
    protected List<PersonName> translators = null;
    protected List<PersonName> producerNames = null;
    protected List<PersonName> composers = null;
    protected List<PersonName> conductors = null;
    protected List<PersonName> performers = null;
    protected List<PersonName> writers = null;
    protected List<PersonName> directors = null;
    protected List<PersonName> compilers = null;
    protected List<PersonName> interviewers = null;
    protected List<PersonName> interviewees = null;
    protected List<PersonName> inventors = null;
    protected List<PersonName> counsels = null;
    protected String title = null;
    protected String year = null;
    protected String month = null;
    protected String day = null;
    protected String shortTitle = null;
    protected String comments = null;
    protected PageNumbers pages = null;
    protected String volume = null;
    protected String numberOfVolumes = null;
    protected String edition = null;
    protected String standardNumber = null;
    protected String publisher = null;
    protected String address = null;
    protected String bookTitle = null;
    protected String chapterNumber = null;
    protected String journalName = null;
    protected String issue = null;
    protected String periodicalTitle = null;
    protected String conferenceName = null;
    protected String department = null;
    protected String institution = null;
    protected String thesisType = null;
    protected String internetSiteTitle = null;
    protected String dateAccessed = null;
    protected String url = null;
    protected String productionCompany = null;
    protected String publicationTitle = null;
    protected String medium = null;
    protected String albumTitle = null;
    protected String recordingNumber = null;
    protected String theater = null;
    protected String distributor = null;
    protected String broadcastTitle = null;
    protected String broadcaster = null;
    protected String station = null;
    protected String type = null;
    protected String patentNumber = null;
    protected String court = null;
    protected String reporter = null;
    protected String caseNumber = null;
    protected String abbreviatedCaseNumber = null;
    protected String bibTex_Series = null;
    protected String bibTex_Abstract = null;
    protected String bibTex_KeyWords = null;
    protected String bibTex_CrossRef = null;
    protected String bibTex_HowPublished = null;
    protected String bibTex_Affiliation = null;
    protected String bibTex_Contents = null;
    protected String bibTex_Copyright = null;
    protected String bibTex_Price = null;
    protected String bibTex_Size = null;
    private final String BIBTEX = "BIBTEX_";
    private final String MSBIB = "msbib-";
    private final String bcol = "b:";
    private final boolean FORMATXML = false;

    public MSBibEntry() {
    }

    public MSBibEntry(BibtexEntry bibtex) {
        this();
        this.populateFromBibtex(bibtex);
    }

    public MSBibEntry(Element entry, String _bcol) {
        this();
        this.populateFromXml(entry, _bcol);
    }

    protected String getFromXml(String name, Element entry) {
        String value = null;
        NodeList nodeLst = entry.getElementsByTagName(name);
        if (nodeLst.getLength() > 0) {
            value = nodeLst.item(0).getTextContent();
        }
        return value;
    }

    protected void populateFromXml(Element entry, String _bcol) {
        String temp = null;
        this.sourceType = this.getFromXml(_bcol + "SourceType", entry);
        this.tag = this.getFromXml(_bcol + "Tag", entry);
        temp = this.getFromXml(_bcol + "LCID", entry);
        if (temp != null) {
            try {
                this.LCID = Integer.parseInt(temp);
            }
            catch (Exception e) {
                this.LCID = -1;
            }
        }
        this.title = this.getFromXml(_bcol + "Title", entry);
        this.year = this.getFromXml(_bcol + "Year", entry);
        this.month = this.getFromXml(_bcol + "Month", entry);
        this.day = this.getFromXml(_bcol + "Day", entry);
        this.shortTitle = this.getFromXml(_bcol + "ShortTitle", entry);
        this.comments = this.getFromXml(_bcol + "Comments", entry);
        temp = this.getFromXml(_bcol + "Pages", entry);
        if (temp != null) {
            this.pages = new PageNumbers(temp);
        }
        this.volume = this.getFromXml(_bcol + "Volume", entry);
        this.numberOfVolumes = this.getFromXml(_bcol + "NumberVolumes", entry);
        this.edition = this.getFromXml(_bcol + "Edition", entry);
        this.standardNumber = this.getFromXml(_bcol + "StandardNumber", entry);
        this.publisher = this.getFromXml(_bcol + "Publisher", entry);
        String city = this.getFromXml(_bcol + "City", entry);
        String state = this.getFromXml(_bcol + "StateProvince", entry);
        String country = this.getFromXml(_bcol + "CountryRegion", entry);
        this.address = "";
        if (city != null) {
            this.address = this.address + city + ", ";
        }
        if (state != null) {
            this.address = this.address + state + " ";
        }
        if (country != null) {
            this.address = this.address + country;
        }
        this.address = this.address.trim();
        if (this.address.equals("") || this.address.equals(",")) {
            this.address = null;
        }
        this.bookTitle = this.getFromXml(_bcol + "BookTitle", entry);
        this.chapterNumber = this.getFromXml(_bcol + "ChapterNumber", entry);
        this.journalName = this.getFromXml(_bcol + "JournalName", entry);
        this.issue = this.getFromXml(_bcol + "Issue", entry);
        this.periodicalTitle = this.getFromXml(_bcol + "PeriodicalTitle", entry);
        this.conferenceName = this.getFromXml(_bcol + "ConferenceName", entry);
        this.department = this.getFromXml(_bcol + "Department", entry);
        this.institution = this.getFromXml(_bcol + "Institution", entry);
        this.thesisType = this.getFromXml(_bcol + "ThesisType", entry);
        this.internetSiteTitle = this.getFromXml(_bcol + "InternetSiteTitle", entry);
        String month = this.getFromXml(_bcol + "MonthAccessed", entry);
        String day = this.getFromXml(_bcol + "DayAccessed", entry);
        String year = this.getFromXml(_bcol + "YearAccessed", entry);
        this.dateAccessed = "";
        if (month != null) {
            this.dateAccessed = this.dateAccessed + month + " ";
        }
        if (day != null) {
            this.dateAccessed = this.dateAccessed + day + ", ";
        }
        if (year != null) {
            this.dateAccessed = this.dateAccessed + year;
        }
        this.dateAccessed = this.dateAccessed.trim();
        if (this.dateAccessed.equals("") || this.dateAccessed.equals(",")) {
            this.dateAccessed = null;
        }
        this.url = this.getFromXml(_bcol + "URL", entry);
        this.productionCompany = this.getFromXml(_bcol + "ProductionCompany", entry);
        this.publicationTitle = this.getFromXml(_bcol + "PublicationTitle", entry);
        this.medium = this.getFromXml(_bcol + "Medium", entry);
        this.albumTitle = this.getFromXml(_bcol + "AlbumTitle", entry);
        this.recordingNumber = this.getFromXml(_bcol + "RecordingNumber", entry);
        this.theater = this.getFromXml(_bcol + "Theater", entry);
        this.distributor = this.getFromXml(_bcol + "Distributor", entry);
        this.broadcastTitle = this.getFromXml(_bcol + "BroadcastTitle", entry);
        this.broadcaster = this.getFromXml(_bcol + "Broadcaster", entry);
        this.station = this.getFromXml(_bcol + "Station", entry);
        this.type = this.getFromXml(_bcol + "Type", entry);
        this.patentNumber = this.getFromXml(_bcol + "PatentNumber", entry);
        this.court = this.getFromXml(_bcol + "Court", entry);
        this.reporter = this.getFromXml(_bcol + "Reporter", entry);
        this.caseNumber = this.getFromXml(_bcol + "CaseNumber", entry);
        this.abbreviatedCaseNumber = this.getFromXml(_bcol + "AbbreviatedCaseNumber", entry);
        this.bibTex_Series = this.getFromXml(_bcol + "BIBTEX_" + "Series", entry);
        this.bibTex_Abstract = this.getFromXml(_bcol + "BIBTEX_" + "Abstract", entry);
        this.bibTex_KeyWords = this.getFromXml(_bcol + "BIBTEX_" + "KeyWords", entry);
        this.bibTex_CrossRef = this.getFromXml(_bcol + "BIBTEX_" + "CrossRef", entry);
        this.bibTex_HowPublished = this.getFromXml(_bcol + "BIBTEX_" + "HowPublished", entry);
        this.bibTex_Affiliation = this.getFromXml(_bcol + "BIBTEX_" + "Affiliation", entry);
        this.bibTex_Contents = this.getFromXml(_bcol + "BIBTEX_" + "Contents", entry);
        this.bibTex_Copyright = this.getFromXml(_bcol + "BIBTEX_" + "Copyright", entry);
        this.bibTex_Price = this.getFromXml(_bcol + "BIBTEX_" + "Price", entry);
        this.bibTex_Size = this.getFromXml(_bcol + "BIBTEX_" + "Size", entry);
        NodeList nodeLst = entry.getElementsByTagName(_bcol + "Author");
        if (nodeLst.getLength() > 0) {
            this.getAuthors((Element)nodeLst.item(0), _bcol);
        }
    }

    protected void populateFromBibtex(BibtexEntry bibtex) {
        this.sourceType = this.getMSBibSourceType(bibtex);
        if (bibtex.getField("bibtexkey") != null) {
            this.tag = bibtex.getField("bibtexkey").toString();
        }
        if (bibtex.getField("language") != null) {
            this.LCID = this.getLCID(bibtex.getField("language").toString());
        }
        if (bibtex.getField("title") != null) {
            this.title = bibtex.getField("title").toString();
        }
        if (bibtex.getField("year") != null) {
            this.year = bibtex.getField("year").toString();
        }
        if (bibtex.getField("month") != null) {
            this.month = bibtex.getField("month").toString();
        }
        if (bibtex.getField("msbib-day") != null) {
            this.day = bibtex.getField("msbib-day").toString();
        }
        if (bibtex.getField("msbib-shorttitle") != null) {
            this.shortTitle = bibtex.getField("msbib-shorttitle").toString();
        }
        if (bibtex.getField("note") != null) {
            this.comments = bibtex.getField("note").toString();
        }
        if (bibtex.getField("pages") != null) {
            this.pages = new PageNumbers(bibtex.getField("pages").toString());
        }
        if (bibtex.getField("volume") != null) {
            this.volume = bibtex.getField("volume").toString();
        }
        if (bibtex.getField("msbib-numberofvolume") != null) {
            this.numberOfVolumes = bibtex.getField("msbib-numberofvolume").toString();
        }
        if (bibtex.getField("edition") != null) {
            this.edition = bibtex.getField("edition").toString();
        }
        this.standardNumber = new String();
        if (bibtex.getField("ISBN") != null) {
            this.standardNumber = this.standardNumber + ":ISBN:" + bibtex.getField("ISBN").toString();
        }
        if (bibtex.getField("ISSN") != null) {
            this.standardNumber = this.standardNumber + ":ISSN:" + bibtex.getField("ISSN").toString();
        }
        if (bibtex.getField("LCCN") != null) {
            this.standardNumber = this.standardNumber + ":LCCN:" + bibtex.getField("LCCN").toString();
        }
        if (bibtex.getField("mrnumber") != null) {
            this.standardNumber = this.standardNumber + ":MRN:" + bibtex.getField("mrnumber").toString();
        }
        if (this.standardNumber.equals("")) {
            this.standardNumber = null;
        }
        if (bibtex.getField("publisher") != null) {
            this.publisher = bibtex.getField("publisher").toString();
        }
        if (bibtex.getField("address") != null) {
            this.address = bibtex.getField("address").toString();
        }
        if (bibtex.getField("booktitle") != null) {
            this.bookTitle = bibtex.getField("booktitle").toString();
        }
        if (bibtex.getField("chapter") != null) {
            this.chapterNumber = bibtex.getField("chapter").toString();
        }
        if (bibtex.getField("journal") != null) {
            this.journalName = bibtex.getField("journal").toString();
        }
        if (bibtex.getField("number") != null) {
            this.issue = bibtex.getField("number").toString();
        }
        if (bibtex.getField("msbib-periodical") != null) {
            this.periodicalTitle = bibtex.getField("msbib-periodical").toString();
        }
        if (bibtex.getField("organization") != null) {
            this.conferenceName = bibtex.getField("organization").toString();
        }
        if (bibtex.getField("school") != null) {
            this.department = bibtex.getField("school").toString();
        }
        if (bibtex.getField("institution") != null) {
            this.institution = bibtex.getField("institution").toString();
        }
        if (bibtex.getField("type") != null) {
            this.thesisType = bibtex.getField("type").toString();
        }
        if ((this.sourceType.equals("InternetSite") || this.sourceType.equals("DocumentFromInternetSite")) && bibtex.getField("title") != null) {
            this.internetSiteTitle = bibtex.getField("title").toString();
        }
        if (bibtex.getField("msbib-accessed") != null) {
            this.dateAccessed = bibtex.getField("msbib-accessed").toString();
        }
        if (bibtex.getField("URL") != null) {
            this.url = bibtex.getField("URL").toString();
        }
        if (bibtex.getField("msbib-productioncompany") != null) {
            this.productionCompany = bibtex.getField("msbib-productioncompany").toString();
        }
        if ((this.sourceType.equals("ElectronicSource") || this.sourceType.equals("Art") || this.sourceType.equals("Misc")) && bibtex.getField("title") != null) {
            this.publicationTitle = bibtex.getField("title").toString();
        }
        if (bibtex.getField("msbib-medium") != null) {
            this.medium = bibtex.getField("msbib-medium").toString();
        }
        if (this.sourceType.equals("SoundRecording") && bibtex.getField("title") != null) {
            this.albumTitle = bibtex.getField("title").toString();
        }
        if (bibtex.getField("msbib-recordingnumber") != null) {
            this.recordingNumber = bibtex.getField("msbib-recordingnumber").toString();
        }
        if (bibtex.getField("msbib-theater") != null) {
            this.theater = bibtex.getField("msbib-theater").toString();
        }
        if (bibtex.getField("msbib-distributor") != null) {
            this.distributor = bibtex.getField("msbib-distributor").toString();
        }
        if (this.sourceType.equals("Interview") && bibtex.getField("title") != null) {
            this.broadcastTitle = bibtex.getField("title").toString();
        }
        if (bibtex.getField("msbib-broadcaster") != null) {
            this.broadcaster = bibtex.getField("msbib-broadcaster").toString();
        }
        if (bibtex.getField("msbib-station") != null) {
            this.station = bibtex.getField("msbib-station").toString();
        }
        if (bibtex.getField("msbib-type") != null) {
            this.type = bibtex.getField("msbib-type").toString();
        }
        if (bibtex.getField("msbib-patentnumber") != null) {
            this.patentNumber = bibtex.getField("msbib-patentnumber").toString();
        }
        if (bibtex.getField("msbib-court") != null) {
            this.court = bibtex.getField("msbib-court").toString();
        }
        if (bibtex.getField("msbib-reporter") != null) {
            this.reporter = bibtex.getField("msbib-reporter").toString();
        }
        if (bibtex.getField("msbib-casenumber") != null) {
            this.caseNumber = bibtex.getField("msbib-casenumber").toString();
        }
        if (bibtex.getField("msbib-abbreviatedcasenumber") != null) {
            this.abbreviatedCaseNumber = bibtex.getField("msbib-abbreviatedcasenumber").toString();
        }
        if (bibtex.getField("series") != null) {
            this.bibTex_Series = bibtex.getField("series").toString();
        }
        if (bibtex.getField("abstract") != null) {
            this.bibTex_Abstract = bibtex.getField("abstract").toString();
        }
        if (bibtex.getField("keywords") != null) {
            this.bibTex_KeyWords = bibtex.getField("keywords").toString();
        }
        if (bibtex.getField("crossref") != null) {
            this.bibTex_CrossRef = bibtex.getField("crossref").toString();
        }
        if (bibtex.getField("howpublished") != null) {
            this.bibTex_HowPublished = bibtex.getField("howpublished").toString();
        }
        if (bibtex.getField("affiliation") != null) {
            this.bibTex_Affiliation = bibtex.getField("affiliation").toString();
        }
        if (bibtex.getField("contents") != null) {
            this.bibTex_Contents = bibtex.getField("contents").toString();
        }
        if (bibtex.getField("copyright") != null) {
            this.bibTex_Copyright = bibtex.getField("copyright").toString();
        }
        if (bibtex.getField("price") != null) {
            this.bibTex_Price = bibtex.getField("price").toString();
        }
        if (bibtex.getField("size") != null) {
            this.bibTex_Size = bibtex.getField("size").toString();
        }
        if (bibtex.getField("author") != null) {
            this.authors = this.getAuthors(bibtex.getField("author").toString());
        }
        if (bibtex.getField("editor") != null) {
            this.editors = this.getAuthors(bibtex.getField("editor").toString());
        }
    }

    private String format(String value) {
        if (value == null) {
            return null;
        }
        String result = null;
        XMLChars chars = new XMLChars();
        result = chars.format(value);
        return result;
    }

    protected int getLCID(String language) {
        int iLCID = 0;
        return iLCID;
    }

    protected String getLanguage(int LCID) {
        String language = "english";
        return language;
    }

    protected List<PersonName> getSpecificAuthors(String type, Element authors, String _bcol) {
        LinkedList<PersonName> result = null;
        NodeList nodeLst = authors.getElementsByTagName(_bcol + type);
        if (nodeLst.getLength() <= 0) {
            return result;
        }
        if ((nodeLst = ((Element)nodeLst.item(0)).getElementsByTagName(_bcol + "NameList")).getLength() <= 0) {
            return result;
        }
        NodeList person = ((Element)nodeLst.item(0)).getElementsByTagName(_bcol + "Person");
        if (person.getLength() <= 0) {
            return result;
        }
        result = new LinkedList<PersonName>();
        for (int i = 0; i < person.getLength(); ++i) {
            NodeList firstName = ((Element)person.item(i)).getElementsByTagName(_bcol + "First");
            NodeList lastName = ((Element)person.item(i)).getElementsByTagName(_bcol + "Last");
            NodeList middleName = ((Element)person.item(i)).getElementsByTagName(_bcol + "Middle");
            PersonName name = new PersonName();
            if (firstName.getLength() > 0) {
                name.setFirstname(firstName.item(0).getTextContent());
            }
            if (middleName.getLength() > 0) {
                name.setMiddlename(middleName.item(0).getTextContent());
            }
            if (lastName.getLength() > 0) {
                name.setSurname(lastName.item(0).getTextContent());
            }
            result.add(name);
        }
        return result;
    }

    protected void getAuthors(Element authorsElem, String _bcol) {
        this.authors = this.getSpecificAuthors("Author", authorsElem, _bcol);
        this.bookAuthors = this.getSpecificAuthors("BookAuthor", authorsElem, _bcol);
        this.editors = this.getSpecificAuthors("Editor", authorsElem, _bcol);
        this.translators = this.getSpecificAuthors("Translator", authorsElem, _bcol);
        this.producerNames = this.getSpecificAuthors("ProducerName", authorsElem, _bcol);
        this.composers = this.getSpecificAuthors("Composer", authorsElem, _bcol);
        this.conductors = this.getSpecificAuthors("Conductor", authorsElem, _bcol);
        this.performers = this.getSpecificAuthors("Performer", authorsElem, _bcol);
        this.writers = this.getSpecificAuthors("Writer", authorsElem, _bcol);
        this.directors = this.getSpecificAuthors("Director", authorsElem, _bcol);
        this.compilers = this.getSpecificAuthors("Compiler", authorsElem, _bcol);
        this.interviewers = this.getSpecificAuthors("Interviewer", authorsElem, _bcol);
        this.interviewees = this.getSpecificAuthors("Interviewee", authorsElem, _bcol);
        this.inventors = this.getSpecificAuthors("Inventor", authorsElem, _bcol);
        this.counsels = this.getSpecificAuthors("Counsel", authorsElem, _bcol);
    }

    protected List<PersonName> getAuthors(String authors) {
        LinkedList<PersonName> result = new LinkedList<PersonName>();
        if (authors.indexOf(" and ") == -1) {
            result.add(new PersonName(authors));
        } else {
            String[] names = authors.split(" and ");
            for (int i = 0; i < names.length; ++i) {
                result.add(new PersonName(names[i]));
            }
        }
        return result;
    }

    protected String getDate(BibtexEntry bibtex) {
        String result = "";
        if (bibtex.getField("year") != null) {
            result = result + bibtex.getField("year").toString();
        }
        if (bibtex.getField("month") != null) {
            result = result + "-" + bibtex.getField("month").toString();
        }
        return result;
    }

    protected String getMSBibSourceType(BibtexEntry bibtex) {
        String bibtexType = bibtex.getType().getName();
        String result = "Misc";
        if (bibtexType.equalsIgnoreCase("book")) {
            result = "Book";
        } else if (bibtexType.equalsIgnoreCase("inbook")) {
            result = "BookSection";
        } else if (bibtexType.equalsIgnoreCase("booklet")) {
            result = "BookSection";
            this.bibTexEntry = "booklet";
        } else if (bibtexType.equalsIgnoreCase("incollection")) {
            result = "BookSection";
            this.bibTexEntry = "incollection";
        } else if (bibtexType.equalsIgnoreCase("article")) {
            result = "JournalArticle";
        } else if (bibtexType.equalsIgnoreCase("inproceedings")) {
            result = "ConferenceProceedings";
        } else if (bibtexType.equalsIgnoreCase("conference")) {
            result = "ConferenceProceedings";
            this.bibTexEntry = "conference";
        } else if (bibtexType.equalsIgnoreCase("proceedings")) {
            result = "ConferenceProceedings";
            this.bibTexEntry = "proceedings";
        } else if (bibtexType.equalsIgnoreCase("collection")) {
            result = "ConferenceProceedings";
            this.bibTexEntry = "collection";
        } else if (bibtexType.equalsIgnoreCase("techreport")) {
            result = "Report";
        } else if (bibtexType.equalsIgnoreCase("manual")) {
            result = "Report";
            this.bibTexEntry = "manual";
        } else if (bibtexType.equalsIgnoreCase("mastersthesis")) {
            result = "Report";
            this.bibTexEntry = "mastersthesis";
        } else if (bibtexType.equalsIgnoreCase("phdthesis")) {
            result = "Report";
            this.bibTexEntry = "phdthesis";
        } else if (bibtexType.equalsIgnoreCase("unpublished")) {
            result = "Report";
            this.bibTexEntry = "unpublished";
        } else if (bibtexType.equalsIgnoreCase("patent")) {
            result = "Patent";
        } else if (bibtexType.equalsIgnoreCase("misc")) {
            result = "Misc";
        }
        return result;
    }

    public Node getDOMrepresentation() {
        Element result = null;
        try {
            DocumentBuilder d = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            result = this.getDOMrepresentation(d.newDocument());
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return result;
    }

    public void addField(Document d, Element parent, String name, String value) {
        if (value == null) {
            return;
        }
        Element elem = d.createElement("b:" + name);
        elem.appendChild(d.createTextNode(this.stripNonValidXMLCharacters(value)));
        parent.appendChild(elem);
    }

    public void addAuthor(Document d, Element allAuthors, String entryName, List<PersonName> authorsLst) {
        if (authorsLst == null) {
            return;
        }
        Element authorTop = d.createElement("b:" + entryName);
        Element nameList = d.createElement("b:NameList");
        for (PersonName name : authorsLst) {
            Element person = d.createElement("b:Person");
            this.addField(d, person, "Last", name.getSurname());
            this.addField(d, person, "Middle", name.getMiddlename());
            this.addField(d, person, "First", name.getFirstname());
            nameList.appendChild(person);
        }
        authorTop.appendChild(nameList);
        allAuthors.appendChild(authorTop);
    }

    public void addAdrress(Document d, Element parent, String address) {
        if (address == null) {
            return;
        }
        Pattern p = Pattern.compile("\\b(\\w+)\\s*[,]?\\s*(\\w+)\\s*[,]?\\s*(\\w+)\\b");
        Matcher m = p.matcher(address);
        if (m.matches() && m.groupCount() > 3) {
            this.addField(d, parent, "City", m.group(1));
            this.addField(d, parent, "StateProvince", m.group(2));
            this.addField(d, parent, "CountryRegion", m.group(3));
        }
    }

    public void addDate(Document d, Element parent, String date, String extra) {
        if (date == null) {
            return;
        }
        Pattern p = Pattern.compile("(\\d{1,2})\\s*[.,-/]\\s*(\\d{1,2})\\s*[.,-/]\\s*(\\d{2,4})");
        Matcher m = p.matcher(date);
        if (m.matches() && m.groupCount() > 3) {
            this.addField(d, parent, "Month" + extra, m.group(1));
            this.addField(d, parent, "Day" + extra, m.group(2));
            this.addField(d, parent, "Year" + extra, m.group(3));
        }
    }

    public Element getDOMrepresentation(Document d) {
        try {
            Element msbibEntry = d.createElement("b:Source");
            this.addField(d, msbibEntry, "SourceType", this.sourceType);
            this.addField(d, msbibEntry, "BIBTEX_Entry", this.bibTexEntry);
            this.addField(d, msbibEntry, "Tag", this.tag);
            this.addField(d, msbibEntry, "GUID", this.GUID);
            if (this.LCID >= 0) {
                this.addField(d, msbibEntry, "LCID", Integer.toString(this.LCID));
            }
            this.addField(d, msbibEntry, "Title", this.title);
            this.addField(d, msbibEntry, "Year", this.year);
            this.addField(d, msbibEntry, "ShortTitle", this.shortTitle);
            this.addField(d, msbibEntry, "Comments", this.comments);
            Element allAuthors = d.createElement("b:Author");
            this.addAuthor(d, allAuthors, "Author", this.authors);
            this.addAuthor(d, allAuthors, "BookAuthor", this.bookAuthors);
            this.addAuthor(d, allAuthors, "Editor", this.editors);
            this.addAuthor(d, allAuthors, "Translator", this.translators);
            this.addAuthor(d, allAuthors, "ProducerName", this.producerNames);
            this.addAuthor(d, allAuthors, "Composer", this.composers);
            this.addAuthor(d, allAuthors, "Conductor", this.conductors);
            this.addAuthor(d, allAuthors, "Performer", this.performers);
            this.addAuthor(d, allAuthors, "Writer", this.writers);
            this.addAuthor(d, allAuthors, "Director", this.directors);
            this.addAuthor(d, allAuthors, "Compiler", this.compilers);
            this.addAuthor(d, allAuthors, "Interviewer", this.interviewers);
            this.addAuthor(d, allAuthors, "Interviewee", this.interviewees);
            this.addAuthor(d, allAuthors, "Inventor", this.inventors);
            this.addAuthor(d, allAuthors, "Counsel", this.counsels);
            msbibEntry.appendChild(allAuthors);
            if (this.pages != null) {
                this.addField(d, msbibEntry, "Pages", this.pages.toString("-"));
            }
            this.addField(d, msbibEntry, "Volume", this.volume);
            this.addField(d, msbibEntry, "NumberVolumes", this.numberOfVolumes);
            this.addField(d, msbibEntry, "Edition", this.edition);
            this.addField(d, msbibEntry, "StandardNumber", this.standardNumber);
            this.addField(d, msbibEntry, "Publisher", this.publisher);
            this.addAdrress(d, msbibEntry, this.address);
            this.addField(d, msbibEntry, "BookTitle", this.bookTitle);
            this.addField(d, msbibEntry, "ChapterNumber", this.chapterNumber);
            this.addField(d, msbibEntry, "JournalName", this.journalName);
            this.addField(d, msbibEntry, "Issue", this.issue);
            this.addField(d, msbibEntry, "PeriodicalTitle", this.periodicalTitle);
            this.addField(d, msbibEntry, "ConferenceName", this.conferenceName);
            this.addField(d, msbibEntry, "Department", this.department);
            this.addField(d, msbibEntry, "Institution", this.institution);
            this.addField(d, msbibEntry, "ThesisType", this.thesisType);
            this.addField(d, msbibEntry, "InternetSiteTitle", this.internetSiteTitle);
            this.addDate(d, msbibEntry, this.dateAccessed, "Accessed");
            this.addField(d, msbibEntry, "URL", this.url);
            this.addField(d, msbibEntry, "ProductionCompany", this.productionCompany);
            this.addField(d, msbibEntry, "PublicationTitle", this.publicationTitle);
            this.addField(d, msbibEntry, "Medium", this.medium);
            this.addField(d, msbibEntry, "AlbumTitle", this.albumTitle);
            this.addField(d, msbibEntry, "RecordingNumber", this.recordingNumber);
            this.addField(d, msbibEntry, "Theater", this.theater);
            this.addField(d, msbibEntry, "Distributor", this.distributor);
            this.addField(d, msbibEntry, "BroadcastTitle", this.broadcastTitle);
            this.addField(d, msbibEntry, "Broadcaster", this.broadcaster);
            this.addField(d, msbibEntry, "Station", this.station);
            this.addField(d, msbibEntry, "Type", this.type);
            this.addField(d, msbibEntry, "PatentNumber", this.patentNumber);
            this.addField(d, msbibEntry, "Court", this.court);
            this.addField(d, msbibEntry, "Reporter", this.reporter);
            this.addField(d, msbibEntry, "CaseNumber", this.caseNumber);
            this.addField(d, msbibEntry, "AbbreviatedCaseNumber", this.abbreviatedCaseNumber);
            this.addField(d, msbibEntry, "BIBTEX_Series", this.bibTex_Series);
            this.addField(d, msbibEntry, "BIBTEX_Abstract", this.bibTex_Abstract);
            this.addField(d, msbibEntry, "BIBTEX_KeyWords", this.bibTex_KeyWords);
            this.addField(d, msbibEntry, "BIBTEX_CrossRef", this.bibTex_CrossRef);
            this.addField(d, msbibEntry, "BIBTEX_HowPublished", this.bibTex_HowPublished);
            this.addField(d, msbibEntry, "BIBTEX_Affiliation", this.bibTex_Affiliation);
            this.addField(d, msbibEntry, "BIBTEX_Contents", this.bibTex_Contents);
            this.addField(d, msbibEntry, "BIBTEX_Copyright", this.bibTex_Copyright);
            this.addField(d, msbibEntry, "BIBTEX_Price", this.bibTex_Price);
            this.addField(d, msbibEntry, "BIBTEX_Size", this.bibTex_Size);
            return msbibEntry;
        }
        catch (Exception e) {
            System.out.println("Exception caught..." + e);
            e.printStackTrace();
            throw new Error(e);
        }
    }

    protected void parseSingleStandardNumber(String type, String bibtype, String standardNum, HashMap<String, String> hm) {
        Pattern p = Pattern.compile(":" + type + ":(.[^:]+)");
        Matcher m = p.matcher(standardNum);
        if (m.matches()) {
            hm.put(bibtype, m.group(1));
        }
    }

    protected void parseStandardNumber(String standardNum, HashMap<String, String> hm) {
        if (this.standardNumber == null) {
            return;
        }
        this.parseSingleStandardNumber("ISBN", "ISBN", standardNum, hm);
        this.parseSingleStandardNumber("ISSN", "ISSN", standardNum, hm);
        this.parseSingleStandardNumber("LCCN", "LCCN", standardNum, hm);
        this.parseSingleStandardNumber("MRN", "mrnumber", standardNum, hm);
    }

    public void addAuthor(HashMap<String, String> hm, String type, List<PersonName> authorsLst) {
        if (authorsLst == null) {
            return;
        }
        String allAuthors = "";
        boolean First2 = true;
        for (PersonName name : authorsLst) {
            if (!First2) {
                allAuthors = allAuthors + " and ";
            }
            allAuthors = allAuthors + name.getFullname();
            First2 = false;
        }
        hm.put(type, allAuthors);
    }

    public BibtexEntryType mapMSBibToBibtexType(String msbib) {
        BibtexEntryType bibtex = BibtexEntryType.OTHER;
        bibtex = msbib.equals("Book") ? BibtexEntryType.BOOK : (msbib.equals("BookSection") ? BibtexEntryType.INBOOK : (msbib.equals("JournalArticle") ? BibtexEntryType.ARTICLE : (msbib.equals("ArticleInAPeriodical") ? BibtexEntryType.ARTICLE : (msbib.equals("ConferenceProceedings") ? BibtexEntryType.CONFERENCE : (msbib.equals("Report") ? BibtexEntryType.TECHREPORT : (msbib.equals("InternetSite") ? BibtexEntryType.OTHER : (msbib.equals("DocumentFromInternetSite") ? BibtexEntryType.OTHER : (msbib.equals("DocumentFromInternetSite") ? BibtexEntryType.OTHER : (msbib.equals("ElectronicSource") ? BibtexEntryType.OTHER : (msbib.equals("Art") ? BibtexEntryType.OTHER : (msbib.equals("SoundRecording") ? BibtexEntryType.OTHER : (msbib.equals("Performance") ? BibtexEntryType.OTHER : (msbib.equals("Film") ? BibtexEntryType.OTHER : (msbib.equals("Interview") ? BibtexEntryType.OTHER : (msbib.equals("Patent") ? BibtexEntryType.OTHER : (msbib.equals("Case") ? BibtexEntryType.OTHER : (msbib.equals("Misc") ? BibtexEntryType.MISC : BibtexEntryType.MISC)))))))))))))))));
        return bibtex;
    }

    public BibtexEntry getBibtexRepresentation() {
        BibtexEntry entry = null;
        entry = this.tag == null ? new BibtexEntry("__ID", this.mapMSBibToBibtexType(this.sourceType)) : new BibtexEntry(this.tag, this.mapMSBibToBibtexType(this.sourceType));
        HashMap<String, String> hm = new HashMap<String, String>();
        if (this.tag != null) {
            hm.put("bibtexkey", this.tag);
        }
        if (this.LCID >= 0) {
            hm.put("language", this.getLanguage(this.LCID));
        }
        if (this.title != null) {
            hm.put("title", this.title);
        }
        if (this.year != null) {
            hm.put("year", this.year);
        }
        if (this.shortTitle != null) {
            hm.put("msbib-shorttitle", this.shortTitle);
        }
        if (this.comments != null) {
            hm.put("note", this.comments);
        }
        this.addAuthor(hm, "author", this.authors);
        this.addAuthor(hm, "msbib-bookauthor", this.bookAuthors);
        this.addAuthor(hm, "editor", this.editors);
        this.addAuthor(hm, "msbib-translator", this.translators);
        this.addAuthor(hm, "msbib-producername", this.producerNames);
        this.addAuthor(hm, "msbib-composer", this.composers);
        this.addAuthor(hm, "msbib-conductor", this.conductors);
        this.addAuthor(hm, "msbib-performer", this.performers);
        this.addAuthor(hm, "msbib-writer", this.writers);
        this.addAuthor(hm, "msbib-director", this.directors);
        this.addAuthor(hm, "msbib-compiler", this.compilers);
        this.addAuthor(hm, "msbib-interviewer", this.interviewers);
        this.addAuthor(hm, "msbib-interviewee", this.interviewees);
        this.addAuthor(hm, "msbib-inventor", this.inventors);
        this.addAuthor(hm, "msbib-counsel", this.counsels);
        if (this.pages != null) {
            hm.put("pages", this.pages.toString("--"));
        }
        if (this.volume != null) {
            hm.put("volume", this.volume);
        }
        if (this.numberOfVolumes != null) {
            hm.put("msbib-numberofvolume", this.numberOfVolumes);
        }
        if (this.edition != null) {
            hm.put("edition", this.edition);
        }
        if (this.edition != null) {
            hm.put("edition", this.edition);
        }
        this.parseStandardNumber(this.standardNumber, hm);
        if (this.publisher != null) {
            hm.put("publisher", this.publisher);
        }
        if (this.publisher != null) {
            hm.put("publisher", this.publisher);
        }
        if (this.address != null) {
            hm.put("address", this.address);
        }
        if (this.bookTitle != null) {
            hm.put("booktitle", this.bookTitle);
        }
        if (this.chapterNumber != null) {
            hm.put("chapter", this.chapterNumber);
        }
        if (this.journalName != null) {
            hm.put("journal", this.journalName);
        }
        if (this.issue != null) {
            hm.put("number", this.issue);
        }
        if (this.periodicalTitle != null) {
            hm.put("organization", this.periodicalTitle);
        }
        if (this.conferenceName != null) {
            hm.put("organization", this.conferenceName);
        }
        if (this.department != null) {
            hm.put("school", this.department);
        }
        if (this.institution != null) {
            hm.put("institution", this.institution);
        }
        if (this.dateAccessed != null) {
            hm.put("msbib-accessed", this.dateAccessed);
        }
        if (this.url != null) {
            hm.put("url", this.url);
        }
        if (this.productionCompany != null) {
            hm.put("msbib-productioncompany", this.productionCompany);
        }
        if (this.medium != null) {
            hm.put("msbib-medium", this.medium);
        }
        if (this.recordingNumber != null) {
            hm.put("msbib-recordingnumber", this.recordingNumber);
        }
        if (this.theater != null) {
            hm.put("msbib-theater", this.theater);
        }
        if (this.distributor != null) {
            hm.put("msbib-distributor", this.distributor);
        }
        if (this.broadcaster != null) {
            hm.put("msbib-broadcaster", this.broadcaster);
        }
        if (this.station != null) {
            hm.put("msbib-station", this.station);
        }
        if (this.type != null) {
            hm.put("msbib-type", this.type);
        }
        if (this.patentNumber != null) {
            hm.put("msbib-patentnumber", this.patentNumber);
        }
        if (this.court != null) {
            hm.put("msbib-court", this.court);
        }
        if (this.reporter != null) {
            hm.put("msbib-reporter", this.reporter);
        }
        if (this.caseNumber != null) {
            hm.put("msbib-casenumber", this.caseNumber);
        }
        if (this.abbreviatedCaseNumber != null) {
            hm.put("msbib-abbreviatedcasenumber", this.abbreviatedCaseNumber);
        }
        if (this.bibTex_Series != null) {
            hm.put("series", this.bibTex_Series);
        }
        if (this.bibTex_Abstract != null) {
            hm.put("abstract", this.bibTex_Abstract);
        }
        if (this.bibTex_KeyWords != null) {
            hm.put("keywords", this.bibTex_KeyWords);
        }
        if (this.bibTex_CrossRef != null) {
            hm.put("crossref", this.bibTex_CrossRef);
        }
        if (this.bibTex_HowPublished != null) {
            hm.put("howpublished", this.bibTex_HowPublished);
        }
        if (this.bibTex_Affiliation != null) {
            hm.put("affiliation", this.bibTex_Affiliation);
        }
        if (this.bibTex_Contents != null) {
            hm.put("contents", this.bibTex_Contents);
        }
        if (this.bibTex_Copyright != null) {
            hm.put("copyright", this.bibTex_Copyright);
        }
        if (this.bibTex_Price != null) {
            hm.put("price", this.bibTex_Price);
        }
        if (this.bibTex_Size != null) {
            hm.put("size", this.bibTex_Size);
        }
        entry.setField(hm);
        return entry;
    }

    public String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public String toString() {
        StringWriter sresult = new StringWriter();
        try {
            DOMSource source = new DOMSource(this.getDOMrepresentation());
            StreamResult result = new StreamResult(sresult);
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.transform(source, result);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return sresult.toString();
    }
}

