/*
 * Decompiled with CFR 0.152.
 */
package spl.gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import org.sciplore.xml.XmlDocuments;
import spl.DocumentsWrapper;
import spl.SplWebClient;
import spl.listener.LabelLinkListener;
import spl.localization.LocalizationSupport;

public class MetaDataListDialog
extends JDialog {
    private JPanel contentPane;
    private JTable tableMetadata;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JScrollPane scrollPane;
    private JPanel panelWait;
    private JLabel labelFetch;
    private JLabel iconLabel;
    private JButton blankButton;
    private JLabel labelLogo;
    private JButton moreInformationButton;
    private JPanel panelMetadata;
    private DefaultTableModel tableModel;
    private int result;
    private XmlDocuments xmlDocuments;
    private String fileName;
    private SplWebClient.WebServiceStatus webserviceStatus;
    private Component thisDialog;
    private boolean showBlankButton;

    public MetaDataListDialog(String fileName, boolean showBlankButton) {
        this.$$$setupUI$$$();
        this.setText();
        this.showBlankButton = showBlankButton;
        this.thisDialog = this;
        this.fileName = fileName;
        this.labelLogo.addMouseListener(new LabelLinkListener(this.labelLogo, "www.mr-dlib.org"));
        this.setTitle(LocalizationSupport.message("Mr._dLib_Metadata_Entries_Associated_With_PDF_File"));
        this.tableMetadata.setSelectionMode(0);
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaDataListDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaDataListDialog.this.onCancel();
            }
        });
        this.blankButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaDataListDialog.this.onBlank();
            }
        });
        this.moreInformationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaDataListDialog.this.onInfo();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MetaDataListDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaDataListDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.scrollPane.setVisible(false);
        this.blankButton.setVisible(false);
        this.moreInformationButton.setVisible(true);
        this.setSize(616, 366);
    }

    private void onInfo() {
        try {
            Util.openExternalViewer(new MetaData(), "http://www.mr-dlib.org/docs/jabref_metadata_extraction_alpha.php", "url");
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    private void onBlank() {
        this.result = 1;
        this.dispose();
    }

    private void onOK() {
        this.result = 0;
        this.dispose();
    }

    private void onCancel() {
        this.result = 2;
        this.dispose();
    }

    public void showDialog() {
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                System.out.println("Starting Webclient...");
                MetaDataListDialog.this.webserviceStatus = SplWebClient.getMetaData(new File(MetaDataListDialog.this.fileName));
                return null;
            }

            @Override
            public void done() {
                if (MetaDataListDialog.this.webserviceStatus == SplWebClient.WebServiceStatus.OK) {
                    MetaDataListDialog.this.xmlDocuments = SplWebClient.metadata;
                    if (MetaDataListDialog.this.xmlDocuments != null && MetaDataListDialog.this.xmlDocuments.getDocuments() != null && MetaDataListDialog.this.xmlDocuments.getDocuments().size() > 0) {
                        DocumentsWrapper documents = new DocumentsWrapper(MetaDataListDialog.this.xmlDocuments);
                        List<Vector> vectorList = documents.getDocuments();
                        for (Vector vector : vectorList) {
                            MetaDataListDialog.this.tableModel.addRow(vector);
                        }
                        MetaDataListDialog.this.tableMetadata.getSelectionModel().setSelectionInterval(0, 0);
                        MetaDataListDialog.this.panelWait.setVisible(false);
                        MetaDataListDialog.this.scrollPane.setVisible(true);
                        MetaDataListDialog.this.moreInformationButton.setVisible(true);
                    } else {
                        MetaDataListDialog.this.iconLabel.setVisible(false);
                        MetaDataListDialog.this.labelFetch.setText(LocalizationSupport.message("No_metadata_found."));
                        MetaDataListDialog.this.blankButton.setVisible(MetaDataListDialog.this.showBlankButton);
                    }
                }
                if (MetaDataListDialog.this.webserviceStatus == SplWebClient.WebServiceStatus.NO_METADATA) {
                    MetaDataListDialog.this.iconLabel.setVisible(false);
                    MetaDataListDialog.this.labelFetch.setText(LocalizationSupport.message("No_metadata_found."));
                    MetaDataListDialog.this.blankButton.setVisible(MetaDataListDialog.this.showBlankButton);
                }
                if (MetaDataListDialog.this.webserviceStatus == SplWebClient.WebServiceStatus.UNAVAILABLE) {
                    MetaDataListDialog.this.iconLabel.setVisible(false);
                    MetaDataListDialog.this.labelFetch.setText(LocalizationSupport.message("Mr._dLib_web_service_is_temporarily_unavailable."));
                    MetaDataListDialog.this.blankButton.setVisible(MetaDataListDialog.this.showBlankButton);
                }
                if (MetaDataListDialog.this.webserviceStatus == SplWebClient.WebServiceStatus.OUTDATED) {
                    MetaDataListDialog.this.iconLabel.setVisible(false);
                    MetaDataListDialog.this.labelFetch.setText(LocalizationSupport.message("The_Mr._dLib_web_service_version_you_trying_to_access_is_outdated."));
                    MetaDataListDialog.this.blankButton.setVisible(MetaDataListDialog.this.showBlankButton);
                    JOptionPane.showMessageDialog(MetaDataListDialog.this.thisDialog, LocalizationSupport.message("This_JabRef_version_is_trying_to_access_an_old_version_of_Mr._dLib's_webservice_that_is_not_working_any_more.\\nPlease_visit_http://jabref.sourceforge.net_or_http://www.mr-dlib.org_for_more_information_and_updates.\\n\\n\\n"), LocalizationSupport.message("Web_Service_Version_Outdated"), 1);
                }
                if (MetaDataListDialog.this.webserviceStatus == SplWebClient.WebServiceStatus.WEBSERVICE_DOWN) {
                    MetaDataListDialog.this.iconLabel.setVisible(false);
                    MetaDataListDialog.this.labelFetch.setText(LocalizationSupport.message("Mr._dLib_web_service_is_temporarily_down._Please_try_again_later."));
                    MetaDataListDialog.this.blankButton.setVisible(MetaDataListDialog.this.showBlankButton);
                }
                if (MetaDataListDialog.this.webserviceStatus == SplWebClient.WebServiceStatus.NO_INTERNET) {
                    MetaDataListDialog.this.iconLabel.setVisible(false);
                    MetaDataListDialog.this.labelFetch.setText(LocalizationSupport.message("No_Internet_Connection."));
                    MetaDataListDialog.this.blankButton.setVisible(MetaDataListDialog.this.showBlankButton);
                    JOptionPane.showMessageDialog(MetaDataListDialog.this.thisDialog, LocalizationSupport.message("You_are_not_connected_to_the_Internet._To_access_Mr._dLib_web_service_an_internet_connection_is_needed."), LocalizationSupport.message("No_Internet_Connection."), 1);
                }
            }
        };
        worker.execute();
        this.pack();
        this.setVisible(true);
    }

    public XmlDocuments getXmlDocuments() {
        return this.xmlDocuments;
    }

    private void createUIComponents() {
        this.tableModel = new MyTableModel();
        this.tableModel.addColumn(LocalizationSupport.message("Title"));
        this.tableModel.addColumn(LocalizationSupport.message("Author(s)"));
        this.tableModel.addColumn(LocalizationSupport.message("Published_Year"));
        this.tableMetadata = new JTable(this.tableModel);
    }

    public JTable getTableMetadata() {
        return this.tableMetadata;
    }

    public int getResult() {
        return this.result;
    }

    public JButton getBlankButton() {
        return this.blankButton;
    }

    private void setText() {
        this.buttonOK.setText(LocalizationSupport.message("Ok"));
        this.buttonCancel.setText(LocalizationSupport.message("Cancel"));
        this.blankButton.setText(LocalizationSupport.message("Create_new_blank_entry"));
        this.moreInformationButton.setText(LocalizationSupport.message("More_Information"));
        this.panelMetadata.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LocalizationSupport.message("Metadata")));
        this.labelFetch.setText(LocalizationSupport.message("Fetching_Metadata..."));
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel1, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(3, 5, 0, 0), -1, -1));
        panel2.setBackground(new Color(-1));
        panel1.add((Component)panel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.labelLogo = new JLabel();
        this.labelLogo.setIcon(new ImageIcon(this.getClass().getResource("/spl/gui/mrdlib header.png")));
        this.labelLogo.setText("");
        panel2.add((Component)this.labelLogo, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.panelMetadata = new JPanel();
        this.panelMetadata.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(5, 5, 10, 5), -1, -1));
        panel1.add((Component)this.panelMetadata, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, new Dimension(600, 200), new Dimension(600, 200), null, 0, false));
        this.panelMetadata.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null));
        this.scrollPane = new JScrollPane();
        this.panelMetadata.add((Component)this.scrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.scrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null));
        this.tableMetadata.setAutoCreateRowSorter(false);
        this.tableMetadata.setEnabled(true);
        this.tableMetadata.setFillsViewportHeight(true);
        this.tableMetadata.setShowVerticalLines(true);
        this.scrollPane.setViewportView(this.tableMetadata);
        this.panelWait = new JPanel();
        this.panelWait.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.panelWait.setBackground(new Color(-1));
        this.panelMetadata.add((Component)this.panelWait, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.panelWait.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null));
        this.iconLabel = new JLabel();
        this.iconLabel.setBackground(new Color(-1));
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setHorizontalTextPosition(11);
        this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/spl/gui/ajax-loader.gif")));
        this.iconLabel.setText("");
        this.panelWait.add((Component)this.iconLabel, new GridConstraints(0, 0, 1, 1, 0, 3, 4, 4, null, null, null, 0, false));
        this.labelFetch = new JLabel();
        this.labelFetch.setFont(new Font(this.labelFetch.getFont().getName(), this.labelFetch.getFont().getStyle(), 13));
        this.labelFetch.setText("");
        this.panelWait.add((Component)this.labelFetch, new GridConstraints(1, 0, 1, 1, 1, 0, 0, 0, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 1, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel3.add((Component)spacer1, new GridConstraints(0, 0, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 10, 10), -1, -1));
        panel3.add((Component)panel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.buttonOK = new JButton();
        this.buttonOK.setText("");
        panel4.add((Component)this.buttonOK, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.buttonCancel = new JButton();
        this.buttonCancel.setText("");
        panel4.add((Component)this.buttonCancel, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.blankButton = new JButton();
        this.blankButton.setText("");
        panel4.add((Component)this.blankButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.moreInformationButton = new JButton();
        this.moreInformationButton.setText("");
        panel4.add((Component)this.moreInformationButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel1.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.iconLabel.setLabelFor(this.scrollPane);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    public class MyTableModel
    extends DefaultTableModel {
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

