/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sciplore.resources.Document;
import org.sciplore.resources.Resource;
import org.sciplore.resources.User;

@Entity
@Table(name="alerts")
public class Alert
extends Resource {
    @ManyToOne
    @JoinColumn(name="document_id", nullable=false)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Document document;
    @Column(nullable=false)
    private Short frequency;
    @Column(nullable=false)
    private Boolean fulltextAvailable;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(nullable=false)
    private Integer id;
    @Column(nullable=false)
    private Boolean metadataChanges;
    @Column(nullable=false)
    private Boolean newUsageData;
    @Column(nullable=false)
    private Boolean relatedDocuments;
    @ManyToOne
    @JoinColumn(name="user_id", nullable=false)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private User user;
    @Column(nullable=false)
    private Short valid = 1;

    public Alert getAlert(Alert a) {
        if (a.getId() != null) {
            return this.getAlert(a.getId());
        }
        return this.getAlert(a.getUser(), a.getDocument());
    }

    public Alert getAlert(Integer id) {
        return (Alert)this.getSession().get(Alert.class, (Serializable)id);
    }

    public Alert getAlert(User u, Document d) {
        if (u == null || u.getId() == null || d == null || d.getId() == null) {
            return null;
        }
        return (Alert)this.getSession().createCriteria(Alert.class).add((Criterion)Restrictions.eq((String)"user", (Object)u)).add((Criterion)Restrictions.eq((String)"document", (Object)d)).setMaxResults(1).uniqueResult();
    }

    public Alert() {
    }

    public Alert(Session s) {
        this.setSession(s);
    }

    public Document getDocument() {
        return this.document;
    }

    public Short getFrequency() {
        return this.frequency;
    }

    public Boolean getFulltextAvailable() {
        return this.fulltextAvailable;
    }

    public Integer getId() {
        return this.id;
    }

    public Boolean getMetadataChanges() {
        return this.metadataChanges;
    }

    public Boolean getNewUsageData() {
        return this.newUsageData;
    }

    public Boolean getRelatedDocuments() {
        return this.relatedDocuments;
    }

    public User getUser() {
        return this.user;
    }

    public Short getValid() {
        return this.valid;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setFrequency(Short frequency) {
        this.frequency = frequency;
    }

    public void setFulltextAvailable(Boolean fulltextAvailable) {
        this.fulltextAvailable = fulltextAvailable;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setMetadataChanges(Boolean metadataChanges) {
        this.metadataChanges = metadataChanges;
    }

    public void setNewUsageData(Boolean newUsageData) {
        this.newUsageData = newUsageData;
    }

    public void setRelatedDocuments(Boolean relatedDocuments) {
        this.relatedDocuments = relatedDocuments;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setValid(Short valid) {
        this.valid = valid;
    }
}

