/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sciplore.resources.Resource;
import org.sciplore.tools.Tools;

@Entity
@Table(name="venues")
public class Venue
extends Resource {
    public static final short VENUE_TYPE_JOURNAL = 1;
    public static final short VENUE_TYPE_CONFERENCE = 2;
    public static final short VENUE_TYPE_BOOK = 3;
    public static final short VENUE_TYPE_PROCEEDINGS = 4;
    public static final short VENUE_TYPE_MISC = 5;
    private String abbreviation;
    private String address;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @Column(nullable=false)
    private String name = "";
    private Short type;
    @Column(nullable=false)
    private Short valid = 1;

    public Venue getVenue(Venue v) {
        if (v.getId() != null) {
            return this.getVenue(v.getId());
        }
        return this.getVenue(v.getName());
    }

    public Venue getVenue(Integer id) {
        return (Venue)this.getSession().get(Venue.class, (Serializable)id);
    }

    public Venue getVenue(String name) {
        return (Venue)this.getSession().createCriteria(Venue.class).add((Criterion)Restrictions.like((String)"name", (Object)name)).setMaxResults(1).uniqueResult();
    }

    public Venue sync(Venue venue) {
        Venue v = this.getVenue(venue);
        if (v == null) {
            v = venue;
        } else {
            if (Tools.empty(v.getAbbreviation()) && !Tools.empty(venue.getAbbreviation())) {
                v.setAbbreviation(venue.getAbbreviation());
            }
            if (Tools.empty(v.getAddress()) && !Tools.empty(venue.getAddress())) {
                v.setAddress(venue.getAddress());
            }
            if (Tools.empty(v.getId()) && !Tools.empty(venue.getId())) {
                v.setId(venue.getId());
            }
            if (Tools.empty(v.getName()) && !Tools.empty(venue.getName())) {
                v.setName(venue.getName());
            }
            if (Tools.empty(v.getType()) && !Tools.empty(venue.getType())) {
                v.setType(venue.getType());
            }
            if (Tools.empty(v.getValid()) && !Tools.empty(venue.getValid())) {
                v.setValid(venue.getValid());
            }
        }
        return v;
    }

    public Venue() {
    }

    public Venue(Session s) {
        this.setSession(s);
    }

    public Venue(Session s, String name) {
        this.setSession(s);
        this.name = name;
    }

    public Venue(Session s, String name, Short type) {
        this.setSession(s);
        this.name = name;
        this.type = type;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getAddress() {
        return this.address;
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Short getType() {
        return this.type;
    }

    public Short getValid() {
        return this.valid;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public void setValid(Short valid) {
        this.valid = valid;
    }
}

