/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.xml;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.sciplore.resources.Application;

@XmlRootElement(name="application")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="application", propOrder={"name", "version", "versionStatus", "releaseNote", "priority"})
public class XmlApplication {
    public static final int STABLE = 1;
    public static final int RELEASE_CANDIDATE = 2;
    public static final int BETA = 3;
    private String name;
    private String version;
    private int versionStatus;
    private String releaseNote;
    private int priority;

    public XmlApplication() {
    }

    public XmlApplication(Application app) {
        this.setName(app.getName());
        this.setVersion(app.getVersion());
        this.setVersionStatus(app.getVersionStatus().shortValue());
        this.setReleaseNote(app.getReleaseNote());
        this.setPriority(app.getPriority().shortValue());
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getVersionStatus() {
        return this.versionStatus;
    }

    public String getVersionStatusAsString() {
        switch (this.versionStatus) {
            case 1: {
                return "stable";
            }
            case 2: {
                return "release candidate";
            }
            case 3: {
                return "beta";
            }
        }
        return null;
    }

    public void setVersionStatus(int versionStatus) {
        this.versionStatus = versionStatus;
    }

    public String getReleaseNote() {
        return this.releaseNote;
    }

    public void setReleaseNote(String releaseNote) {
        this.releaseNote = releaseNote;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getXML() throws JAXBException {
        StringWriter stringWriter = new StringWriter();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{this.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.marshal((Object)this, (Writer)stringWriter);
        return stringWriter.getBuffer().toString();
    }
}

