/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.GlyphNameMap;
import de.intarsys.pdf.font.CMapRangeMap;
import java.util.Iterator;

public class CMapBFRangeNameArrayMap
extends CMapRangeMap {
    private final int[] destinationCodes;
    private final COSArray names;

    public CMapBFRangeNameArrayMap(byte[] start, byte[] end, COSArray names) {
        super(start, end);
        this.names = names;
        this.destinationCodes = new int[names.size()];
        int i = 0;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            COSName name = ((COSObject)it.next()).asName();
            this.destinationCodes[i] = name == null ? 0 : GlyphNameMap.Standard.getUnicode(((COSObject)name).stringValue());
            ++i;
        }
    }

    public char[] toChars(int codepoint) {
        int index = codepoint - this.start;
        if (index < 0 || index >= this.destinationCodes.length) {
            return null;
        }
        return new char[]{(char)this.destinationCodes[index]};
    }

    public int toCID(int codepoint) {
        int index = codepoint - this.start;
        if (index < 0 || index >= this.destinationCodes.length) {
            return 0;
        }
        return this.destinationCodes[index];
    }

    public int toCodepoint(int cid) {
        int i = 0;
        while (i < this.destinationCodes.length) {
            if (cid == this.destinationCodes[i]) {
                return this.start + i;
            }
            ++i;
        }
        return 0;
    }
}

