/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageTree;
import java.util.List;

public abstract class PDPageNode
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_Parent = COSName.constant("Parent");
    public static final COSName CN_Type_Pages = COSName.constant("Pages");
    public static final COSName CN_Type_Page = COSName.constant("Page");
    public static final COSName DK_Rotate = COSName.constant("Rotate");
    private PDPageTree cachedParent;
    private CDSRectangle cachedCropBox;

    protected PDPageNode(COSObject object) {
        super(object);
    }

    protected abstract void collectAnnotations(List var1);

    @Deprecated
    public void dispose() {
        PDPageTree parent = this.getParent();
        if (parent != null) {
            parent.removeNode(this);
        }
    }

    public abstract int getCount();

    public CDSRectangle getCropBox() {
        if (this.cachedCropBox == null) {
            COSArray array = this.cosGetFieldInheritable(PDPage.DK_CropBox).asArray();
            this.cachedCropBox = array == null ? this.getMediaBox() : CDSRectangle.createFromCOS(array);
        }
        return this.cachedCropBox;
    }

    public PDAnnotation getFirstAnnotation() {
        PDPage currentPage = this.getFirstPage();
        while (currentPage != null) {
            PDAnnotation annotation = currentPage.getFirstAnnotation();
            if (annotation != null) {
                return annotation;
            }
            currentPage = currentPage.getNextPage();
        }
        return null;
    }

    public abstract PDPageNode getFirstNode();

    public abstract PDPage getFirstPage();

    public PDObject getGenericParent() {
        return this.getParent();
    }

    public PDAnnotation getLastAnnotation() {
        PDPage currentPage = this.getLastPage();
        while (currentPage != null) {
            PDAnnotation annotation = currentPage.getLastAnnotation();
            if (annotation != null) {
                return annotation;
            }
            currentPage = currentPage.getPreviousPage();
        }
        return null;
    }

    public abstract PDPageNode getLastNode();

    public abstract PDPage getLastPage();

    public CDSRectangle getMediaBox() {
        COSArray array = this.cosGetFieldInheritable(PDPage.DK_MediaBox).asArray();
        if (array == null) {
            this.setMediaBox(new CDSRectangle(CDSRectangle.SIZE_A4));
            array = (COSArray)this.cosGetField(PDPage.DK_MediaBox);
        }
        return CDSRectangle.createFromCOS(array);
    }

    public PDPageNode getNextNode() {
        PDPageTree tree = this.getParent();
        if (tree == null) {
            return null;
        }
        return tree.getNextNode(this);
    }

    public int getNodeIndex() {
        PDPageTree myParent = this.getParent();
        if (myParent == null) {
            return 0;
        }
        return myParent.getNodeIndex(this);
    }

    public PDPage getPageAt(int index) {
        if (index >= this.getCount()) {
            PDPageNode next = this.getNextNode();
            if (next == null) {
                return null;
            }
            return next.getPageAt(index - this.getCount());
        }
        if (index < 0) {
            PDPageNode previous = this.getPreviousNode();
            if (previous == null) {
                return null;
            }
            return previous.getPageAt(previous.getCount() + index);
        }
        PDPageNode first = this.getFirstNode();
        if (first == null) {
            return null;
        }
        return first.getPageAt(index);
    }

    public PDPageTree getParent() {
        COSDictionary parentDict;
        if (this.cachedParent == null && (parentDict = this.cosGetField(DK_Parent).asDictionary()) != null) {
            this.cachedParent = (PDPageTree)META.createFromCos(parentDict);
        }
        return this.cachedParent;
    }

    public PDPageNode getPreviousNode() {
        PDPageTree tree = this.getParent();
        if (tree == null) {
            return null;
        }
        return tree.getPreviousNode(this);
    }

    public int getRotate() {
        COSInteger rotate = this.cosGetFieldInheritable(DK_Rotate).asInteger();
        if (rotate == null) {
            return 0;
        }
        return rotate.intValue();
    }

    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedParent = null;
        this.cachedCropBox = null;
    }

    public abstract boolean isPage();

    public abstract boolean isValid();

    public void setCropBox(CDSRectangle rect) {
        this.setFieldObject(PDPage.DK_CropBox, rect);
    }

    public void setGenericParent(PDObject newParent) {
        if (!(newParent instanceof PDPageTree)) {
            throw new IllegalArgumentException("parent must be a PDPAgeTree");
        }
        this.setParent((PDPageTree)newParent);
    }

    public void setMediaBox(CDSRectangle rect) {
        this.setFieldObject(PDPage.DK_MediaBox, rect);
    }

    protected void setParent(PDPageTree parent) {
        this.setFieldObject(DK_Parent, parent);
    }

    public void setRotate(int rotate) {
        COSObject inheritedObject;
        COSInteger newObject = COSInteger.create(rotate);
        if (((Object)newObject).equals(inheritedObject = this.cosGetFieldInherited(DK_Rotate))) {
            this.cosSetFieldInheritable(DK_Rotate, null);
        } else if (inheritedObject.isNull() && rotate == 0) {
            this.cosSetFieldInheritable(DK_Rotate, null);
        } else {
            this.cosSetFieldInheritable(DK_Rotate, newObject);
        }
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        protected COSBasedObject.MetaClass doDetermineClass(COSObject object) {
            COSName type = ((COSDictionary)object).get(DK_Type).asName();
            if (CN_Type_Pages.equals(type)) {
                return PDPageTree.META;
            }
            return PDPage.META;
        }

        public Class getRootClass() {
            return PDPageNode.class;
        }
    }
}

