/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.listeners;

import freemind.controller.MindMapNodesSelection;
import freemind.main.Resources;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.view.mindmapview.MainView;
import freemind.view.mindmapview.NodeView;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import splmm.Actions.SmartImportBookmarksAction;
import splmm.BookmarkMindMapNode;
import splmm.Gui.Transferable.NodeTransferable;
import splmm.Preferences.SplmmPreferences;
import splmm.SplmmAttributes;

public class MindMapNodeDropListener
implements DropTargetListener {
    private final MindMapController mMindMapController;

    public MindMapNodeDropListener(MindMapController controller) {
        this.mMindMapController = controller;
    }

    private boolean isDragAcceptable(DropTargetDragEvent ev) {
        if (ev.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return true;
        }
        if (ev.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor)) {
            return true;
        }
        return ev.isDataFlavorSupported(NodeTransferable.splmmNodeFlavor);
    }

    private boolean isDropAcceptable(DropTargetDropEvent event) {
        MindMapNode node = ((MainView)event.getDropTargetContext().getComponent()).getNodeView().getModel();
        MindMapNode selected = this.mMindMapController.getSelected();
        if (!node.isWriteable()) {
            return false;
        }
        return node != selected && !node.isDescendantOf(selected);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void drop(DropTargetDropEvent dtde) {
        block24: {
            try {
                Transferable trans;
                MindMapNode targetNode;
                NodeView targetNodeView;
                MainView mainView;
                int dropAction;
                block28: {
                    List selecteds;
                    block27: {
                        List<Object> fileList;
                        block26: {
                            MindMapNodeModel targetNodeModel;
                            block25: {
                                dropAction = dtde.getDropAction();
                                Transferable t = dtde.getTransferable();
                                mainView = (MainView)dtde.getDropTargetContext().getComponent();
                                targetNodeView = mainView.getNodeView();
                                targetNode = targetNodeView.getModel();
                                targetNodeModel = (MindMapNodeModel)targetNode;
                                if (dtde.isLocalTransfer() && t.isDataFlavorSupported(NodeTransferable.splmmNodeFlavor)) {
                                    List nodes = (List)t.getTransferData(NodeTransferable.splmmNodeFlavor);
                                    Iterator i$ = nodes.iterator();
                                    while (true) {
                                        if (!i$.hasNext()) {
                                            dtde.dropComplete(true);
                                            mainView.setDraggedOver(0);
                                            mainView.repaint();
                                            return;
                                        }
                                        MindMapNode node = (MindMapNode)i$.next();
                                        ArrayList<MindMapNode> tempList = new ArrayList<MindMapNode>();
                                        tempList.add(node);
                                        if (dtde.getDropAction() == 2) {
                                            Transferable transferable = this.mMindMapController.cut(tempList);
                                            this.mMindMapController.getView().selectAsTheOnlyOneSelected(targetNodeView);
                                            this.mMindMapController.paste(transferable, targetNode, mainView.dropAsSibling(dtde.getLocation().getX()), mainView.dropPosition(dtde.getLocation().getX()));
                                        }
                                        if (dtde.getDropAction() != 1) continue;
                                        Transferable transferable = this.mMindMapController.copy(tempList, true);
                                        this.mMindMapController.getView().selectAsTheOnlyOneSelected(targetNodeView);
                                        this.mMindMapController.paste(transferable, targetNode, mainView.dropAsSibling(dtde.getLocation().getX()), mainView.dropPosition(dtde.getLocation().getX()));
                                    }
                                }
                                if (dtde.isLocalTransfer() && t.isDataFlavorSupported(MindMapNodesSelection.dropActionFlavor)) {
                                    String sourceAction = (String)t.getTransferData(MindMapNodesSelection.dropActionFlavor);
                                    if (sourceAction.equals("LINK")) {
                                        dropAction = 0x40000000;
                                    }
                                    if (sourceAction.equals("COPY")) {
                                        dropAction = 1;
                                    }
                                }
                                mainView.setDraggedOver(0);
                                mainView.repaint();
                                if (dtde.isLocalTransfer() && dropAction == 2 && !this.isDropAcceptable(dtde)) {
                                    dtde.rejectDrop();
                                    return;
                                }
                                dtde.acceptDrop(dtde.getDropAction());
                                if (dtde.isLocalTransfer() && !dtde.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor)) break block25;
                                fileList = new ArrayList();
                                if (t.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor)) {
                                    fileList = (List)t.getTransferData(MindMapNodesSelection.fileListFlavor);
                                } else if (t.isDataFlavorSupported(MindMapNodesSelection.uriListFlavor)) {
                                    fileList = MindMapNodesSelection.textURIListToFileList((String)t.getTransferData(MindMapNodesSelection.uriListFlavor));
                                }
                                ArrayList nodes = new ArrayList();
                                if (fileList.size() <= 0) {
                                    this.mMindMapController.paste(t, targetNode, mainView.dropAsSibling(dtde.getLocation().getX()), mainView.dropPosition(dtde.getLocation().getX()));
                                    dtde.dropComplete(true);
                                    return;
                                }
                                break block26;
                            }
                            if (dropAction == 0x40000000) {
                                MindMapMapModel mindMapMapModel = (MindMapMapModel)this.mMindMapController.getModel();
                                int yesorno = 0;
                                if (this.mMindMapController.getView().getSelecteds().size() >= 5) {
                                    yesorno = JOptionPane.showConfirmDialog(this.mMindMapController.getFrame().getContentPane(), this.mMindMapController.getText("lots_of_links_warning"), Integer.toString(this.mMindMapController.getView().getSelecteds().size()) + " links to the same node", 0);
                                }
                                if (yesorno == 0) {
                                    ListIterator it = this.mMindMapController.getView().getSelecteds().listIterator();
                                    while (it.hasNext()) {
                                        MindMapNodeModel selectedNodeModel = (MindMapNodeModel)((NodeView)it.next()).getModel();
                                        this.mMindMapController.addLink(selectedNodeModel, targetNodeModel);
                                    }
                                }
                                break block24;
                            }
                            if (!targetNode.isWriteable()) {
                                String message = this.mMindMapController.getText("node_is_write_protected");
                                JOptionPane.showMessageDialog(this.mMindMapController.getFrame().getContentPane(), message, "Freemind", 0);
                                return;
                            }
                            trans = null;
                            selecteds = this.mMindMapController.getSelecteds();
                            if (2 == dropAction) break block27;
                            trans = this.mMindMapController.copy();
                            break block28;
                        }
                        Iterator<Object> i$ = fileList.iterator();
                        while (true) {
                            if (!i$.hasNext()) {
                                dtde.dropComplete(true);
                                return;
                            }
                            File file = (File)i$.next();
                            String dateiendung = file.getPath().substring(file.getPath().lastIndexOf("."));
                            Boolean hasPDFendung = dateiendung.substring(1).equalsIgnoreCase("pdf");
                            if (hasPDFendung.booleanValue() && SplmmPreferences.getAutoImport().booleanValue()) {
                                SmartImportBookmarksAction smartImportBookmarksAction = new SmartImportBookmarksAction(this.mMindMapController);
                                smartImportBookmarksAction.importBookmarks(file, targetNode, true);
                                continue;
                            }
                            BookmarkMindMapNode node = new BookmarkMindMapNode(file, file.getName(), this.mMindMapController.getController(), SplmmAttributes.LinkType.document);
                            if (node == null) continue;
                            this.mMindMapController.paste(node, targetNode);
                        }
                    }
                    MindMapNode actualNode = targetNode;
                    do {
                        if (!selecteds.contains(actualNode)) continue;
                        String message = this.mMindMapController.getText("cannot_move_to_child");
                        JOptionPane.showMessageDialog(this.mMindMapController.getFrame().getContentPane(), message, "Freemind", 2);
                        dtde.dropComplete(true);
                        return;
                    } while ((actualNode = actualNode.isRoot() ? null : actualNode.getParentNode()) != null);
                    trans = this.mMindMapController.cut();
                }
                this.mMindMapController.getView().selectAsTheOnlyOneSelected(targetNodeView);
                boolean result = this.mMindMapController.paste(trans, targetNode, mainView.dropAsSibling(dtde.getLocation().getX()), mainView.dropPosition(dtde.getLocation().getX()));
                if (!result && 2 != dropAction) {
                    // empty if block
                }
            }
            catch (Exception e) {
                System.err.println("Drop exception:" + e);
                Resources.getInstance().logException(e);
                dtde.dropComplete(false);
                return;
            }
        }
        dtde.dropComplete(true);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            dtde.acceptDrag(2);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        boolean repaint;
        MainView draggedNode = (MainView)e.getDropTargetContext().getComponent();
        int oldDraggedOver = draggedNode.getDraggedOver();
        draggedNode.setDraggedOver(e.getLocation());
        int newDraggedOver = draggedNode.getDraggedOver();
        boolean bl = repaint = newDraggedOver != oldDraggedOver;
        if (repaint) {
            draggedNode.repaint();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        MainView draggedNode = (MainView)e.getDropTargetContext().getComponent();
        draggedNode.setDraggedOver(0);
        draggedNode.repaint();
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }
}

