/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import splmm.BibTex;
import splmm.BookmarkMindMapNode;
import splmm.FileFilter.DirectoryFileFilter;
import splmm.FileFilter.MonDirFileFilter;
import splmm.FileFilter.PdfFileFilter;
import splmm.Preferences.SplmmPreferences;
import splmm.SciPloreUtils;
import splmm.SplmmAttributes;

public abstract class SplmmAbstractAction
extends AbstractAction {
    public MindMapController controller;
    protected PdfFileFilter pdfFilter = new PdfFileFilter();
    protected MindMapNode selected;
    protected HashMap<String, Collection<BibTex>> bibTexMap;
    protected int newFileCounter;
    protected List<MindMapNode> newFileNodes = new ArrayList<MindMapNode>();
    protected List<NodePair> newBookmarkNodes = new ArrayList<NodePair>();

    public SplmmAbstractAction(String name, MindMapController controller) {
        super(name);
        this.controller = controller;
    }

    protected boolean isLinkedToPDF(MindMapNode node) {
        String link = SciPloreUtils.getLink(node, this.controller.getController());
        if (link == null) {
            return false;
        }
        if (!link.contains(".")) {
            return false;
        }
        String dateiendung = link.substring(link.lastIndexOf("."));
        Boolean hasPDFendung = dateiendung.substring(1).equalsIgnoreCase("pdf");
        if (hasPDFendung.booleanValue()) {
            File file = this.getFileFromLink(node);
            return file != null && file.exists();
        }
        return false;
    }

    protected boolean isLinkedToMonDirFile(MindMapNode node) {
        MonDirFileFilter filter = new MonDirFileFilter();
        String link = SciPloreUtils.getLink(node, this.controller.getController());
        if (filter.accept(link)) {
            File file = this.getFileFromLink(node);
            return file != null && file.exists();
        }
        return false;
    }

    protected File getFileFromLink(MindMapNode node) {
        File pdfFile;
        block16: {
            pdfFile = new File(SciPloreUtils.getLink(node, this.controller.getController()));
            if (!pdfFile.isAbsolute()) {
                pdfFile = new File(this.controller.getModel().getFile().getParent() + "\\\\" + node.getLink());
                if (pdfFile.exists()) {
                    try {
                        return pdfFile.getCanonicalFile();
                    }
                    catch (Exception e) {
                        SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                        break block16;
                    }
                }
                try {
                    URI uri = new URI("file:/" + node.getLink());
                    pdfFile = new File(uri);
                    pdfFile = new File(this.controller.getModel().getFile().getParent() + pdfFile.getPath());
                    if (pdfFile.exists()) {
                        try {
                            return pdfFile.getCanonicalFile();
                        }
                        catch (IOException e) {
                            SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                            break block16;
                        }
                    }
                    try {
                        uri = new URI(node.getLink());
                        pdfFile = new File(uri);
                        if (pdfFile.exists()) {
                            try {
                                return pdfFile.getCanonicalFile();
                            }
                            catch (IOException e) {
                                SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                            }
                        }
                    }
                    catch (Exception e) {
                        SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                    }
                }
                catch (Exception e) {
                    SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                }
            }
        }
        try {
            return pdfFile.getCanonicalFile();
        }
        catch (Exception e) {
            SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
            return null;
        }
    }

    public void importBookmarks(MindMapNode node, boolean allBookmarks) {
        File pdfFile;
        if (this.isLinkedToPDF(node) && (pdfFile = this.getFileFromLink(node)).exists()) {
            this.bibTexMap = BookmarkMindMapNode.ReadBibtexFile();
            MindMapNode bookmarkNode = BookmarkMindMapNode.getBookmarksFromFile(pdfFile, this.controller.getController(), this.bibTexMap);
            if (allBookmarks) {
                if (bookmarkNode != null && bookmarkNode.hasChildren()) {
                    List children = bookmarkNode.getChildren();
                    for (MindMapNode child : children) {
                        this.controller.paste(child, node);
                    }
                }
            } else {
                Map<String, Collection<MindMapNode>> nodesLinkedToFile = this.getPdfFileLinkedNodes(pdfFile, this.controller.getRootNode(), new HashMap<String, Collection<MindMapNode>>());
                if (bookmarkNode != null && bookmarkNode.hasChildren() && this.hasNewChildren(bookmarkNode, nodesLinkedToFile)) {
                    List children = bookmarkNode.getChildren();
                    for (MindMapNode child : children) {
                        this.pasteNodeDirect(child, node);
                    }
                }
            }
            if (node.getSPLMMAttributes() == null) {
                node.setSPLMMAttributes(new SplmmAttributes());
            }
            node.getSPLMMAttributes().setBookmarksUpdated(new Date());
        }
    }

    public void importBookmarks(File pdfFile, MindMapNode target, boolean allBookmarks) {
        PdfFileFilter pdfFilter = new PdfFileFilter();
        if (pdfFilter.accept(pdfFile) && pdfFile.exists()) {
            this.bibTexMap = BookmarkMindMapNode.ReadBibtexFile();
            MindMapNode bookmarkNode = BookmarkMindMapNode.getBookmarksFromFile(pdfFile, this.controller.getController(), this.bibTexMap);
            if (allBookmarks) {
                if (bookmarkNode != null) {
                    this.controller.paste(bookmarkNode, target);
                }
            } else {
                Map<String, Collection<MindMapNode>> nodesLinkedToFile = this.getPdfFileLinkedNodes(pdfFile, this.controller.getRootNode(), new HashMap<String, Collection<MindMapNode>>());
                if (bookmarkNode != null) {
                    this.hasNewChildren(bookmarkNode, nodesLinkedToFile);
                    this.controller.paste(bookmarkNode, target);
                }
            }
        }
    }

    protected void importNewBookMarks(List<File> filesFromMonDir, Map<String, Collection<MindMapNode>> nodesLinkedToMonFiles) throws InvocationTargetException, InterruptedException {
        this.firePropertyChange("watchFolder", "", "Updating Files");
        for (File file : filesFromMonDir) {
            MindMapNode bookmarkNode = BookmarkMindMapNode.getBookmarksFromFile(file, this.controller.getController(), this.bibTexMap);
            if (bookmarkNode == null || !this.hasNewChildren(bookmarkNode, nodesLinkedToMonFiles)) continue;
            this.importNewNodes(bookmarkNode, this.selected);
        }
    }

    private void pasteNodeDirect(MindMapNode node, MindMapNode target) {
        List targetChildren = target.getChildren();
        boolean isNewNode = true;
        for (MindMapNode targetChild : targetChildren) {
            String targetChildLink = SciPloreUtils.getLink(targetChild, this.controller.getController());
            String nodeLink = SciPloreUtils.getLink(node, this.controller.getController());
            if (!targetChild.getText().equals(node.getText()) || !targetChildLink.equals(nodeLink)) continue;
            List nodeChildren = node.getChildren();
            for (MindMapNode nodeChild : nodeChildren) {
                this.pasteNodeDirect(nodeChild, targetChild);
            }
            isNewNode = false;
            break;
        }
        if (isNewNode) {
            this.controller.paste(node, target);
            this.controller.getController().getMapModule().getView().repaintSelecteds();
        }
    }

    private void importNewNodes(MindMapNode node, MindMapNode target) throws InvocationTargetException, InterruptedException {
        List targetChildren = target.getChildren();
        boolean isNewNode = true;
        for (MindMapNode targetChild : targetChildren) {
            String targetChildLink = SciPloreUtils.getLink(targetChild, this.controller.getController());
            String nodeLink = SciPloreUtils.getLink(node, this.controller.getController());
            if (!targetChild.getText().equals(node.getText()) || !targetChildLink.equals(nodeLink)) continue;
            List nodeChildren = node.getChildren();
            for (MindMapNode nodeChild : nodeChildren) {
                this.importNewNodes(nodeChild, targetChild);
            }
            isNewNode = false;
            break;
        }
        if (isNewNode) {
            this.newBookmarkNodes.add(new NodePair(target, node));
        }
    }

    private boolean hasNewChildren(MindMapNode node, Map<String, Collection<MindMapNode>> oldNodes) {
        boolean hasNewChildren = false;
        ArrayList<MindMapNode> removableChildren = new ArrayList<MindMapNode>();
        List children = node.getChildren();
        for (MindMapNode child : children) {
            if (this.isNewChild(child, oldNodes)) {
                hasNewChildren = true;
                continue;
            }
            if (this.hasNewChildren(child, oldNodes)) {
                hasNewChildren = true;
                continue;
            }
            removableChildren.add(child);
        }
        for (MindMapNode removableChild : removableChildren) {
            node.remove(removableChild);
        }
        return hasNewChildren;
    }

    private boolean isNewChild(MindMapNode child, Map<String, Collection<MindMapNode>> oldNodes) {
        File linkedFile;
        Collection<MindMapNode> values;
        if (child.getLink() != null && !child.getLink().isEmpty() && (values = oldNodes.get((linkedFile = this.getFileFromLink(child)).getAbsolutePath())) != null) {
            for (MindMapNode value : values) {
                String nodeTitle = value.getText();
                String childTitle = child.getText();
                nodeTitle = nodeTitle.replaceAll("\r", "");
                nodeTitle = nodeTitle.replaceAll("\n", "");
                nodeTitle = nodeTitle.replaceAll("\t", " ");
                nodeTitle = nodeTitle.trim();
                childTitle = childTitle.replaceAll("\r", "");
                childTitle = childTitle.replaceAll("\n", "");
                childTitle = childTitle.replaceAll("\t", " ");
                childTitle = childTitle.trim();
                String valueLink = SciPloreUtils.getLink(value, this.controller.getController());
                String childLink = SciPloreUtils.getLink(child, this.controller.getController());
                if (!nodeTitle.equals(childTitle) || !valueLink.equals(childLink)) continue;
                return false;
            }
        }
        return true;
    }

    protected List<File> removeUpToDateFiles(List<File> filesFromMonDir, Map<String, Collection<MindMapNode>> nodesLinkedToMonFiles) {
        this.firePropertyChange("watchFolder", "", "Removing Not Changed Files");
        ArrayList<File> upToDateFiles = new ArrayList<File>();
        block0: for (File file : filesFromMonDir) {
            Collection<MindMapNode> linkedNodes = nodesLinkedToMonFiles.get(file.getAbsolutePath());
            if (linkedNodes == null) continue;
            for (MindMapNode linkedNode : linkedNodes) {
                Date monDirFileLastModified = new Date(file.lastModified());
                SplmmAttributes splmmAttributes = linkedNode.getSPLMMAttributes();
                if (splmmAttributes == null || splmmAttributes.getBookmarksUpdated() == null || splmmAttributes.getBookmarksUpdated().before(monDirFileLastModified)) continue;
                upToDateFiles.add(file);
                continue block0;
            }
        }
        filesFromMonDir.removeAll(upToDateFiles);
        return filesFromMonDir;
    }

    protected List<File> removeImportedFiles(List<File> filesFromMonDir, List<File> parsedFiles) {
        this.firePropertyChange("watchFolder", "", "Removing Parsed Files");
        filesFromMonDir.removeAll(parsedFiles);
        ArrayList<File> nonPdfFiles = new ArrayList<File>();
        Iterator<File> i$ = filesFromMonDir.iterator();
        while (i$.hasNext()) {
            PdfFileFilter pdfFilter = new PdfFileFilter();
            File file = i$.next();
            if (pdfFilter.accept(file)) continue;
            nonPdfFiles.add(file);
        }
        filesFromMonDir.removeAll(nonPdfFiles);
        return filesFromMonDir;
    }

    protected List<File> importNewMonDirFiles(Map<String, Collection<MindMapNode>> nodesLinkedToMonFiles, List<File> filesFromMonDir) throws InvocationTargetException, InterruptedException {
        this.firePropertyChange("watchFolder", "", "Importing New Files");
        ArrayList<File> importedFiles = new ArrayList<File>();
        for (File file : filesFromMonDir) {
            if (nodesLinkedToMonFiles.containsKey(file.getAbsolutePath())) continue;
            importedFiles.add(file);
            this.importNewFile(file);
        }
        return importedFiles;
    }

    private void importNewFile(File file) throws InterruptedException, InvocationTargetException {
        ++this.newFileCounter;
        MindMapNode node = this.pdfFilter.accept(file) ? this.ImportBookmarksFromFile(file, this.bibTexMap) : new BookmarkMindMapNode(file, file.getName(), this.controller.getController(), SplmmAttributes.LinkType.document);
        if (node != null) {
            this.newFileNodes.add(node);
        }
    }

    protected List<File> getMonDirFiles(File directory) {
        if (!directory.isDirectory()) {
            return new ArrayList<File>();
        }
        this.firePropertyChange("watchFolder", "", "Scanning for File in Monitoring Directory");
        ArrayList<File> monDirFiles = new ArrayList<File>();
        File[] files = directory.listFiles(new MonDirFileFilter());
        monDirFiles.addAll(Arrays.asList(files));
        if (this.isImportSubfolder(this.selected)) {
            File[] directories;
            for (File dir : directories = directory.listFiles(new DirectoryFileFilter())) {
                monDirFiles.addAll(this.getMonDirFiles(dir));
            }
        }
        return monDirFiles;
    }

    protected Map<String, Collection<MindMapNode>> getMonFileLinkedNodes(MindMapNode node, Map<String, Collection<MindMapNode>> nodes) {
        this.firePropertyChange("watchFolder", "", "Scanning for Nodes linked to File");
        if (this.isLinkedToMonDirFile(node) && nodes != null && node.getLink() != null && !node.getLink().isEmpty()) {
            File linkedFile = this.getFileFromLink(node);
            Collection<MindMapNode> values = nodes.get(linkedFile.getAbsolutePath());
            if (values == null) {
                values = new ArrayList<MindMapNode>();
                nodes.put(linkedFile.getAbsolutePath(), values);
            }
            values.add(node);
        }
        List children = node.getChildren();
        for (MindMapNode child : children) {
            nodes = this.getMonFileLinkedNodes(child, nodes);
        }
        return nodes;
    }

    protected Map<String, Collection<MindMapNode>> getPdfFileLinkedNodes(File file, MindMapNode node, Map<String, Collection<MindMapNode>> nodes) {
        if (this.isLinkedToPDF(node) && nodes != null && node.getLink() != null && !node.getLink().isEmpty()) {
            File linkedFile = this.getFileFromLink(node);
            if (file.getAbsolutePath().equals(file.getAbsolutePath())) {
                Collection<MindMapNode> values = nodes.get(linkedFile.getAbsolutePath());
                if (values == null) {
                    values = new ArrayList<MindMapNode>();
                    nodes.put(linkedFile.getAbsolutePath(), values);
                }
                values.add(node);
            }
        }
        List children = node.getChildren();
        for (MindMapNode child : children) {
            nodes = this.getMonFileLinkedNodes(child, nodes);
        }
        return nodes;
    }

    protected MindMapNode ImportBookmarksFromFile(File file, HashMap<String, Collection<BibTex>> bibTexMap) {
        return BookmarkMindMapNode.getBookmarksFromFile(file, this.controller.getController(), bibTexMap);
    }

    protected boolean isImportSubfolder(MindMapNode selected) {
        if (selected.getAttribute(SciPloreUtils.SPLMM_DIRMON_SUBDIRS).equalsIgnoreCase("1")) {
            return true;
        }
        return selected.getAttribute(SciPloreUtils.SPLMM_DIRMON_SUBDIRS).equalsIgnoreCase("2") && SplmmPreferences.getImportSubfolders();
    }

    protected void setAllNodesUpToDate(List<File> filesFromMonDir, Map<String, Collection<MindMapNode>> nodesLinkedToMonFiles) {
        for (File file : filesFromMonDir) {
            Collection<MindMapNode> linkedNodes = nodesLinkedToMonFiles.get(file.getAbsolutePath());
            if (linkedNodes == null) continue;
            for (MindMapNode linkedNode : linkedNodes) {
                linkedNode.getSPLMMAttributes().setBookmarksUpdated(new Date());
            }
        }
    }

    protected void pasteAllNodes() throws InterruptedException, InvocationTargetException {
        this.firePropertyChange("watchFolder", "", "Pasting new nodes...");
        for (final MindMapNode node : this.newFileNodes) {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SplmmAbstractAction.this.controller.paste(node, SplmmAbstractAction.this.selected);
                    SplmmAbstractAction.this.controller.getController().getMapModule().getView().repaintSelecteds();
                }
            });
        }
        for (final NodePair nodePair : this.newBookmarkNodes) {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SplmmAbstractAction.this.controller.paste(nodePair.getPasteNode(), nodePair.getTarget());
                    SplmmAbstractAction.this.controller.getController().getMapModule().getView().repaintSelecteds();
                }
            });
        }
        this.firePropertyChange("MyTask", "", (Object)SwingWorker.StateValue.DONE);
    }

    public class NodePair {
        private MindMapNode target;
        private MindMapNode pasteNode;

        public NodePair(MindMapNode target, MindMapNode pasteNode) {
            this.target = target;
            this.pasteNode = pasteNode;
        }

        public MindMapNode getTarget() {
            return this.target;
        }

        public void setTarget(MindMapNode target) {
            this.target = target;
        }

        public MindMapNode getPasteNode() {
            return this.pasteNode;
        }

        public void setPasteNode(MindMapNode pasteNode) {
            this.pasteNode = pasteNode;
        }
    }

    public class PasteTask
    extends SwingWorker<Void, Void> {
        private MindMapNode node;

        public PasteTask(MindMapNode node) {
            this.node = node;
        }

        @Override
        protected Void doInBackground() throws Exception {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SplmmAbstractAction.this.controller.paste(PasteTask.this.node, SplmmAbstractAction.this.selected);
                    SplmmAbstractAction.this.controller.getController().getMapModule().getView().repaintSelecteds();
                }
            });
            return null;
        }
    }
}

