/*
 * Decompiled with CFR 0.152.
 */
package bibtex.expansions;

import bibtex.dom.BibtexFile;
import bibtex.dom.BibtexPerson;
import bibtex.dom.BibtexPersonList;
import bibtex.dom.BibtexString;
import bibtex.expansions.BibtexPersonListParserTests;
import bibtex.expansions.PersonListParserException;
import java.util.LinkedList;
import java.util.List;

final class BibtexPersonListParser {
    private static final String COMMA;
    private static final String AND;
    private static final String MINUS;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("bibtex.expansions.BibtexPersonListParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        COMMA = ",".intern();
        AND = "and".intern();
        MINUS = "-".intern();
    }

    BibtexPersonListParser() {
    }

    public static BibtexPersonList parse(BibtexString personList, String entryKey) throws PersonListParserException {
        String content = personList.getContent();
        String[] tokens = BibtexPersonListParser.tokenize(content);
        BibtexPersonList result = personList.getOwnerFile().makePersonList();
        if (tokens.length == 0) {
            return result;
        }
        int begin = 0;
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].toLowerCase().equals(AND) && begin < i) {
                result.add(BibtexPersonListParser.makePerson(tokens, begin, i, content, entryKey, personList.getOwnerFile()));
                begin = i + 1;
            }
            ++i;
        }
        if (begin < tokens.length) {
            result.add(BibtexPersonListParser.makePerson(tokens, begin, tokens.length, content, entryKey, personList.getOwnerFile()));
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean firstCharAtBracelevel0IsLowerCase(String string) {
        stringIt = new StringIterator(string);
        if (!Character.isLowerCase(stringIt.current())) ** GOTO lbl60
        return true;
lbl-1000:
        // 1 sources

        {
            block19: {
                block20: {
                    stringIt.skipWhiteSpace();
                    if (Character.isLowerCase(stringIt.current())) {
                        return true;
                    }
                    if (Character.isUpperCase(stringIt.current())) {
                        return false;
                    }
                    if (stringIt.current() != '{') break block19;
                    stringIt.step();
                    stringIt.skipWhiteSpace();
                    if (stringIt.current() != '\\') break block20;
                    while (true) {
                        stringIt.step();
                        stringIt.skipWhiteSpace();
                        if (!Character.isLetter(stringIt.current())) ** GOTO lbl37
                        while (stringIt.hasNext() && stringIt.current() != '{' && !Character.isWhitespace(stringIt.current()) && stringIt.current() != '}') {
                            stringIt.step();
                        }
                        stringIt.skipWhiteSpace();
                        if (!stringIt.hasNext()) {
                            return false;
                        }
                        if (stringIt.current() == '}') {
                            return false;
                        }
                        if (stringIt.current() != '{') continue;
                        stringIt.step();
                        stringIt.skipWhiteSpace();
                        if (!stringIt.hasNext()) {
                            return false;
                        }
                        if (Character.isLowerCase(stringIt.current())) {
                            return true;
                        }
                        if (Character.isUpperCase(stringIt.current())) {
                            return false;
                        }
                        if (stringIt.current() != '\\') continue;
                    }
lbl-1000:
                    // 1 sources

                    {
                        stringIt.step();
lbl37:
                        // 2 sources

                        ** while (stringIt.hasNext() && !Character.isLetter((char)stringIt.current()))
                    }
lbl38:
                    // 1 sources

                    if (!stringIt.hasNext()) {
                        return false;
                    }
                    if (Character.isLowerCase(stringIt.current())) {
                        return true;
                    }
                    if (Character.isUpperCase(stringIt.current())) {
                        return false;
                    }
                    return false;
                }
                braces = 1;
                while (braces > 0) {
                    if (!stringIt.hasNext()) {
                        return false;
                    }
                    if (stringIt.current() == '{') {
                        ++braces;
                    } else if (stringIt.current() == '}') {
                        --braces;
                    }
                    stringIt.step();
                }
                continue;
            }
            stringIt.step();
lbl60:
            // 3 sources

            ** while (stringIt.hasNext())
        }
lbl61:
        // 1 sources

        return false;
    }

    private static String getString(String[] tokens, int beginIndex, int endIndex) {
        if (beginIndex >= endIndex) {
            return null;
        }
        if (!$assertionsDisabled && beginIndex < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && endIndex < 0) {
            throw new AssertionError();
        }
        StringBuffer result = new StringBuffer();
        int i = beginIndex;
        while (i < endIndex) {
            if (tokens[i] == MINUS) {
                if (i != beginIndex && i != endIndex - 1) {
                    result.append('-');
                }
            } else {
                if (i > beginIndex && tokens[i - 1] != MINUS) {
                    result.append(' ');
                }
                result.append(tokens[i]);
            }
            ++i;
        }
        return result.toString();
    }

    private static BibtexPerson makePerson(String[] tokens, int begin, int end, String fullEntry, String entryKey, BibtexFile factory) throws PersonListParserException {
        if (tokens[begin].equals("others")) {
            return factory.makePerson(null, null, null, null, true);
        }
        if (tokens[end - 1] == COMMA) {
            throw new PersonListParserException("Name ends with comma: '" + fullEntry + "' - in '" + entryKey + "'");
        }
        int numberOfCommas = 0;
        int i = begin;
        while (i < end) {
            if (tokens[i] == COMMA) {
                ++numberOfCommas;
            }
            ++i;
        }
        if (numberOfCommas == 0) {
            String preLast;
            String lineage;
            String first;
            String last;
            int lastNameBegin = end - 1;
            while (true) {
                if (lastNameBegin - 1 >= begin && !BibtexPersonListParser.firstCharAtBracelevel0IsLowerCase(tokens[lastNameBegin - 1])) {
                    --lastNameBegin;
                    continue;
                }
                if (lastNameBegin - 2 < begin || tokens[lastNameBegin - 1] != MINUS || BibtexPersonListParser.firstCharAtBracelevel0IsLowerCase(tokens[lastNameBegin - 2])) break;
                lastNameBegin -= 2;
            }
            int firstLowerCase = -1;
            int i2 = begin;
            while (i2 < end) {
                if (tokens[i2] != MINUS && BibtexPersonListParser.firstCharAtBracelevel0IsLowerCase(tokens[i2])) {
                    firstLowerCase = i2;
                    break;
                }
                ++i2;
            }
            if (lastNameBegin == begin || firstLowerCase == -1) {
                lastNameBegin = end - 1;
                while (lastNameBegin - 2 >= begin && tokens[lastNameBegin - 1] == MINUS && !BibtexPersonListParser.firstCharAtBracelevel0IsLowerCase(tokens[lastNameBegin - 2])) {
                    lastNameBegin -= 2;
                }
                last = BibtexPersonListParser.getString(tokens, lastNameBegin, end);
                first = BibtexPersonListParser.getString(tokens, begin, lastNameBegin);
                lineage = null;
                preLast = null;
            } else {
                last = BibtexPersonListParser.getString(tokens, lastNameBegin, end);
                first = BibtexPersonListParser.getString(tokens, begin, firstLowerCase);
                lineage = null;
                preLast = BibtexPersonListParser.getString(tokens, firstLowerCase, lastNameBegin);
            }
            if (last == null) {
                throw new PersonListParserException("Found an empty last name in '" + fullEntry + "' in '" + entryKey + "'.");
            }
            return factory.makePerson(first, preLast, last, lineage, false);
        }
        if (numberOfCommas == 1 || numberOfCommas == 2) {
            int preLastEnd;
            if (numberOfCommas == 1) {
                int preLastEnd2;
                int commaIndex = -1;
                int i3 = begin;
                while (i3 < end) {
                    if (tokens[i3] == COMMA) {
                        commaIndex = i3;
                        break;
                    }
                    ++i3;
                }
                int preLastBegin = begin;
                int i4 = preLastEnd2 = begin;
                while (i4 < commaIndex) {
                    if (tokens[i4] != MINUS && BibtexPersonListParser.firstCharAtBracelevel0IsLowerCase(tokens[i4])) {
                        preLastEnd2 = i4 + 1;
                    }
                    ++i4;
                }
                if (preLastEnd2 == commaIndex && preLastEnd2 > preLastBegin) {
                    --preLastEnd2;
                }
                String preLast = BibtexPersonListParser.getString(tokens, preLastBegin, preLastEnd2);
                String last = BibtexPersonListParser.getString(tokens, preLastEnd2, commaIndex);
                String first = BibtexPersonListParser.getString(tokens, commaIndex + 1, end);
                if (last == null) {
                    throw new PersonListParserException("Found an empty last name in '" + fullEntry + "' in '" + entryKey + "'.");
                }
                return factory.makePerson(first, preLast, last, null, false);
            }
            int firstComma = -1;
            int secondComma = -1;
            int i5 = begin;
            while (i5 < end) {
                if (tokens[i5] == COMMA) {
                    if (firstComma == -1) {
                        firstComma = i5;
                    } else {
                        secondComma = i5;
                        break;
                    }
                }
                ++i5;
            }
            int preLastBegin = begin;
            int i6 = preLastEnd = begin;
            while (i6 < firstComma) {
                if (tokens[i6] != MINUS && BibtexPersonListParser.firstCharAtBracelevel0IsLowerCase(tokens[i6])) {
                    preLastEnd = i6 + 1;
                }
                ++i6;
            }
            if (preLastEnd == firstComma && preLastEnd > preLastBegin) {
                --preLastEnd;
            }
            String preLast = BibtexPersonListParser.getString(tokens, preLastBegin, preLastEnd);
            String last = BibtexPersonListParser.getString(tokens, preLastEnd, firstComma);
            String lineage = BibtexPersonListParser.getString(tokens, firstComma + 1, secondComma);
            String first = BibtexPersonListParser.getString(tokens, secondComma + 1, end);
            if (first == null && lineage != null) {
                String tmp = lineage;
                lineage = first;
                first = tmp;
            }
            if (last == null) {
                throw new PersonListParserException("Found an empty last name in '" + fullEntry + "' in '" + entryKey + "'.");
            }
            return factory.makePerson(first, preLast, last, lineage, false);
        }
        throw new PersonListParserException("Too many commas in '" + fullEntry + "' in '" + entryKey + "'.");
    }

    private static String[] tokenize(String stringContent) {
        int numberOfOpenBraces = 0;
        int tokenBegin = 0;
        stringContent = String.valueOf(stringContent) + " ";
        LinkedList<String> tokens = new LinkedList<String>();
        int currentPos = 0;
        while (currentPos < stringContent.length()) {
            switch (stringContent.charAt(currentPos)) {
                case '{': {
                    ++numberOfOpenBraces;
                    break;
                }
                case '}': {
                    String potentialToken;
                    if (numberOfOpenBraces > 0) {
                        --numberOfOpenBraces;
                        break;
                    }
                    if (tokenBegin <= currentPos - 1 && !(potentialToken = stringContent.substring(tokenBegin, currentPos).trim()).equals("")) {
                        tokens.add(potentialToken);
                    }
                    tokenBegin = currentPos + 1;
                    break;
                }
                case ',': {
                    String potentialToken;
                    if (numberOfOpenBraces == 0) {
                        if (tokenBegin <= currentPos - 1 && !(potentialToken = stringContent.substring(tokenBegin, currentPos).trim()).equals("")) {
                            tokens.add(potentialToken);
                        }
                        tokens.add(COMMA);
                        tokenBegin = currentPos + 1;
                    }
                }
                default: {
                    char currentChar = stringContent.charAt(currentPos);
                    if (!Character.isWhitespace(currentChar) && currentChar != '~' && currentChar != '-' || numberOfOpenBraces != 0 || tokenBegin > currentPos) break;
                    String potentialToken = stringContent.substring(tokenBegin, currentPos).trim();
                    if (!potentialToken.equals("")) {
                        tokens.add(potentialToken);
                        if (currentChar == '-') {
                            tokens.add(MINUS);
                        }
                    }
                    tokenBegin = currentPos + 1;
                }
            }
            ++currentPos;
        }
        String[] result = new String[tokens.size()];
        tokens.toArray(result);
        return result;
    }

    private static boolean isEqual(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    private static boolean isEqual(BibtexPersonListParserTests.Test test, BibtexPerson person) {
        return BibtexPersonListParser.isEqual(test.getFirst(), person.getFirst()) && BibtexPersonListParser.isEqual(test.getLast(), person.getLast()) && BibtexPersonListParser.isEqual(test.getLineage(), person.getLineage()) && BibtexPersonListParser.isEqual(test.getPreLast(), person.getPreLast());
    }

    private static void dumpCompare(BibtexPersonListParserTests.Test test, BibtexPerson person) {
        System.out.println("test.first=\"" + test.getFirst() + "\" person.first=\"" + person.getFirst() + "\"");
        System.out.println("test.last=\"" + test.getLast() + "\" person.last=\"" + person.getLast() + "\"");
        System.out.println("test.preLast=\"" + test.getPreLast() + "\" person.preLast=\"" + person.getPreLast() + "\"");
        System.out.println("test.lineage=\"" + test.getLineage() + "\" person.lineage=\"" + person.getLineage() + "\"");
    }

    public static void main(String[] args) {
        BibtexPersonListParserTests.Test[] tests = BibtexPersonListParserTests.tests;
        int i = 0;
        while (i < tests.length) {
            block5: {
                List personList;
                BibtexFile file = new BibtexFile();
                BibtexString string = file.makeString(tests[i].getString());
                try {
                    personList = BibtexPersonListParser.parse(string, "testCase" + i).getList();
                }
                catch (PersonListParserException e) {
                    e.printStackTrace();
                    break block5;
                }
                if (!$assertionsDisabled && personList.size() != 1) {
                    throw new AssertionError();
                }
                BibtexPerson person = (BibtexPerson)personList.get(0);
                if (!BibtexPersonListParser.isEqual(tests[i], person)) {
                    System.err.println("\ntest failed:");
                    System.err.println(tests[i].getString());
                    BibtexPersonListParser.dumpCompare(tests[i], person);
                }
            }
            ++i;
        }
    }

    static final class StringIterator {
        private final char[] chars;
        private int pos;

        StringIterator(String string) {
            this.chars = string.toCharArray();
            this.pos = 0;
        }

        char next() {
            return this.chars[this.pos++];
        }

        char current() {
            return this.chars[this.pos];
        }

        void step() {
            ++this.pos;
        }

        void skipWhiteSpace() {
            while (this.pos < this.chars.length && Character.isWhitespace(this.chars[this.pos])) {
                ++this.pos;
            }
        }

        boolean hasNext() {
            return this.pos + 1 < this.chars.length;
        }
    }
}

