/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.concurrent;

import de.intarsys.tools.concurrent.ITaskListener;
import de.intarsys.tools.concurrent.ITaskListenerSupport;
import java.util.concurrent.ExecutionException;

public class TaskCallbackDispatcher
implements ITaskListenerSupport,
ITaskListener {
    private final Object owner;
    private ITaskListener[] listeners = new ITaskListener[2];

    public TaskCallbackDispatcher(Object pOwner) {
        this.owner = pOwner;
    }

    public void addTaskListener(ITaskListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener may not be null");
        }
        int length = this.listeners.length;
        int i = 0;
        while (i < length) {
            if (this.listeners[i] == null) break;
            ++i;
        }
        if (i >= length) {
            ITaskListener[] templisteners = new ITaskListener[length + 4];
            System.arraycopy(this.listeners, 0, templisteners, 0, length);
            this.listeners = templisteners;
        }
        this.listeners[i] = listener;
    }

    public synchronized void attach(ITaskListenerSupport support) {
        int length = this.listeners.length;
        int i = 0;
        while (i < length) {
            support.addTaskListener(this.listeners[i]);
            ++i;
        }
    }

    public synchronized void clear() {
        this.listeners = new ITaskListener[4];
    }

    public synchronized void detach(ITaskListenerSupport support) {
        int length = this.listeners.length;
        int i = 0;
        while (i < length) {
            support.removeTaskListener(this.listeners[i]);
            ++i;
        }
    }

    public Object getOwner() {
        return this.owner;
    }

    public synchronized boolean isEmpty() {
        int i = 0;
        while (i < this.listeners.length) {
            if (this.listeners[i] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void removeTaskListener(ITaskListener listener) {
        int length = this.listeners.length;
        int i = 0;
        while (i < length) {
            if (this.listeners[i] == listener) {
                this.listeners[i] = null;
                break;
            }
            ++i;
        }
    }

    public void taskCancelled(Object task) {
        int length = this.listeners.length;
        int i = 0;
        while (i < length) {
            ITaskListener templistener = this.listeners[i];
            if (templistener != null) {
                templistener.taskCancelled(task);
            }
            ++i;
        }
    }

    public void taskFailed(Object task, ExecutionException exception) {
        int length = this.listeners.length;
        int i = 0;
        while (i < length) {
            ITaskListener templistener = this.listeners[i];
            if (templistener != null) {
                templistener.taskFailed(task, exception);
            }
            ++i;
        }
    }

    public void taskFinished(Object task, Object result) {
        int length = this.listeners.length;
        int i = 0;
        while (i < length) {
            ITaskListener templistener = this.listeners[i];
            if (templistener != null) {
                templistener.taskFinished(task, result);
            }
            ++i;
        }
    }

    public void taskStarted(Object task) {
        int length = this.listeners.length;
        int i = 0;
        while (i < length) {
            ITaskListener templistener = this.listeners[i];
            if (templistener != null) {
                templistener.taskStarted(task);
            }
            ++i;
        }
    }
}

