/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.file.TempTools;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class FileTools {
    public static final String DIRECTORY_LOCK = "directory.lock";
    private static final Logger Log = LogTools.getLogger(FileTools.class);
    private static Map<File, Lock> maps = new HashMap<File, Lock>();

    public static void appendFile(File source, File destination) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        if (FileTools.equalsOnSystem(source, destination)) {
            return;
        }
        try {
            try {
                is = new FileInputStream(source);
                os = new FileOutputStream(destination, true);
                StreamTools.copyStream(is, false, os, false);
            }
            catch (Exception e) {
                throw new IOException("copying failed (" + e.getMessage() + ")");
            }
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close(is);
        StreamTools.close(os);
    }

    public static File checkDirectory(File dir, boolean create, boolean checkCanRead, boolean checkCanWrite) throws IOException {
        if (dir == null) {
            return dir;
        }
        if (!dir.exists() && create) {
            dir.mkdirs();
        }
        if (!dir.exists()) {
            throw new IOException("Can't create directory " + dir.getPath());
        }
        if (!dir.isDirectory()) {
            throw new IOException("Can't create directory " + dir.getPath());
        }
        if (checkCanRead && !dir.canRead()) {
            throw new IOException("No read access for directory " + dir.getPath());
        }
        if (checkCanWrite && !dir.canWrite()) {
            throw new IOException("No write access for directory " + dir.getPath());
        }
        return dir;
    }

    public static File checkDirectory(String path, boolean create, boolean checkCanRead, boolean checkCanWrite) throws IOException {
        return FileTools.checkDirectory(new File(path), create, checkCanRead, checkCanWrite);
    }

    public static void copyBinaryFile(File source, File destination) throws IOException {
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(source);
            os = new FileOutputStream(destination);
            StreamTools.copyStream(is, os);
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close(is);
        StreamTools.close(os);
        destination.setLastModified(source.lastModified());
    }

    public static void copyFile(File source, File destination) throws IOException {
        FileTools.copyBinaryFile(source, destination);
    }

    public static void copyFile(File source, String sourceEncoding, File destination, String destinationEncoding) throws IOException {
        if (sourceEncoding == null || destinationEncoding == null || sourceEncoding.equals(destinationEncoding)) {
            FileTools.copyBinaryFile(source, destination);
            return;
        }
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            try {
                is = new FileInputStream(source);
                os = new FileOutputStream(destination);
                StreamTools.copyEncodedStream(is, sourceEncoding, os, destinationEncoding);
            }
            catch (Exception e) {
                throw new IOException("copying failed (" + e.getMessage() + ")");
            }
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close(is);
        StreamTools.close(os);
    }

    public static void copyRecursively(File source, File destination) throws IOException {
        if (source.isFile()) {
            FileTools.copyFile(source, destination);
            return;
        }
        if (!source.isDirectory()) {
            throw new IOException("file '" + source.getAbsolutePath() + "' does not exist.");
        }
        if (destination.isFile()) {
            throw new IOException("cannot copy directory into file");
        }
        destination.mkdirs();
        String[] content = source.list();
        int i = 0;
        while (i < content.length) {
            FileTools.copyRecursively(new File(source, content[i]), new File(destination, content[i]));
            ++i;
        }
    }

    public static File copyRecursivelyInto(File source, File destinationParent, String newName) throws IOException {
        if (destinationParent.isFile()) {
            throw new IOException("can't copy into file");
        }
        String destinationName = newName == null ? source.getName() : newName;
        File destinationFile = new File(destinationParent, destinationName);
        if (source.equals(destinationFile)) {
            return destinationFile;
        }
        if (source.isFile()) {
            FileTools.copyFile(source, destinationFile);
            return destinationFile;
        }
        if (!source.isDirectory()) {
            throw new IOException("file '" + source.getAbsolutePath() + "' does not exist.");
        }
        String[] content = source.list();
        destinationFile.mkdirs();
        int i = 0;
        while (i < content.length) {
            FileTools.copyRecursivelyInto(new File(source, content[i]), destinationFile, content[i]);
            ++i;
        }
        return destinationFile;
    }

    public static void createEmptyFile(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        StreamTools.close(os);
    }

    public static File createTempFile(File file) throws IOException {
        String extension;
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            extension = name.substring(index);
            name = name.substring(0, index);
        } else {
            extension = "";
        }
        if (name.length() < 3) {
            name = "tmp" + name;
        }
        return TempTools.createTempFile(name, extension);
    }

    public static File createTempFile(String filename) throws IOException {
        return FileTools.createTempFile(new File(filename));
    }

    public static void deleteAfter(File directory, long millis, boolean recursiveScan) throws IOException {
        if (millis <= 0L) {
            return;
        }
        String[] fileNames = directory.list();
        if (fileNames == null) {
            throw new IOException("can not list " + directory);
        }
        long checkMillis = System.currentTimeMillis() - millis;
        int j = 0;
        while (j < fileNames.length) {
            File file = new File(directory, fileNames[j]);
            if (file.isDirectory() && recursiveScan) {
                FileTools.deleteAfter(file, millis, recursiveScan);
            }
            if (file.lastModified() < checkMillis) {
                file.delete();
            }
            ++j;
        }
    }

    public static boolean deleteRecursivly(File file) {
        return FileTools.deleteRecursivly(file, true);
    }

    public static boolean deleteRecursivly(File file, boolean deleteRoot) {
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        String[] files = file.list();
        if (files == null) {
            return false;
        }
        if (files.length == 0) {
            return file.delete();
        }
        int i = 0;
        while (i < files.length) {
            if (!FileTools.deleteRecursivly(new File(file, files[i]))) {
                return false;
            }
            ++i;
        }
        if (deleteRoot) {
            return file.delete();
        }
        return true;
    }

    public static boolean equalsOnSystem(File source, File destination) {
        try {
            if (FileTools.isWindows()) {
                return source.getCanonicalPath().equalsIgnoreCase(destination.getCanonicalPath());
            }
            return source.getCanonicalPath().equals(destination.getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getBaseName(File file) {
        if (file == null) {
            return FileTools.getBaseName(null, "");
        }
        return FileTools.getBaseName(file.getName(), "");
    }

    public static String getBaseName(File file, String defaultName) {
        if (file == null) {
            return FileTools.getBaseName(null, defaultName);
        }
        return FileTools.getBaseName(file.getName(), defaultName);
    }

    public static String getBaseName(String filename) {
        return FileTools.getBaseName(filename, "");
    }

    public static String getBaseName(String filename, String defaultName) {
        if (StringTools.isEmpty(filename)) {
            return defaultName;
        }
        int dotPos = filename.lastIndexOf(46);
        if (dotPos >= 1) {
            return filename.substring(0, dotPos);
        }
        return filename;
    }

    public static String getEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String getExtension(File file) {
        return FileTools.getExtension(file.getName(), "");
    }

    public static String getExtension(String filename) {
        return FileTools.getExtension(filename, "");
    }

    public static String getExtension(String filename, String defaultName) {
        if (StringTools.isEmpty(filename)) {
            return defaultName;
        }
        int dotPos = filename.lastIndexOf(46);
        if (dotPos >= 0) {
            return filename.substring(dotPos + 1);
        }
        return defaultName;
    }

    public static String getFileName(String filename) {
        return FileTools.getFileName(filename, "");
    }

    public static String getFileName(String filename, String defaultName) {
        if (StringTools.isEmpty(filename)) {
            return defaultName;
        }
        int dotPos = filename.lastIndexOf(47);
        if (dotPos >= 0) {
            if (dotPos == filename.length() - 1) {
                return defaultName;
            }
            filename = filename.substring(dotPos + 1);
        }
        if ((dotPos = filename.lastIndexOf(92)) >= 0) {
            if (dotPos == filename.length() - 1) {
                return defaultName;
            }
            filename = filename.substring(dotPos + 1);
        }
        return filename;
    }

    public static File getParentFile(File file) {
        String grandpaPath;
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            parentFile = file.getAbsoluteFile().getParentFile();
        }
        if (parentFile == null) {
            return null;
        }
        File grandpa = parentFile.getParentFile();
        if (grandpa != null && (grandpaPath = grandpa.getAbsolutePath()).equals("\\\\")) {
            return null;
        }
        return parentFile;
    }

    private static List getPathList(File f) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        File r = f.getCanonicalFile();
        while (r != null) {
            if (r.getName().length() == 0) {
                int dblptIndex = r.getPath().indexOf(":");
                if (dblptIndex == -1) {
                    l.add("");
                } else {
                    l.add(r.getPath().substring(0, dblptIndex));
                }
            } else {
                l.add(r.getName());
            }
            r = r.getParentFile();
        }
        ArrayList reversed = new ArrayList();
        int i = l.size() - 1;
        while (i >= 0) {
            reversed.add(l.get(i));
            --i;
        }
        return reversed;
    }

    public static String getPathRelativeTo(File file, File base) throws IOException {
        String relativePath = null;
        if (base != null) {
            List fileList = FileTools.getPathList(file);
            List baseList = FileTools.getPathList(base);
            relativePath = FileTools.matchPathLists(fileList, baseList);
        }
        if (relativePath == null) {
            return file.getAbsolutePath();
        }
        return relativePath;
    }

    public static String getPathRelativeTo(File file, File base, boolean ifAncestor) {
        if (base == null) {
            return file.getPath();
        }
        if (FileTools.isAncestor(base, file)) {
            try {
                return FileTools.getPathRelativeTo(file, base);
            }
            catch (IOException e) {
                return file.getPath();
            }
        }
        return file.getPath();
    }

    public static boolean isAncestor(File parent, File descendant) {
        if (parent == null) {
            return false;
        }
        File current = descendant;
        while (!parent.equals(current)) {
            if (current == null) {
                return false;
            }
            current = current.getParentFile();
        }
        return true;
    }

    public static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock lock(File file) {
        Map<File, Lock> map = maps;
        synchronized (map) {
            block10: {
                if (maps.get(file) == null) break block10;
                return null;
            }
            FileOutputStream os = null;
            AbstractInterruptibleChannel channel = null;
            File lockFile = null;
            try {
                lockFile = file.isFile() ? new File(String.valueOf(file.getAbsolutePath()) + ".lock") : new File(file, DIRECTORY_LOCK);
                os = new FileOutputStream(lockFile);
                channel = os.getChannel();
                ((FileChannel)channel).tryLock();
                Lock lock = new Lock();
                lock.file = file;
                lock.lockFile = lockFile;
                lock.lockStream = os;
                maps.put(file, lock);
                return lock;
            }
            catch (Exception e) {
                StreamTools.close(os);
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (lockFile != null) {
                    lockFile.delete();
                }
                return null;
            }
        }
    }

    private static String matchPathLists(List fileList, List baseList) {
        Iterator sourceIterator = baseList.iterator();
        Iterator targetIterator = fileList.iterator();
        boolean intersection = false;
        while (sourceIterator.hasNext() && targetIterator.hasNext()) {
            if (!sourceIterator.next().equals(targetIterator.next())) break;
            sourceIterator.remove();
            targetIterator.remove();
            intersection = true;
        }
        if (!intersection) {
            return null;
        }
        String relPath = "";
        int i = 0;
        while (i < baseList.size()) {
            relPath = String.valueOf(relPath) + ".." + File.separator;
            ++i;
        }
        Iterator i2 = fileList.iterator();
        while (i2.hasNext()) {
            relPath = String.valueOf(relPath) + i2.next();
            if (!i2.hasNext()) continue;
            relPath = String.valueOf(relPath) + File.separator;
        }
        return relPath;
    }

    public static void renameFile(File source, File destination) throws IOException {
        FileTools.renameFile(source, null, destination, null);
    }

    public static void renameFile(File source, String sourceEncoding, File destination, String destinationEncoding) throws IOException {
        if (source.getCanonicalFile().equals(destination.getCanonicalFile())) {
            return;
        }
        if (sourceEncoding != null && destinationEncoding != null && !sourceEncoding.equals(destinationEncoding) || !source.renameTo(destination)) {
            FileTools.copyFile(source, sourceEncoding, destination, destinationEncoding);
            if (!source.delete()) {
                destination.delete();
                throw new IOException("deleting " + source + " failed");
            }
        }
    }

    public static File resolvePath(File parent, String path) {
        if (StringTools.isEmpty(path)) {
            return parent == null ? new File("") : parent;
        }
        if (parent == null) {
            return new File(path);
        }
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(parent, path);
    }

    public static byte[] toBytes(File file) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            byte[] byArray = StreamTools.toByteArray(is);
            return byArray;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public static String toString(File file) throws IOException {
        return FileTools.toString(file, System.getProperty("file.encoding"));
    }

    public static String toString(File file, String encoding) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            String string = StreamTools.toString(is, encoding);
            return string;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public static String trimPath(String param) {
        if (param == null) {
            return null;
        }
        String tmp = param.trim();
        String drivePrefix = "";
        if (tmp.length() >= 2 && tmp.charAt(1) == ':') {
            drivePrefix = tmp.substring(0, 2);
            tmp = tmp.substring(2);
        }
        tmp = tmp.replaceAll("[\\*\"\\?\\<\\>\\|\\:!\\n\\t\\r\\f]", "_");
        return String.valueOf(drivePrefix) + tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unlock(Lock lock) {
        Map<File, Lock> map = maps;
        synchronized (map) {
            maps.remove(lock.file);
            lock.valid = false;
            StreamTools.close(lock.lockStream);
            lock.lockFile.delete();
        }
    }

    public static void wait(File file, long timeout, long delay) throws IOException {
        long stop = System.currentTimeMillis() + timeout;
        try {
            while (true) {
                if (file.exists()) {
                    if (delay > 0L) {
                        long oldSize = -1L;
                        long newSize = file.length();
                        while (oldSize != newSize) {
                            oldSize = newSize;
                            Thread.sleep(delay);
                            newSize = file.length();
                        }
                    }
                    return;
                }
                if (System.currentTimeMillis() > stop) {
                    throw new IOException("timeout waiting for " + file.getPath());
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("interrupted waiting for " + file.getPath());
        }
    }

    public static void write(File file, byte[] bytes) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            os.write(bytes);
        }
        finally {
            StreamTools.close(os);
        }
    }

    public static void write(File file, String text) throws IOException {
        FileTools.write(file, text, Charset.defaultCharset().name(), false);
    }

    public static void write(File file, String text, boolean append) throws IOException {
        FileTools.write(file, text, Charset.defaultCharset().name(), append);
    }

    public static void write(File file, String text, String encoding) throws IOException {
        FileTools.write(file, text, encoding, false);
    }

    public static void write(File file, String text, String encoding, boolean append) throws IOException {
        FileOutputStream os = null;
        OutputStreamWriter writer = null;
        try {
            os = new FileOutputStream(file, append);
            writer = new OutputStreamWriter((OutputStream)os, encoding);
            writer.write(text);
        }
        catch (Throwable throwable) {
            StreamTools.close(writer);
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close(writer);
        StreamTools.close(os);
    }

    private FileTools() {
    }

    public static class Lock {
        protected File file;
        protected File lockFile;
        protected FileOutputStream lockStream;
        protected boolean valid = true;

        public synchronized boolean isValid() {
            return this.valid;
        }

        public synchronized void release() {
            FileTools.unlock(this);
        }
    }
}

