/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class ClassResourceLocator
extends CommonLocator {
    private final Class clazz;
    private final String name;
    private final String resolvedName;
    private String encoding;
    private ILocator tempFileLocator;

    public ClassResourceLocator(Class clazz, String name) {
        this.clazz = clazz;
        this.name = name;
        this.resolvedName = this.resolveName(name);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassResourceLocator)) {
            return false;
        }
        return this.getResolvedName().equals(((ClassResourceLocator)obj).getResolvedName());
    }

    public boolean exists() {
        return this.getClazz().getResource(this.getResolvedName()) != null;
    }

    public ILocator getChild(String childName) {
        String child = String.valueOf(this.getResolvedName()) + "/" + childName;
        ClassResourceLocator result = new ClassResourceLocator(this.getClazz(), child);
        return result;
    }

    public Class getClazz() {
        return this.clazz;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    public String getFullName() {
        return this.getResolvedName();
    }

    public InputStream getInputStream() throws IOException {
        return this.getClazz().getResourceAsStream(this.getResolvedName());
    }

    public String getLocalName() {
        if (this.getName() == null) {
            return "unknown";
        }
        return FileTools.getBaseName(this.getName());
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("locator is read only");
    }

    public ILocator getParent() {
        int index = this.getResolvedName().lastIndexOf("/");
        if (index > -1) {
            String parentname = this.getResolvedName().substring(0, index);
            return new ClassResourceLocator(this.getClazz(), parentname);
        }
        return null;
    }

    public synchronized IRandomAccess getRandomAccess() throws IOException {
        if (this.tempFileLocator == null) {
            this.tempFileLocator = this.createTempFileLocator();
        }
        return this.tempFileLocator.getRandomAccess();
    }

    public Reader getReader() throws IOException {
        if (this.getEncoding() == null) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getEncoding());
    }

    public Reader getReader(String newEncoding) throws IOException {
        if (newEncoding == null || newEncoding.equals("")) {
            return this.getReader();
        }
        return new InputStreamReader(this.getInputStream(), newEncoding);
    }

    protected String getResolvedName() {
        return this.resolvedName;
    }

    public String getType() {
        if (this.getName() == null) {
            return "<unknown>";
        }
        return FileTools.getExtension(new File(this.getName()));
    }

    public String getTypedName() {
        if (this.getName() == null) {
            return "<unknown>";
        }
        return new File(this.getName()).getName();
    }

    public Writer getWriter() throws IOException {
        throw new IOException("locator is read only");
    }

    public Writer getWriter(String pEncoding) throws IOException {
        throw new IOException("locator is read only");
    }

    public int hashCode() {
        return this.getResolvedName().hashCode();
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isOutOfSynch() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        return new ILocator[0];
    }

    private String resolveName(String pName) {
        if (pName == null) {
            return pName;
        }
        if (!pName.startsWith("/")) {
            Class<?> c = this.getClazz();
            while (c.isArray()) {
                c = c.getComponentType();
            }
            String baseName = c.getName();
            int index = baseName.lastIndexOf(46);
            if (index != -1) {
                pName = "/" + baseName.substring(0, index).replace('.', '/') + "/" + pName;
            }
        }
        return pName;
    }

    protected void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void synch() {
    }

    public String toString() {
        return this.getResolvedName();
    }

    public URL toURL() {
        return null;
    }
}

