/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.resourcetracker;

import de.intarsys.tools.resourcetracker.IResourceReference;
import de.intarsys.tools.resourcetracker.PhantomResourceReference;
import de.intarsys.tools.resourcetracker.ResourceFinalizer;
import de.intarsys.tools.resourcetracker.SoftResourceReference;
import de.intarsys.tools.resourcetracker.WeakResourceReference;
import java.lang.ref.ReferenceQueue;

public abstract class ResourceTracker {
    private IResourceReference[] references;
    private int next = 0;
    private final ResourceFinalizer finalizer;

    public ResourceTracker() {
        this(500);
    }

    public ResourceTracker(int size) {
        this.references = new IResourceReference[size];
        this.finalizer = ResourceFinalizer.get();
    }

    public ResourceTracker(ResourceFinalizer finalizer) {
        this(finalizer, 500);
    }

    public ResourceTracker(ResourceFinalizer finalizer, int size) {
        this.references = new IResourceReference[size];
        this.finalizer = finalizer;
    }

    protected synchronized IResourceReference add(IResourceReference ref) {
        this.finalizer.ensureStarted();
        if (this.next >= this.references.length) {
            System.gc();
            this.finalizer.drainQueue();
            if (this.next >= this.references.length) {
                IResourceReference[] newReferences = new IResourceReference[this.references.length << 1];
                System.arraycopy(this.references, 0, newReferences, 0, this.references.length);
                this.references = newReferences;
            }
        }
        this.references[this.next++] = ref;
        return ref;
    }

    protected abstract void basicDispose(Object var1);

    protected void dispose(IResourceReference ref) {
        this.remove(ref);
        if (ref.getResource() != null) {
            this.basicDispose(ref.getResource());
        }
    }

    protected ReferenceQueue getQueue() {
        return this.finalizer.getQueue();
    }

    protected synchronized void remove(IResourceReference ref) {
        int length = this.next;
        int i = 0;
        while (i < length) {
            if (this.references[i] == ref) {
                --this.next;
                this.references[i] = this.references[this.next];
                this.references[this.next] = null;
                break;
            }
            ++i;
        }
    }

    public IResourceReference trackPhantom(Object container, Object resource) {
        return this.add(new PhantomResourceReference(container, resource, this));
    }

    public IResourceReference trackSoft(Object container, Object resource) {
        return this.add(new SoftResourceReference(container, resource, this));
    }

    public IResourceReference trackWeak(Object container, Object resource) {
        return this.add(new WeakResourceReference(container, resource, this));
    }
}

