/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.image;

import de.intarsys.cwt.image.ImageException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Node;

public class ImageTools {
    public static String extractJPEGColorSpaceType(ImageReader reader) throws IOException {
        IIOMetadata metadata;
        try {
            metadata = reader.getImageMetadata(0);
        }
        catch (RuntimeException ex) {
            throw new ImageException(ex);
        }
        catch (IIOException ex) {
            throw new ImageException(ex);
        }
        Node node = metadata.getAsTree("javax_imageio_1.0");
        Node allegedChromaNode = node.getFirstChild();
        while (!allegedChromaNode.getLocalName().equals("Chroma")) {
            allegedChromaNode = allegedChromaNode.getNextSibling();
        }
        Node allegedColorNode = allegedChromaNode.getFirstChild();
        while (!allegedColorNode.getLocalName().equals("ColorSpaceType")) {
            allegedColorNode = allegedColorNode.getNextSibling();
        }
        Node name = allegedColorNode.getAttributes().getNamedItem("name");
        if (name == null) {
            throw new ImageException("color space not declared");
        }
        return name.getNodeValue();
    }

    public static String extractJPEGColorSpaceType(InputStream stream) throws IOException {
        ImageInputStream imageStream = ImageIO.createImageInputStream(stream);
        try {
            Iterator<ImageReader> readers = ImageIO.getImageReaders(imageStream);
            if (!readers.hasNext()) {
                throw new ImageException("no reader for this image type");
            }
            ImageReader reader = readers.next();
            try {
                imageStream.reset();
                reader.setInput(imageStream);
                String string = ImageTools.extractJPEGColorSpaceType(reader);
                reader.dispose();
                return string;
            }
            catch (Throwable throwable) {
                reader.dispose();
                throw throwable;
            }
        }
        finally {
            imageStream.close();
        }
    }
}

