/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Graphics;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.fop.apps.Fop;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.render.ps.AbstractPSDocumentGraphics2D;
import org.apache.fop.render.ps.PSGenerator;
import org.apache.fop.render.ps.PSProcSets;

public class PSDocumentGraphics2D
extends AbstractPSDocumentGraphics2D {
    PSDocumentGraphics2D(boolean textAsShapes) {
        super(textAsShapes);
        if (!textAsShapes) {
            this.fontInfo = new FontInfo();
            FontSetup.setup(this.fontInfo, null);
        }
    }

    public PSDocumentGraphics2D(boolean textAsShapes, OutputStream stream, int width, int height) throws IOException {
        this(textAsShapes);
        this.setupDocument(stream, width, height);
    }

    public void nextPage() throws IOException {
        this.closePage();
    }

    protected void writeFileHeader() throws IOException {
        Long pagewidth = new Long(this.width);
        Long pageheight = new Long(this.height);
        this.gen.writeln("%!PS-Adobe-3.0");
        this.gen.writeDSCComment("Creator", new String[]{"Apache FOP " + Fop.getVersion() + ": PostScript Transcoder for SVG"});
        this.gen.writeDSCComment("CreationDate", new Object[]{new Date()});
        this.gen.writeDSCComment("Pages", PSGenerator.ATEND);
        this.gen.writeDSCComment("BoundingBox", new Object[]{ZERO, ZERO, pagewidth, pageheight});
        this.gen.writeDSCComment("EndComments");
        this.gen.writeDSCComment("BeginDefaults");
        this.gen.writeDSCComment("EndDefaults");
        this.gen.writeDSCComment("BeginProlog");
        this.gen.writeDSCComment("EndProlog");
        this.gen.writeDSCComment("BeginSetup");
        PSProcSets.writeFOPStdProcSet(this.gen);
        PSProcSets.writeFOPEPSProcSet(this.gen);
        if (this.fontInfo != null) {
            PSProcSets.writeFontDict(this.gen, this.fontInfo);
        }
        this.gen.writeDSCComment("EndSetup");
    }

    protected void writePageHeader() throws IOException {
        Integer pageNumber = new Integer(this.pagecount);
        this.gen.writeDSCComment("Page", new Object[]{pageNumber.toString(), pageNumber});
        this.gen.writeDSCComment("PageBoundingBox", new Object[]{ZERO, ZERO, new Integer(this.width), new Integer(this.height)});
        this.gen.writeDSCComment("BeginPageSetup");
        this.gen.writeln("<<");
        this.gen.writeln("/PageSize [" + this.width + " " + this.height + "]");
        this.gen.writeln("/ImagingBBox null");
        this.gen.writeln(">> setpagedevice");
        if (this.fontInfo != null) {
            this.gen.writeln("FOPFonts begin");
        }
    }

    protected void writePageTrailer() throws IOException {
        this.gen.writeln("showpage");
        this.gen.writeDSCComment("PageTrailer");
        this.gen.writeDSCComment("EndPage");
    }

    public PSDocumentGraphics2D(PSDocumentGraphics2D g) {
        super(g);
    }

    public Graphics create() {
        return new PSDocumentGraphics2D(this);
    }
}

